/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.config;

import com.github.alienpatois.turtlemancy.config.Config;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static ForgeConfigSpec.IntValue oyster_sand_chance;
    public static ForgeConfigSpec.BooleanValue scute_sand_drop;
    public static ForgeConfigSpec.IntValue scute_sand_drop_chance;
    public static ForgeConfigSpec.IntValue scute_sand_drop_count;
    public static ForgeConfigSpec.IntValue altar_bless_count;
    public static ForgeConfigSpec.IntValue bubble_cd;
    public static ForgeConfigSpec.IntValue self_bubble_cd;
    public static ForgeConfigSpec.IntValue magma_turtle_weight;
    public static ForgeConfigSpec.IntValue redstone_repair_value;
    public static ForgeConfigSpec.BooleanValue bedrock_pickaxe;
    public static ForgeConfigSpec.BooleanValue shell_of_encapsulation;
    public static ForgeConfigSpec.BooleanValue turtlemy_bedrock;

    public static void init(ForgeConfigSpec.Builder server) {
        server.push("general");
        oyster_sand_chance = server.comment("Maximum number of Oyster Sand veins generated in one chunk. [Default: 1750]").defineInRange("oystersand.chance", 1750, 1, 5000);
        scute_sand_drop = server.comment("Set to true if you want scute to have a possibility to drop from beach sand. [Default: True]").define("scutesand.drop", true);
        scute_sand_drop_chance = server.comment("Probability (1/value) of scute droping from beach sand. [Default: 34]").defineInRange("scutesand.chance", 34, 1, 1000);
        scute_sand_drop_count = server.comment("Max ammount of scute drop from a block of sand. [Default: 1]").defineInRange("scutesand.count", 1, 1, 20);
        magma_turtle_weight = server.comment("Set the weight of the Magma Turtle spawns (0 = no spawns). [Default: 20]").defineInRange("magmaturtle.weight", 20, 0, 9999);
        altar_bless_count = server.comment("The ammount of turtle bless/curse needed to load the altar. [Default: 3]").defineInRange("altarbless.count", 3, 1, 100);
        redstone_repair_value = server.comment("The ammount of durability repaired per redstone. [Defaul 16]").defineInRange("redstonerepair.value", 16, 0, 9999);
        server.pop();
        server.push("tweaks");
        shell_of_encapsulation = server.comment("False to disable the Shell of Encapsulation. [Default: True]").define("shell_of_encapsulation.exist", true);
        bedrock_pickaxe = server.comment("False to disable the Bedrock Pickaxe. [Default: True]").define("bedrock_pickaxe.exist", true);
        turtlemy_bedrock = server.comment("False to disable the Turtlemy recipe that turns 1 Bedrock into 9 Fragments of Bedrock. [Default: True]").define("bedrock_pickaxe.turtlemy_tweak", true);
        server.pop();
        server.push("spells");
        bubble_cd = server.comment("The cooldown to the Bubble Spells. [Default: 100]").defineInRange("bubblecd.count", 100, 1, 9999);
        self_bubble_cd = server.comment("The cooldown to the Self Bubble Spells. [Default: 60]").defineInRange("selfbubblecd.count", 60, 1, 9999);
        server.pop();
    }

    public static void bakeConfig() {
        scute_sand_drop = (ForgeConfigSpec.BooleanValue)Config.server_config.get("scutesand.drop");
        scute_sand_drop_chance = (ForgeConfigSpec.IntValue)Config.server_config.get("scutesand.chance");
        scute_sand_drop_count = (ForgeConfigSpec.IntValue)Config.server_config.get("scutesand.count");
        oyster_sand_chance = (ForgeConfigSpec.IntValue)Config.server_config.get("oystersand.chance");
        altar_bless_count = (ForgeConfigSpec.IntValue)Config.server_config.get("altarbless.count");
        bubble_cd = (ForgeConfigSpec.IntValue)Config.server_config.get("bubblecd.count");
        self_bubble_cd = (ForgeConfigSpec.IntValue)Config.server_config.get("selfbubblecd.count");
        magma_turtle_weight = (ForgeConfigSpec.IntValue)Config.server_config.get("magmaturtle.weight");
        redstone_repair_value = (ForgeConfigSpec.IntValue)Config.server_config.get("redstonerepair.value");
        bedrock_pickaxe = (ForgeConfigSpec.BooleanValue)Config.server_config.get("bedrock_pickaxe.exist");
        turtlemy_bedrock = (ForgeConfigSpec.BooleanValue)Config.server_config.get("bedrock_pickaxe.turtlemy_tweak");
        shell_of_encapsulation = (ForgeConfigSpec.BooleanValue)Config.server_config.get("shell_of_encapsulation.exist");
    }
}

