/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.compat.patchouli;

import com.github.alienpatois.turtlemancy.common.recipes.AltarRecipe;
import com.github.alienpatois.turtlemancy.common.recipes.AltarRecipes;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class RitualProcessor
implements IComponentProcessor {
    protected AltarRecipe recipe;

    public void setup(IVariableProvider variables) {
        String recipeId = variables.get("recipe").asString();
        this.recipe = AltarRecipes.getRecipe(new ResourceLocation(recipeId));
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("altar_item")) {
            return IVariable.from((Object)new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(this.recipe.itemInAltar)));
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring("input".length())) - 1;
            if (index >= this.recipe.getRecipe().size() && this.recipe.getRecipe().get((int)0).type != 1) {
                return null;
            }
            if (this.recipe.getRecipe().get((int)0).type == 1) {
                if (index < this.recipe.getRecipe().get((int)0).materials.size()) {
                    AltarRecipe.RitualItem ritualItem = this.recipe.getRecipe().get(0);
                    ItemStack item = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ritualItem.materials.get(index)));
                    return IVariable.from((Object)item);
                }
                if (this.recipe.getRecipe().size() > 1) {
                    index = 1;
                } else {
                    return null;
                }
            }
            AltarRecipe.RitualItem ritualItem = this.recipe.getRecipe().get(index);
            if (ritualItem.type == 0) {
                ResourceLocation itemName = ritualItem.itemName;
                ItemStack item = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(itemName), ritualItem.count);
                return IVariable.from((Object)item);
            }
        } else if (key.equals("sacrifice")) {
            for (AltarRecipe.RitualItem ritual : this.recipe.getRecipe()) {
                if (ritual.type != 2) continue;
                return IVariable.wrap((String)(I18n.func_135052_a((String)"patchouli.turtlemancy.sacrifice", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)ritual.entityType.func_210760_d(), (Object[])new Object[0])));
            }
        } else if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.getOutput());
        }
        return null;
    }
}

