/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.compat.jei;

import com.github.alienpatois.turtlemancy.common.recipes.AltarRecipes;
import com.github.alienpatois.turtlemancy.common.recipes.TurtlemyRecipes;
import com.github.alienpatois.turtlemancy.compat.jei.RitualCategory;
import com.github.alienpatois.turtlemancy.compat.jei.TurtlemyCategory;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class TurtlemancyJeiPlugin
implements IModPlugin {
    public static IRecipeCategory TURTLEMY_CATEGORY;
    public static IRecipeCategory RITUAL_CATEGORY;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("turtlemancy", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        TURTLEMY_CATEGORY = new TurtlemyCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{TURTLEMY_CATEGORY});
        RITUAL_CATEGORY = new RitualCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{RITUAL_CATEGORY});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemInit.TURTLE_CAULDRON.get()), new ResourceLocation[]{TURTLEMY_CATEGORY.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemInit.TURTLE_ALTAR.get()), new ResourceLocation[]{RITUAL_CATEGORY.getUid()});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(TurtlemyRecipes.getWrappedRecipes(), TURTLEMY_CATEGORY.getUid());
        registry.addRecipes(AltarRecipes.getWrappedRecipes(), RITUAL_CATEGORY.getUid());
    }
}

