/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.compat.jei;

import com.github.alienpatois.turtlemancy.common.recipes.AltarRecipe;
import com.github.alienpatois.turtlemancy.compat.jei.RecipeWrappers;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualCategory
implements IRecipeCategory<RecipeWrappers.Ritual> {
    static final ResourceLocation UID = new ResourceLocation("turtlemancy", "ritual");
    private final IDrawable background;
    private final IDrawable slotDrawable;
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static final int width = 100;
    public static final int height = 68;

    public RitualCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("turtlemancy", "textures/guis/jei_recipes.png"), 0, 65, 144, 86);
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class getRecipeClass() {
        return RecipeWrappers.Ritual.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.turtlemancy.ritual", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setIngredients(RecipeWrappers.Ritual wrapper, IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        ItemStack[] v = new ItemStack[]{new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(wrapper.recipe.itemInAltar))};
        inputs.add(Arrays.asList(v));
        for (AltarRecipe.RitualItem ritualItem : wrapper.recipe.getRecipe()) {
            if (ritualItem.type == 0) {
                ItemStack[] valid = new ItemStack[]{new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ritualItem.itemName), ritualItem.count)};
                inputs.add(Arrays.asList(valid));
                continue;
            }
            if (ritualItem.type == 1) {
                for (ResourceLocation name : ritualItem.materials) {
                    ItemStack[] valid = new ItemStack[]{new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(name))};
                    inputs.add(Arrays.asList(valid));
                }
                continue;
            }
            if (ritualItem.type != 2) continue;
        }
        ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)wrapper.recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout layout, RecipeWrappers.Ritual recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        int index = 1;
        int[] slotX = new int[]{23, 45, 1, 67};
        int[] slotY = new int[]{69, 69, 58, 58};
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.init(index, true, 34, 1);
        guiItemStacks.set(index, (List)inputs.get(0));
        ++index;
        for (int i = 0; i < 4; ++i) {
            guiItemStacks.init(index, true, slotX[i], slotY[i]);
            if (inputs.size() >= i + 2) {
                guiItemStacks.set(index, (List)inputs.get(i + 1));
            }
            ++index;
        }
        guiItemStacks.init(0, false, 122, 35);
        guiItemStacks.set(0, (List)outputs.get(0));
    }

    public void draw(RecipeWrappers.Ritual recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    public IDrawable getIcon() {
        return null;
    }

    protected static class StackIngredient {
        ItemStack stack;
        Ingredient ingredient;

        public StackIngredient(ItemStack stack, Ingredient ingredient) {
            this.stack = stack;
            this.ingredient = ingredient;
        }
    }
}

