/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.tiles;

import com.github.alienpatois.turtlemancy.Turtlemancy;
import com.github.alienpatois.turtlemancy.common.blocks.TurtleAltar;
import com.github.alienpatois.turtlemancy.common.entities.MagmaTurtleEntity;
import com.github.alienpatois.turtlemancy.config.CommonConfig;
import com.github.alienpatois.turtlemancy.core.init.EnchantmentInit;
import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import com.github.alienpatois.turtlemancy.core.init.TileEntityTypeInit;
import com.github.alienpatois.turtlemancy.core.util.CoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TurtleAltarTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity {
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    int loaded = 0;
    int fedTimes = 0;
    private static final int FED_LIMIT = (Integer)CommonConfig.altar_bless_count.get();
    int tickNum = 0;

    public TurtleAltarTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TurtleAltarTileEntity() {
        this((TileEntityType)TileEntityTypeInit.TURTLE_ALTAR_TE.get());
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    public void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.turtlemancy.turtle_altar");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return null;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemStack) && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemStack);
        this.items.set(index, (Object)stack.func_77946_l());
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (!flag) {
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !stack.func_77951_h();
    }

    public void func_174888_l() {
        super.func_174888_l();
        this.items.clear();
    }

    public void setLoaded(int f) {
        this.loaded = f;
    }

    public boolean isLoaded() {
        return this.loaded > 0;
    }

    public int getLoaded() {
        return this.loaded;
    }

    public void setFedTimes(int f, int level) {
        if (f < 0) {
            this.fedTimes = 0;
        } else if (f > FED_LIMIT) {
            f = FED_LIMIT;
        }
        this.fedTimes = f;
        if (this.loaded <= 0 && this.fedTimes > FED_LIMIT) {
            this.setLoaded(level);
        }
    }

    public void emptyFedTimes() {
        TurtleAltar.emptyFedTimes(this.field_145850_b, this.field_174879_c);
        this.setLoaded(0);
        this.setFedTimes(0, 0);
    }

    public void addFedTimes(int level) {
        ++this.fedTimes;
        if (this.fedTimes >= FED_LIMIT) {
            this.setLoaded(level);
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        int tileEntityType = 42;
        return new SUpdateTileEntityPacket(this.func_174877_v(), tileEntityType, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_230337_a_(blockState, pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(BlockState blockState, CompoundNBT parentNBTTagCompound) {
        this.func_230337_a_(blockState, parentNBTTagCompound);
    }

    public CompoundNBT func_189515_b(CompoundNBT parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        parentNBTTagCompound.func_74768_a("loaded", this.loaded);
        parentNBTTagCompound.func_74768_a("fedTimes", this.fedTimes);
        ItemStackHelper.func_191282_a((CompoundNBT)parentNBTTagCompound, this.items);
        return parentNBTTagCompound;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT parentNBTTagCompound) {
        super.func_230337_a_(blockState, parentNBTTagCompound);
        if (parentNBTTagCompound.func_74764_b("loaded")) {
            this.loaded = parentNBTTagCompound.func_74762_e("loaded");
            this.setLoaded(this.loaded);
        }
        if (parentNBTTagCompound.func_74764_b("fedTimes")) {
            this.fedTimes = parentNBTTagCompound.func_74762_e("fedTimes");
        }
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)parentNBTTagCompound, this.items);
    }

    public void func_73660_a() {
        if (!this.func_145830_o()) {
            return;
        }
        World world = this.func_145831_w();
        if (world.field_72995_K) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        if (!this.isLoaded()) {
            return;
        }
        if (this.items.isEmpty() || ((ItemStack)this.items.get(0)).func_77973_b().getRegistryName().equals((Object)Blocks.field_150350_a.getRegistryName())) {
            return;
        }
        List i = serverWorld.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(3.0));
        List m = serverWorld.func_217357_a(MobEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(3.0));
        if (i.isEmpty() && m.isEmpty()) {
            return;
        }
        ++this.tickNum;
        if (this.tickNum < 60) {
            return;
        }
        this.tickNum = 0;
        ItemStack result = this.turtleRitualFinder(i, m, (ItemStack)this.func_190576_q().get(0), (World)serverWorld);
        if (!result.func_190926_b()) {
            this.func_70299_a(0, result);
            this.setFedTimes(0, 0);
            this.setLoaded(0);
            TurtleAltar.emptyFedTimes(world, this.field_174879_c);
            serverWorld.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 1.0f, 1.0f);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197627_t, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 2.0, (double)this.func_174877_v().func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public ItemStack turtleRitualFinder(List<ItemEntity> items, List<MobEntity> mobs, ItemStack itemInAltar, World w) {
        Object e;
        Object turtleentity;
        ResourceLocation itemInAltarName = itemInAltar.func_77973_b().getRegistryName();
        boolean worked = false;
        ArrayList<Object> materials = new ArrayList<ResourceLocation>();
        if (itemInAltarName.equals((Object)ItemInit.OYSTER.getId()) && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, Items.field_196128_bn.getRegistryName(), items, 10))) {
            TurtleAltarTileEntity.removeBasicRitual(itemInAltar, Items.field_196128_bn.getRegistryName(), items, 10);
            return new ItemStack((IItemProvider)ItemInit.BEWITCHED_SHELL.get());
        }
        if (itemInAltarName.equals((Object)ItemInit.EMPTY_PEARL.getId())) {
            materials = new ArrayList();
            materials.add(Items.field_221655_bP.getRegistryName());
            materials.add(Items.field_151045_i.getRegistryName());
            materials.add(((Item)ItemInit.FOB.get()).getRegistryName());
            materials.add(((Item)ItemInit.IMPROVED_SCUTE.get()).getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                return new ItemStack((IItemProvider)ItemInit.INDESTRUCTIBLE_PEARL.get());
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.TURTLEMANCER_WAND.getId())) {
            materials = new ArrayList();
            materials.add(((Item)ItemInit.INDESTRUCTIBLE_PEARL.get()).getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                return new ItemStack((IItemProvider)ItemInit.ADVANCED_WAND.get());
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.DARK_TURTLEMANCER_WAND.getId())) {
            materials = new ArrayList();
            materials.add(((Item)ItemInit.INDESTRUCTIBLE_PEARL.get()).getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                return new ItemStack((IItemProvider)ItemInit.DARK_ADVANCED_WAND.get());
            }
        }
        if ((itemInAltar.canApplyAtEnchantingTable(Enchantments.field_180309_e) || itemInAltar.isBookEnchantable(itemInAltar)) && EnchantmentHelper.func_82781_a((ItemStack)itemInAltar).get(Enchantments.field_180309_e) == null && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, Items.field_151008_G.getRegistryName(), items, 30))) {
            for (MobEntity m : mobs) {
                if (!(m instanceof ChickenEntity)) continue;
                m.func_70606_j(0.0f);
                TurtleAltarTileEntity.removeBasicRitual(itemInAltar, Items.field_151008_G.getRegistryName(), items, 30);
                if (itemInAltarName.equals((Object)Items.field_151122_aG.getRegistryName())) {
                    itemInAltar = new ItemStack((IItemProvider)Items.field_151134_bR);
                    itemInAltar.func_77966_a(Enchantments.field_180309_e, 4);
                } else {
                    itemInAltar.func_77966_a(Enchantments.field_180309_e, 4);
                }
                return itemInAltar;
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.HUMAN_PEARL.getId())) {
            materials = new ArrayList();
            materials.add(Items.field_151166_bC.getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                return new ItemStack((IItemProvider)ItemInit.EVIL_HUMAN_PEARL.get());
            }
        }
        if (PotionUtils.func_185191_c((ItemStack)itemInAltar) != Potions.field_185229_a) {
            Potion p = PotionUtils.func_185191_c((ItemStack)itemInAltar);
            worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, Items.field_151032_g.getRegistryName(), items, 20);
            if (worked) {
                TurtleAltarTileEntity.removeBasicRitual(itemInAltar, Items.field_151032_g.getRegistryName(), items, 20);
                return PotionUtils.func_185184_a((ItemStack)new ItemStack((IItemProvider)Items.field_185167_i, 20), (Collection)p.func_185170_a());
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.TURTLE_ESSENCE.getId())) {
            materials = new ArrayList();
            materials.add(ItemInit.BLESSED_PEARL.getId());
            materials.add(Items.field_221739_dF.getRegistryName());
            materials.add(ItemInit.FOB.getId());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                turtleentity = (TurtleEntity)EntityType.field_203099_aq.func_200721_a(w);
                turtleentity.func_70873_a(-5000);
                turtleentity.func_203011_g(this.field_174879_c);
                turtleentity.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.2, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                w.func_217376_c((Entity)turtleentity);
                return new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.TURTLE_ESSENCE.getId())) {
            materials = new ArrayList();
            materials.add(ItemInit.CURSED_PEARL.getId());
            materials.add(Items.field_221858_em.getRegistryName());
            materials.add(ItemInit.IMPROVED_MAGMA_SCUTE.getId());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                turtleentity = (MagmaTurtleEntity)((EntityType)EntityTypeInit.MAGMA_TURTLE.get()).func_200721_a(w);
                turtleentity.func_70873_a(-5000);
                ((MagmaTurtleEntity)((Object)turtleentity)).setHome(this.field_174879_c);
                turtleentity.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.2, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                w.func_217376_c((Entity)turtleentity);
                return new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.HUMAN_ESSENCE.getId())) {
            materials = new ArrayList();
            materials.add(Items.field_221824_dv.getRegistryName());
            materials.add(Items.field_222089_ms.getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                e = (WitchEntity)EntityType.field_200759_ay.func_200721_a(w);
                e.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.4, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                w.func_217376_c((Entity)e);
                return new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.TURTLE_ESSENCE.getId())) {
            materials = new ArrayList();
            materials.add(Items.field_226638_pX_.getRegistryName());
            materials.add(Items.field_221816_dr.getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                e = (SlimeEntity)EntityType.field_200743_ai.func_200721_a(w);
                e.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.4, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                w.func_217376_c((Entity)e);
                return new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.ENDERMAN_ESSENCE.getId())) {
            materials = new ArrayList();
            materials.add(ItemInit.BEWITCHED_SHELL.getId());
            materials.add(Items.field_221659_bR.getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                e = (ShulkerEntity)EntityType.field_200738_ad.func_200721_a(w);
                e.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.4, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                w.func_217376_c((Entity)e);
                return new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.ANIMAL_ESSENCE.getId()) && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, Items.field_196182_dv.getRegistryName(), items, 1))) {
            for (MobEntity m : mobs) {
                if (!(m instanceof HorseEntity)) continue;
                m.func_70606_j(0.0f);
                TurtleAltarTileEntity.removeBasicRitual(itemInAltar, Items.field_196182_dv.getRegistryName(), items, 1);
                SkeletonHorseEntity e2 = (SkeletonHorseEntity)EntityType.field_200742_ah.func_200721_a(w);
                e2.func_110234_j(true);
                e2.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.4, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                w.func_217376_c((Entity)e2);
                return new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.WATER_CREATURE_ESSENCE.getId())) {
            materials = new ArrayList();
            materials.add(Items.field_221965_hO.getRegistryName());
            materials.add(Items.field_221967_hP.getRegistryName());
            materials.add(Items.field_221654_ao.getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                e = (GuardianEntity)EntityType.field_200761_A.func_200721_a(w);
                e.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.4, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                w.func_217376_c((Entity)e);
                return new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }
        if (itemInAltarName.equals((Object)ItemInit.UNDEAD_ESSENCE.getId())) {
            materials = new ArrayList();
            materials.add(Items.field_234797_rz_.getRegistryName());
            materials.add(Items.field_151059_bz.getRegistryName());
            worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
            if (worked) {
                e = (GhastEntity)EntityType.field_200811_y.func_200721_a(w);
                e.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.4, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                w.func_217376_c((Entity)e);
                return new ItemStack((IItemProvider)Items.field_151069_bo);
            }
        }
        if (this.loaded == 2) {
            if (itemInAltarName.equals((Object)Items.field_151156_bN.getRegistryName())) {
                materials = new ArrayList();
                materials.add(Items.field_151073_bk.getRegistryName());
                worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
                if (worked) {
                    return new ItemStack((IItemProvider)ItemInit.NETHER_STAR_OF_FORGIVENESS.get());
                }
            }
            if (itemInAltarName.equals((Object)ItemInit.FOB.getId())) {
                for (MobEntity m : mobs) {
                    if (!(m instanceof TurtleEntity) || ((TurtleEntity)m).func_70874_b() < 0) continue;
                    m.func_70606_j(0.0f);
                    TurtleEntity turtleentity2 = (TurtleEntity)EntityType.field_203099_aq.func_200721_a(w);
                    turtleentity2.func_70873_a(-24000);
                    turtleentity2.func_203011_g(this.field_174879_c);
                    turtleentity2.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.3 + 0.2, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.3, 0.0f, 0.0f);
                    w.func_217376_c((Entity)turtleentity2);
                    itemInAltar = new ItemStack((IItemProvider)Items.field_203183_eM, CoreUtil.getRandomIntInRange(1, 3));
                    return itemInAltar;
                }
            }
            if (itemInAltarName.equals((Object)Items.field_196182_dv.getRegistryName()) && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, ItemInit.CURSED_PEARL.getId(), items, 1))) {
                for (MobEntity m : mobs) {
                    if (!(m instanceof TurtleEntity) || ((TurtleEntity)m).func_70874_b() < 0) continue;
                    m.func_70606_j(0.0f);
                    TurtleAltarTileEntity.removeBasicRitual(itemInAltar, ItemInit.CURSED_PEARL.getId(), items, 1);
                    itemInAltar = new ItemStack((IItemProvider)Items.field_196183_dw);
                    return itemInAltar;
                }
            }
            if ((itemInAltar.canApplyAtEnchantingTable(Enchantments.field_92091_k) || itemInAltar.isBookEnchantable(itemInAltar)) && EnchantmentHelper.func_82781_a((ItemStack)itemInAltar).get(Enchantments.field_92091_k) == null && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, ItemInit.INDESTRUCTIBLE_PEARL.getId(), items, 1))) {
                TurtleAltarTileEntity.removeBasicRitual(itemInAltar, ItemInit.INDESTRUCTIBLE_PEARL.getId(), items, 1);
                if (itemInAltarName.equals((Object)Items.field_151122_aG.getRegistryName())) {
                    itemInAltar = new ItemStack((IItemProvider)Items.field_151134_bR);
                    itemInAltar.func_77966_a(Enchantments.field_92091_k, 3);
                } else {
                    itemInAltar.func_77966_a(Enchantments.field_92091_k, 3);
                }
                return itemInAltar;
            }
            if (itemInAltarName.equals((Object)Items.field_205158_fa.getRegistryName()) && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, Items.field_221958_gk.getRegistryName(), items, 15))) {
                TurtleAltarTileEntity.removeBasicRitual(itemInAltar, Items.field_221958_gk.getRegistryName(), items, 15);
                return new ItemStack((IItemProvider)ItemInit.MAGMA_HEART.get());
            }
        }
        if (this.loaded == 1) {
            if ((itemInAltar.canApplyAtEnchantingTable(Enchantments.field_185307_s) || itemInAltar.isBookEnchantable(itemInAltar)) && EnchantmentHelper.func_82781_a((ItemStack)itemInAltar).get(Enchantments.field_185307_s) == null && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, ItemInit.INDESTRUCTIBLE_PEARL.getId(), items, 1))) {
                TurtleAltarTileEntity.removeBasicRitual(itemInAltar, ItemInit.INDESTRUCTIBLE_PEARL.getId(), items, 1);
                if (itemInAltarName.equals((Object)Items.field_151122_aG.getRegistryName())) {
                    itemInAltar = new ItemStack((IItemProvider)Items.field_151134_bR);
                    itemInAltar.func_77966_a(Enchantments.field_185307_s, 3);
                } else {
                    itemInAltar.func_77966_a(Enchantments.field_185307_s, 3);
                }
                return itemInAltar;
            }
            if (itemInAltarName.equals((Object)Items.field_151048_u.getRegistryName())) {
                materials = new ArrayList();
                materials.add(Items.field_221944_gd.getRegistryName());
                materials.add(Items.field_221646_ak.getRegistryName());
                materials.add(Items.field_221883_fZ.getRegistryName());
                worked = TurtleAltarTileEntity.getMultipleItemRitual(itemInAltar, materials, items);
                if (worked) {
                    return new ItemStack((IItemProvider)Items.field_203184_eO);
                }
            }
            if (itemInAltarName.equals((Object)Items.field_205158_fa.getRegistryName()) && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, Items.field_151043_k.getRegistryName(), items, 6))) {
                TurtleAltarTileEntity.removeBasicRitual(itemInAltar, Items.field_151043_k.getRegistryName(), items, 6);
                return new ItemStack((IItemProvider)ItemInit.HEART_OF_THE_SEA_BRACELET.get());
            }
            if ((itemInAltar.canApplyAtEnchantingTable((Enchantment)EnchantmentInit.TURTLES_AQUA_AFFINITY.get()) || itemInAltar.isBookEnchantable(itemInAltar)) && EnchantmentHelper.func_82781_a((ItemStack)itemInAltar).get(EnchantmentInit.TURTLES_AQUA_AFFINITY.get()) == null && (worked = TurtleAltarTileEntity.getBasicRitual(itemInAltar, ItemInit.IMPROVED_SCUTE.getId(), items, 5))) {
                TurtleAltarTileEntity.removeBasicRitual(itemInAltar, ItemInit.IMPROVED_SCUTE.getId(), items, 5);
                if (itemInAltarName.equals((Object)Items.field_151122_aG.getRegistryName())) {
                    itemInAltar = new ItemStack((IItemProvider)Items.field_151134_bR);
                    itemInAltar.func_77966_a((Enchantment)EnchantmentInit.TURTLES_AQUA_AFFINITY.get(), 1);
                } else {
                    itemInAltar.func_77966_a((Enchantment)EnchantmentInit.TURTLES_AQUA_AFFINITY.get(), 1);
                }
                return itemInAltar;
            }
        }
        if (itemInAltar.func_77951_h() && (Integer)CommonConfig.redstone_repair_value.get() > 0 && (worked = TurtleAltarTileEntity.getRepairRitual(itemInAltar, Items.field_151137_ax.getRegistryName(), items))) {
            return itemInAltar;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean getMultipleItemRitual(ItemStack itemInAltar, List<ResourceLocation> materials, List<ItemEntity> items) {
        ResourceLocation in;
        ArrayList<ResourceLocation> materialsCopy = new ArrayList<ResourceLocation>();
        materialsCopy.addAll(materials);
        for (ItemEntity i : items) {
            in = i.func_92059_d().func_77973_b().getRegistryName();
            if (!materialsCopy.contains(in)) continue;
            materialsCopy.remove(in);
        }
        if (materialsCopy.size() == 0) {
            for (ItemEntity i : items) {
                in = i.func_92059_d().func_77973_b().getRegistryName();
                if (!materials.contains(in)) continue;
                i.func_92059_d().func_190920_e(i.func_92059_d().func_190916_E() - 1);
            }
            return true;
        }
        return false;
    }

    private static void removeBasicRitual(ItemStack itemInAltar, ResourceLocation materialName, List<ItemEntity> items, int count) {
        int currentCount = 0;
        int totalCount = 0;
        ArrayList<ItemEntity> currentItems = new ArrayList<ItemEntity>();
        for (ItemEntity i : items) {
            if (!i.func_92059_d().func_77973_b().getRegistryName().equals((Object)materialName)) continue;
            currentCount = 0;
            for (int n = 0; n < i.func_92059_d().func_190916_E(); ++n) {
                if (++currentCount < count) continue;
                i.func_92059_d().func_190920_e(i.func_92059_d().func_190916_E() - count);
                return;
            }
            currentItems.add(i);
            if ((totalCount += currentCount) < count) continue;
            int itemCount = 0;
            for (ItemEntity a : currentItems) {
                if (totalCount > 0) {
                    totalCount -= (itemCount += a.func_92059_d().func_190916_E());
                    a.func_92059_d().func_190920_e(a.func_92059_d().func_190916_E() - count);
                }
                if (totalCount > 0) continue;
                return;
            }
        }
    }

    private static boolean getBasicRitual(ItemStack itemInAltar, ResourceLocation materialName, List<ItemEntity> items, int count) {
        int currentCount = 0;
        int totalCount = 0;
        ArrayList<ItemEntity> currentItems = new ArrayList<ItemEntity>();
        for (ItemEntity i : items) {
            if (!i.func_92059_d().func_77973_b().getRegistryName().equals((Object)materialName)) continue;
            currentCount = 0;
            for (int n = 0; n < i.func_92059_d().func_190916_E(); ++n) {
                if (++currentCount < count) continue;
                return true;
            }
            currentItems.add(i);
            if ((totalCount += currentCount) < count) continue;
            int itemCount = 0;
            for (ItemEntity a : currentItems) {
                if (totalCount > 0) {
                    itemCount = a.func_92059_d().func_190916_E();
                    totalCount -= itemCount;
                }
                if (totalCount > 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean getRepairRitual(ItemStack itemInAltar, ResourceLocation materialName, List<ItemEntity> items) {
        int repairQ = (Integer)CommonConfig.redstone_repair_value.get();
        boolean atLeastOne = false;
        for (ItemEntity i : items) {
            if (!itemInAltar.func_77951_h()) {
                return true;
            }
            if (!i.func_92059_d().func_77973_b().getRegistryName().equals((Object)materialName)) continue;
            atLeastOne = true;
            if (i.func_92059_d().func_190916_E() > itemInAltar.func_77952_i() / repairQ) {
                Turtlemancy.LOGGER.info("ONE SHOT");
                i.func_92059_d().func_190920_e(i.func_92059_d().func_190916_E() - itemInAltar.func_77952_i() / repairQ);
                itemInAltar.func_196085_b(0);
                continue;
            }
            Turtlemancy.LOGGER.info("MULTIPLE SHOT");
            itemInAltar.func_196085_b(itemInAltar.func_77952_i() - repairQ * i.func_92059_d().func_190916_E());
            i.func_92059_d().func_190920_e(0);
        }
        return atLeastOne;
    }
}

