/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.recipes;

import com.github.alienpatois.turtlemancy.common.recipes.AltarRecipe;
import com.github.alienpatois.turtlemancy.compat.jei.RecipeWrappers;
import com.github.alienpatois.turtlemancy.core.init.EnchantmentInit;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class AltarRecipes {
    public static Map<ResourceLocation, AltarRecipe> recipes = new HashMap<ResourceLocation, AltarRecipe>();

    public static void register(AltarRecipe recipe) {
        ResourceLocation loc = recipe.getRegistryName();
        assert (loc != null);
        recipes.put(loc, recipe);
    }

    public static AltarRecipe getRecipe(ResourceLocation nameIn) {
        return recipes.get(nameIn);
    }

    public static List<RecipeWrappers.Ritual> getWrappedRecipes() {
        ArrayList<RecipeWrappers.Ritual> wrappers = new ArrayList<RecipeWrappers.Ritual>();
        for (Map.Entry<ResourceLocation, AltarRecipe> entry : recipes.entrySet()) {
            wrappers.add(new RecipeWrappers.Ritual(entry.getValue()));
        }
        return wrappers;
    }

    public static void init() {
        ArrayList<ResourceLocation> materials = new ArrayList<ResourceLocation>();
        AltarRecipe repair = new AltarRecipe(Items.field_151048_u.getRegistryName(), new ItemStack((IItemProvider)Items.field_151048_u), new ResourceLocation("turtlemancy", "repair_ritual"));
        repair.addItem(Items.field_151137_ax.getRegistryName(), 1);
        AltarRecipes.register(repair);
        AltarRecipe bewitchedShell = new AltarRecipe(ItemInit.OYSTER.getId(), new ItemStack((IItemProvider)ItemInit.BEWITCHED_SHELL.get()));
        bewitchedShell.addItem(Items.field_196128_bn.getRegistryName(), 10);
        AltarRecipes.register(bewitchedShell);
        AltarRecipe indestruciblePearl = new AltarRecipe(ItemInit.EMPTY_PEARL.getId(), new ItemStack((IItemProvider)ItemInit.INDESTRUCTIBLE_PEARL.get()));
        materials.add(Items.field_221655_bP.getRegistryName());
        materials.add(Items.field_151045_i.getRegistryName());
        materials.add(((Item)ItemInit.FOB.get()).getRegistryName());
        materials.add(((Item)ItemInit.IMPROVED_SCUTE.get()).getRegistryName());
        indestruciblePearl.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(indestruciblePearl);
        AltarRecipe advancedWand = new AltarRecipe(ItemInit.TURTLEMANCER_WAND.getId(), new ItemStack((IItemProvider)ItemInit.ADVANCED_WAND.get()));
        advancedWand.addItem(ItemInit.INDESTRUCTIBLE_PEARL.getId(), 1);
        AltarRecipes.register(advancedWand);
        AltarRecipe darkAdvancedWand = new AltarRecipe(ItemInit.DARK_TURTLEMANCER_WAND.getId(), new ItemStack((IItemProvider)ItemInit.DARK_ADVANCED_WAND.get()));
        darkAdvancedWand.addItem(ItemInit.INDESTRUCTIBLE_PEARL.getId(), 1);
        AltarRecipes.register(darkAdvancedWand);
        ItemStack enchantedBoots = new ItemStack((IItemProvider)ItemInit.TURTLE_BOOTS.get());
        enchantedBoots.func_77966_a(Enchantments.field_180309_e, 3);
        AltarRecipe featherFalling = new AltarRecipe(ItemInit.TURTLE_BOOTS.getId(), enchantedBoots);
        featherFalling.addItem(Items.field_151008_G.getRegistryName(), 30);
        featherFalling.addMob(EntityType.field_200795_i);
        AltarRecipes.register(featherFalling);
        AltarRecipe evilHumanPearl = new AltarRecipe(ItemInit.HUMAN_PEARL.getId(), new ItemStack((IItemProvider)ItemInit.EVIL_HUMAN_PEARL.get()));
        evilHumanPearl.addItem(Items.field_151166_bC.getRegistryName(), 1);
        AltarRecipes.register(evilHumanPearl);
        AltarRecipe tippedRecipe = new AltarRecipe(Items.field_151068_bn.getRegistryName(), new ItemStack((IItemProvider)Items.field_185167_i, 30), new ResourceLocation("turtlemancy", "tipped_arrows"));
        tippedRecipe.addItem(Items.field_151032_g.getRegistryName(), 30);
        AltarRecipes.register(tippedRecipe);
        AltarRecipe summonTurtle = new AltarRecipe(ItemInit.TURTLE_ESSENCE.getId(), new ItemStack((IItemProvider)Items.field_151069_bo), new ResourceLocation("turtlemancy", "summon_turtle"));
        materials.add(ItemInit.FOB.getId());
        materials.add(Items.field_221739_dF.getRegistryName());
        materials.add(((Item)ItemInit.BLESSED_PEARL.get()).getRegistryName());
        summonTurtle.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(summonTurtle);
        AltarRecipe summonMagmaTurtle = new AltarRecipe(ItemInit.TURTLE_ESSENCE.getId(), new ItemStack((IItemProvider)Items.field_151069_bo), new ResourceLocation("turtlemancy", "summon_magma_turtle"));
        materials.add(ItemInit.IMPROVED_MAGMA_SCUTE.getId());
        materials.add(Items.field_221858_em.getRegistryName());
        materials.add(((Item)ItemInit.CURSED_PEARL.get()).getRegistryName());
        summonMagmaTurtle.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(summonMagmaTurtle);
        AltarRecipe summonWitch = new AltarRecipe(ItemInit.HUMAN_ESSENCE.getId(), new ItemStack((IItemProvider)Items.field_151069_bo), new ResourceLocation("turtlemancy", "summon_witch"));
        materials.add(Items.field_222089_ms.getRegistryName());
        materials.add(Items.field_221824_dv.getRegistryName());
        summonWitch.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(summonWitch);
        AltarRecipe summonSlime = new AltarRecipe(ItemInit.TURTLE_ESSENCE.getId(), new ItemStack((IItemProvider)Items.field_151069_bo), new ResourceLocation("turtlemancy", "summon_slime"));
        materials.add(Items.field_226638_pX_.getRegistryName());
        materials.add(Items.field_221816_dr.getRegistryName());
        summonSlime.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(summonSlime);
        AltarRecipe summonShulker = new AltarRecipe(ItemInit.ENDERMAN_ESSENCE.getId(), new ItemStack((IItemProvider)Items.field_151069_bo), new ResourceLocation("turtlemancy", "summon_shulker"));
        materials.add(ItemInit.BEWITCHED_SHELL.getId());
        materials.add(Items.field_221659_bR.getRegistryName());
        summonShulker.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(summonShulker);
        AltarRecipe summonSkeletonHorse = new AltarRecipe(ItemInit.ANIMAL_ESSENCE.getId(), new ItemStack((IItemProvider)Items.field_151069_bo), new ResourceLocation("turtlemancy", "summon_skeleton_horse"));
        summonSkeletonHorse.addItem(Items.field_196182_dv.getRegistryName(), 1);
        summonSkeletonHorse.addMob(EntityType.field_200762_B);
        AltarRecipes.register(summonSkeletonHorse);
        AltarRecipe summonGuardian = new AltarRecipe(ItemInit.WATER_CREATURE_ESSENCE.getId(), new ItemStack((IItemProvider)Items.field_151069_bo), new ResourceLocation("turtlemancy", "summon_guardian"));
        materials.add(Items.field_221967_hP.getRegistryName());
        materials.add(Items.field_221965_hO.getRegistryName());
        materials.add(Items.field_221654_ao.getRegistryName());
        summonGuardian.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(summonGuardian);
        AltarRecipe summonGhast = new AltarRecipe(ItemInit.UNDEAD_ESSENCE.getId(), new ItemStack((IItemProvider)Items.field_151069_bo), new ResourceLocation("turtlemancy", "summon_ghast"));
        materials.add(Items.field_234797_rz_.getRegistryName());
        materials.add(Items.field_151059_bz.getRegistryName());
        summonGhast.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(summonGhast);
        AltarRecipe forgiveness = new AltarRecipe(Items.field_151156_bN.getRegistryName(), new ItemStack((IItemProvider)ItemInit.NETHER_STAR_OF_FORGIVENESS.get()));
        forgiveness.addItem(Items.field_151073_bk.getRegistryName(), 1);
        AltarRecipes.register(forgiveness);
        AltarRecipe deathAndLife = new AltarRecipe(ItemInit.FOB.getId(), new ItemStack((IItemProvider)Items.field_203183_eM, 2), new ResourceLocation("turtlemancy", "death_and_life"));
        deathAndLife.addMob(EntityType.field_203099_aq);
        AltarRecipes.register(deathAndLife);
        AltarRecipe witherSkull = new AltarRecipe(Items.field_196182_dv.getRegistryName(), new ItemStack((IItemProvider)Items.field_196183_dw));
        witherSkull.addItem(ItemInit.CURSED_PEARL.getId(), 1);
        witherSkull.addMob(EntityType.field_203099_aq);
        AltarRecipes.register(witherSkull);
        ItemStack enchantedChest = new ItemStack((IItemProvider)ItemInit.TURTLE_CHESTPLATE.get());
        enchantedChest.func_77966_a(Enchantments.field_92091_k, 3);
        AltarRecipe thorns = new AltarRecipe(ItemInit.TURTLE_CHESTPLATE.getId(), enchantedChest, new ResourceLocation("turtlemancy", "thorns"));
        thorns.addItem(ItemInit.INDESTRUCTIBLE_PEARL.getId(), 1);
        AltarRecipes.register(thorns);
        enchantedChest = new ItemStack((IItemProvider)ItemInit.TURTLE_CHESTPLATE.get());
        enchantedChest.func_77966_a(Enchantments.field_185307_s, 3);
        AltarRecipe unbreaking = new AltarRecipe(ItemInit.TURTLE_CHESTPLATE.getId(), enchantedChest, new ResourceLocation("turtlemancy", "unbreaking"));
        unbreaking.addItem(ItemInit.INDESTRUCTIBLE_PEARL.getId(), 1);
        AltarRecipes.register(unbreaking);
        AltarRecipe trident = new AltarRecipe(Items.field_151048_u.getRegistryName(), new ItemStack((IItemProvider)Items.field_203184_eO));
        materials.add(Items.field_221944_gd.getRegistryName());
        materials.add(Items.field_221646_ak.getRegistryName());
        materials.add(Items.field_221883_fZ.getRegistryName());
        trident.addMaterials(materials);
        materials.clear();
        AltarRecipes.register(trident);
        AltarRecipe bracelet = new AltarRecipe(Items.field_205158_fa.getRegistryName(), new ItemStack((IItemProvider)ItemInit.HEART_OF_THE_SEA_BRACELET.get()));
        bracelet.addItem(Items.field_151043_k.getRegistryName(), 6);
        AltarRecipes.register(bracelet);
        AltarRecipe magmaHeart = new AltarRecipe(Items.field_205158_fa.getRegistryName(), new ItemStack((IItemProvider)ItemInit.MAGMA_HEART.get()));
        magmaHeart.addItem(Items.field_221958_gk.getRegistryName(), 15);
        AltarRecipes.register(magmaHeart);
        ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        enchantedBook.func_77966_a((Enchantment)EnchantmentInit.TURTLES_AQUA_AFFINITY.get(), 1);
        AltarRecipe turtlesAffinity = new AltarRecipe(Items.field_151122_aG.getRegistryName(), enchantedBook, new ResourceLocation("turtlemancy", "affinity"));
        turtlesAffinity.addItem(ItemInit.IMPROVED_SCUTE.getId(), 5);
        AltarRecipes.register(turtlesAffinity);
    }
}

