/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AltarRecipe {
    public ResourceLocation registryName;
    public ResourceLocation itemInAltar;
    public List<RitualItem> recipe = new ArrayList<RitualItem>();
    public ItemStack output;

    public AltarRecipe(ResourceLocation itemInAltarName, ItemStack outputIn) {
        this.output = outputIn;
        this.itemInAltar = itemInAltarName;
        this.registryName = outputIn.func_77973_b().getRegistryName();
    }

    public AltarRecipe(ResourceLocation itemInAltarName, ItemStack outputIn, ResourceLocation registryNameIn) {
        this.output = outputIn;
        this.itemInAltar = itemInAltarName;
        this.registryName = registryNameIn;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public List<RitualItem> getRecipe() {
        return this.recipe;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String name, String path) {
        this.registryName = new ResourceLocation(name, path);
    }

    public void addItem(ResourceLocation name, int count) {
        this.recipe.add(new RitualItem(name, count));
    }

    public void addMaterials(List<ResourceLocation> materials) {
        ArrayList<ResourceLocation> m = new ArrayList<ResourceLocation>();
        m.addAll(materials);
        this.recipe.add(new RitualItem(m));
    }

    public void addMob(EntityType<?> type) {
        this.recipe.add(new RitualItem(type));
    }

    public class RitualItem {
        public List<ResourceLocation> materials = new ArrayList<ResourceLocation>();
        public int count;
        public ResourceLocation itemName;
        public EntityType<?> entityType;
        public int type = -1;

        public RitualItem(ResourceLocation itemNameIn, int countIn) {
            this.itemName = itemNameIn;
            this.count = countIn;
            this.type = 0;
        }

        public RitualItem(List<ResourceLocation> materialsIn) {
            this.materials = materialsIn;
            this.type = 1;
        }

        public RitualItem(EntityType<?> typeIn) {
            this.type = 2;
            this.entityType = typeIn;
        }
    }
}

