/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.items;

import com.github.alienpatois.turtlemancy.client.util.KeyboardHelper;
import com.github.alienpatois.turtlemancy.common.entities.BubbleEntity;
import com.github.alienpatois.turtlemancy.common.entities.BubbleProjectile;
import com.github.alienpatois.turtlemancy.config.CommonConfig;
import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import com.github.alienpatois.turtlemancy.core.util.CoreUtil;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;

public class TurtlemancerWand
extends Item {
    private int wandPower = 0;
    private boolean evil = false;
    public int castModifier = 1;
    public Random rand = new Random();

    public TurtlemancerWand(Item.Properties properties, int wP, boolean e) {
        super(properties);
        this.wandPower = wP;
        this.evil = e;
        this.castModifier = 1;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        int n = 40;
        n = this.wandPower == 0 ? 32 : (this.wandPower == 1 ? 22 : 8);
        return n / this.castModifier;
    }

    public boolean func_77645_m() {
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (KeyboardHelper.isHoldingShift()) {
            String str = "No info";
            switch (this.wandPower) {
                case 0: {
                    str = "item.turtlemancy.turtlemancer_basic_wand.tooltip.line1";
                    break;
                }
                case 1: {
                    str = "item.turtlemancy.turtlemancer_wand.tooltip.line1";
                    break;
                }
                case 2: {
                    str = "item.turtlemancy.turtlemancer_advanced_wand.tooltip.line1";
                }
            }
            tooltip.add((ITextComponent)new TranslationTextComponent(str));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.turtlemancy.tooltip"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (worldIn.field_72995_K) {
            return super.func_77654_b(stack, worldIn, entityLiving);
        }
        ServerWorld serverWorld = (ServerWorld)worldIn;
        ServerPlayerEntity playerIn = (ServerPlayerEntity)entityLiving;
        ((ServerWorld)worldIn).func_184133_a(null, playerIn.func_233580_cy_(), SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!playerIn.func_192039_O().func_192747_a(serverWorld.func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation("turtlemancy:turtlemancer"))).func_192105_a()) {
            playerIn.func_145747_a((ITextComponent)new StringTextComponent("You are not a Turtlemancer."), playerIn.func_110124_au());
            return super.func_77654_b(stack, worldIn, entityLiving);
        }
        if (!stack.func_77984_f() || stack.func_77952_i() >= stack.func_77958_k()) {
            return super.func_77654_b(stack, worldIn, entityLiving);
        }
        stack.func_196085_b(stack.func_77952_i() + 1);
        int manaLeft = stack.func_77958_k() - stack.func_77952_i();
        RayTraceResult lookingAt = CoreUtil.getMouseOver(playerIn);
        if (lookingAt == null) {
            return super.func_77654_b(stack, worldIn, entityLiving);
        }
        int cdModifier = 1;
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.HEART_OF_THE_SEA_BRACELET.get(), (LivingEntity)playerIn).isPresent()) {
            cdModifier = 2;
            this.castModifier = 2;
        } else {
            cdModifier = 1;
            this.castModifier = 1;
        }
        if (lookingAt != null && lookingAt.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Vector3d blockVector = lookingAt.func_216347_e();
            double bX = blockVector.func_82615_a();
            double bY = blockVector.func_82617_b();
            double bZ = blockVector.func_82616_c();
            double pX = playerIn.func_226277_ct_();
            double pY = playerIn.func_226278_cu_();
            double pZ = playerIn.func_226281_cx_();
            if (bX == Math.floor(bX) && bX <= pX) {
                bX -= 1.0;
            }
            if (bY == Math.floor(bY) && bY <= pY + 1.0) {
                bY -= 1.0;
            }
            if (bZ == Math.floor(bZ) && bZ <= pZ) {
                bZ -= 1.0;
            }
            BlockState block = worldIn.func_180495_p(new BlockPos(bX, bY, bZ));
            ResourceLocation blockRegistryName = block.func_177230_c().getRegistryName();
            if (this.wandPower >= 2) {
                if (blockRegistryName.equals((Object)Items.field_221598_z.getRegistryName())) {
                    if (stack.func_77952_i() + (stack.func_77958_k() / 3 - 1) <= stack.func_77958_k()) {
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY + 1.0, bZ, new ItemStack((IItemProvider)ItemInit.LFOB.get())));
                        this.setWandsCoolDown((PlayerEntity)playerIn, 350 / cdModifier);
                        stack.func_196085_b(stack.func_77952_i() + (stack.func_77958_k() / 3 - 1));
                        return super.func_77654_b(stack, worldIn, entityLiving);
                    }
                } else {
                    if (blockRegistryName.equals((Object)Items.field_221770_cu.getRegistryName()) || blockRegistryName.equals((Object)Items.field_222047_ii.getRegistryName()) || blockRegistryName.equals((Object)Items.field_221898_fg.getRegistryName())) {
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY + 1.0, bZ, new ItemStack((IItemProvider)block.func_177230_c().func_199767_j())));
                        this.setWandsCoolDown((PlayerEntity)playerIn, 40 / cdModifier);
                        stack.func_196085_b(stack.func_77952_i() + 20);
                        worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                        return super.func_77654_b(stack, worldIn, entityLiving);
                    }
                    Block b = block.func_177230_c();
                    if (Tags.Blocks.STONE.func_230235_a_((Object)b) || Tags.Blocks.DIRT.func_230235_a_((Object)b) || Tags.Blocks.COBBLESTONE.func_230235_a_((Object)b) || Tags.Blocks.SANDSTONE.func_230235_a_((Object)b) || Tags.Blocks.SAND.func_230235_a_((Object)b) || Tags.Blocks.NETHERRACK.func_230235_a_((Object)b) || Tags.Blocks.END_STONES.func_230235_a_((Object)b)) {
                        worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                        return super.func_77654_b(stack, worldIn, entityLiving);
                    }
                }
            }
            if (this.wandPower >= 1) {
                if (blockRegistryName.equals((Object)Items.field_221655_bP.getRegistryName()) || blockRegistryName.equals((Object)Items.field_234797_rz_.getRegistryName())) {
                    if ((double)stack.func_77952_i() > (double)stack.func_77958_k() * 0.85) {
                        return super.func_77654_b(stack, worldIn, entityLiving);
                    }
                    worldIn.func_175655_b(new BlockPos(bX, bY, bZ), true);
                    this.setWandsCoolDown((PlayerEntity)playerIn, 50 / cdModifier);
                    stack.func_196085_b(stack.func_77952_i() + (stack.func_77958_k() / 4 - 1));
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
                if (blockRegistryName.equals((Object)Items.field_221598_z.getRegistryName()) && stack.func_77952_i() <= 1) {
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY + 1.0, bZ, new ItemStack((IItemProvider)ItemInit.LFOB.get())));
                    this.setWandsCoolDown((PlayerEntity)playerIn, 500 / cdModifier);
                    stack.func_196085_b(stack.func_77958_k());
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
                if (blockRegistryName.equals((Object)Items.field_221550_C.getRegistryName())) {
                    worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY, bZ, new ItemStack((IItemProvider)Items.field_151145_ak)));
                    this.setWandsCoolDown((PlayerEntity)playerIn, 20 / cdModifier);
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
                if (blockRegistryName.equals((Object)Items.field_221776_cx.getRegistryName())) {
                    worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY, bZ, new ItemStack((IItemProvider)Items.field_151119_aD, CoreUtil.getRandomIntInRange(4, 8))));
                    this.setWandsCoolDown((PlayerEntity)playerIn, 10 / cdModifier);
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
            }
            if (this.wandPower >= 0) {
                if (blockRegistryName.equals((Object)Items.field_222066_kO.getRegistryName()) || blockRegistryName.equals((Object)Blocks.field_203215_jy.getRegistryName())) {
                    worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY, bZ, new ItemStack((IItemProvider)Items.field_222066_kO, CoreUtil.getRandomIntInRange((this.wandPower + 1) * 2, (this.wandPower + 1) * 5))));
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
                if (blockRegistryName.equals((Object)Items.field_221943_hD.getRegistryName()) && manaLeft >= 20) {
                    int i = (Integer)block.func_177229_b((Property)BlockStateProperties.field_208127_ab);
                    if (i <= 1) {
                        worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                    } else {
                        worldIn.func_180501_a(new BlockPos(bX, bY, bZ), (BlockState)block.func_206870_a((Property)BlockStateProperties.field_208127_ab, (Comparable)Integer.valueOf(i - 1)), 2);
                        worldIn.func_217379_c(2001, new BlockPos(bX, bY, bZ), Block.func_196246_j((BlockState)block));
                    }
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY, bZ, new ItemStack((IItemProvider)Items.field_221943_hD)));
                    this.setWandsCoolDown((PlayerEntity)playerIn, 100 / cdModifier);
                    stack.func_196085_b(stack.func_77952_i() + 20);
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
                if (blockRegistryName.equals((Object)ItemInit.MAGMA_TURTLE_EGG.getId()) && manaLeft >= 20) {
                    int i = (Integer)block.func_177229_b((Property)BlockStateProperties.field_208127_ab);
                    if (i <= 1) {
                        worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                    } else {
                        worldIn.func_180501_a(new BlockPos(bX, bY, bZ), (BlockState)block.func_206870_a((Property)BlockStateProperties.field_208127_ab, (Comparable)Integer.valueOf(i - 1)), 2);
                        worldIn.func_217379_c(2001, new BlockPos(bX, bY, bZ), Block.func_196246_j((BlockState)block));
                    }
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY, bZ, new ItemStack((IItemProvider)ItemInit.MAGMA_TURTLE_EGG.get())));
                    this.setWandsCoolDown((PlayerEntity)playerIn, 100 / cdModifier);
                    stack.func_196085_b(stack.func_77952_i() + 20);
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
                if (BlockTags.field_204116_z.func_230235_a_((Object)block.func_177230_c()) || BlockTags.field_205598_B.func_230235_a_((Object)block.func_177230_c())) {
                    worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY, bZ, new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(block.func_177230_c().getRegistryName()))));
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
                if (blockRegistryName.equals((Object)Items.field_221600_aB.getRegistryName()) || blockRegistryName.equals((Object)Blocks.field_203199_aR.getRegistryName())) {
                    worldIn.func_175655_b(new BlockPos(bX, bY, bZ), false);
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, bX, bY, bZ, new ItemStack((IItemProvider)Items.field_221600_aB, CoreUtil.getRandomIntInRange((this.wandPower + 1) * 2, (this.wandPower + 1) * 5))));
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
            }
        } else if (playerIn.func_225608_bj_()) {
            if (this.evil) {
                playerIn.func_195064_c(new EffectInstance(Effects.field_76426_n, 300, this.wandPower));
                playerIn.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 0));
            } else {
                playerIn.func_195064_c(new EffectInstance(Effects.field_76429_m, 300, this.wandPower));
                playerIn.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 0));
            }
            this.setWandsCoolDown((PlayerEntity)playerIn, 80 / cdModifier);
        } else {
            boolean shoot = true;
            if (lookingAt.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)lookingAt).func_216348_a();
                boolean bl = shoot = !this.explodeEntity(serverWorld, entity, (PlayerEntity)playerIn);
            }
            if (shoot) {
                BubbleProjectile bubble = this.createBubble((PlayerEntity)playerIn);
                bubble.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
                playerIn.field_70170_p.func_217376_c((Entity)bubble);
            } else {
                stack.func_196085_b(stack.func_77952_i() + 20);
            }
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public void selfBubble(PlayerEntity playerIn) {
        RayTraceResult lookingAt = CoreUtil.getMouseOver((ServerPlayerEntity)playerIn);
        if (this.evil) {
            Vector3d plus = lookingAt.func_216347_e().func_178788_d(playerIn.func_213303_ch());
            BubbleEntity bubbles = new BubbleEntity((EntityType<? extends BubbleEntity>)((EntityType)EntityTypeInit.BUBBLE_ENTITY.get()), playerIn.field_70170_p, this.wandPower * 10, true, 0, lookingAt.func_216347_e().func_178787_e(plus).func_178787_e(plus).func_178787_e(plus), playerIn);
            bubbles.func_174828_a(playerIn.func_233580_cy_().func_177982_a(0, 1, 0), playerIn.field_70177_z, playerIn.field_70125_A);
            playerIn.field_70170_p.func_217376_c((Entity)bubbles);
            playerIn.func_184220_m((Entity)bubbles);
        } else {
            BubbleEntity bubbles = new BubbleEntity((EntityType<? extends BubbleEntity>)((EntityType)EntityTypeInit.BUBBLE_ENTITY.get()), playerIn.field_70170_p, 80, this.wandPower + 1);
            bubbles.func_174828_a(playerIn.func_233580_cy_().func_177982_a(0, 1, 0), playerIn.field_70177_z, playerIn.field_70125_A);
            playerIn.field_70170_p.func_217376_c((Entity)bubbles);
            playerIn.func_184220_m((Entity)bubbles);
        }
        this.castModifier = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.HEART_OF_THE_SEA_BRACELET.get(), (LivingEntity)playerIn).isPresent() ? 2 : 1;
        this.setWandsCoolDown(playerIn, (Integer)CommonConfig.self_bubble_cd.get() / this.castModifier);
    }

    private BubbleProjectile createBubble(PlayerEntity playerIn) {
        int maxTicks = 10;
        int maxTimeBubble = 20;
        int dmg = 1;
        if (this.wandPower == 1) {
            maxTicks = 16;
            maxTimeBubble = 30;
            dmg = 2;
        } else if (this.wandPower >= 2) {
            maxTicks = 26;
            maxTimeBubble = 60;
            dmg = 3;
        }
        boolean heal = false;
        if (this.evil) {
            heal = !CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.TEPHRA_RING.get(), (LivingEntity)playerIn).isPresent();
            return new BubbleProjectile((EntityType<BubbleProjectile>)((EntityType)EntityTypeInit.BUBBLE_PROJECTILE_ENTITY.get()), playerIn, playerIn.field_70170_p, maxTicks / 2, maxTimeBubble, heal, dmg, playerIn.func_213303_ch());
        }
        heal = !CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.TIDAL_RING.get(), (LivingEntity)playerIn).isPresent();
        return new BubbleProjectile((EntityType<BubbleProjectile>)((EntityType)EntityTypeInit.BUBBLE_PROJECTILE_ENTITY.get()), playerIn, playerIn.field_70170_p, maxTicks, maxTimeBubble, heal, dmg);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        playerIn.func_184598_c(handIn);
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public void setWandsCoolDown(PlayerEntity playerIn, int coolDown) {
        playerIn.func_184811_cZ().func_185145_a((Item)ItemInit.ADVANCED_WAND.get(), coolDown);
        playerIn.func_184811_cZ().func_185145_a((Item)ItemInit.TURTLEMANCER_WAND.get(), coolDown);
        playerIn.func_184811_cZ().func_185145_a((Item)ItemInit.BASIC_WAND.get(), coolDown);
        playerIn.func_184811_cZ().func_185145_a((Item)ItemInit.DARK_TURTLEMANCER_WAND.get(), coolDown);
        playerIn.func_184811_cZ().func_185145_a((Item)ItemInit.DARK_ADVANCED_WAND.get(), coolDown);
    }

    public boolean explodeEntity(ServerWorld serverWorld, Entity entity, PlayerEntity playerIn) {
        int i;
        int n;
        boolean particles = false;
        if (this.wandPower >= 0 && entity instanceof ChickenEntity && ((ChickenEntity)entity).func_110143_aJ() > 0.0f && ((ChickenEntity)entity).func_70874_b() >= 0) {
            n = CoreUtil.getRandomIntInRange(10, 30);
            for (i = 0; i < n; ++i) {
                serverWorld.func_217376_c((Entity)new ItemEntity((World)serverWorld, entity.func_226277_ct_() + 0.5, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + 0.5, new ItemStack((IItemProvider)Items.field_151008_G)));
            }
            particles = true;
        }
        if (this.wandPower >= 1) {
            if (entity instanceof SheepEntity && ((SheepEntity)entity).func_110143_aJ() > 0.0f && ((SheepEntity)entity).func_70874_b() >= 0) {
                Map WOOL_BY_COLOR = (Map)Util.func_200696_a((Object)Maps.newEnumMap(DyeColor.class), p_203402_0_ -> {
                    p_203402_0_.put(DyeColor.WHITE, Blocks.field_196556_aL);
                    p_203402_0_.put(DyeColor.ORANGE, Blocks.field_196557_aM);
                    p_203402_0_.put(DyeColor.MAGENTA, Blocks.field_196558_aN);
                    p_203402_0_.put(DyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
                    p_203402_0_.put(DyeColor.YELLOW, Blocks.field_196560_aP);
                    p_203402_0_.put(DyeColor.LIME, Blocks.field_196561_aQ);
                    p_203402_0_.put(DyeColor.PINK, Blocks.field_196562_aR);
                    p_203402_0_.put(DyeColor.GRAY, Blocks.field_196563_aS);
                    p_203402_0_.put(DyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
                    p_203402_0_.put(DyeColor.CYAN, Blocks.field_196565_aU);
                    p_203402_0_.put(DyeColor.PURPLE, Blocks.field_196566_aV);
                    p_203402_0_.put(DyeColor.BLUE, Blocks.field_196567_aW);
                    p_203402_0_.put(DyeColor.BROWN, Blocks.field_196568_aX);
                    p_203402_0_.put(DyeColor.GREEN, Blocks.field_196569_aY);
                    p_203402_0_.put(DyeColor.RED, Blocks.field_196570_aZ);
                    p_203402_0_.put(DyeColor.BLACK, Blocks.field_196602_ba);
                });
                int n2 = CoreUtil.getRandomIntInRange(3, 4);
                for (int i2 = 0; i2 < n2; ++i2) {
                    serverWorld.func_217376_c((Entity)new ItemEntity((World)serverWorld, entity.func_226277_ct_() + 0.5, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + 0.5, new ItemStack((IItemProvider)WOOL_BY_COLOR.get(((SheepEntity)entity).func_175509_cj()))));
                }
                particles = true;
            }
            if (entity instanceof WanderingTraderEntity && ((WanderingTraderEntity)entity).func_110143_aJ() > 0.0f && this.evil) {
                n = CoreUtil.getRandomIntInRange(1, 6);
                for (i = 0; i < n; ++i) {
                    serverWorld.func_217376_c((Entity)new ItemEntity((World)serverWorld, entity.func_226277_ct_() + 0.5, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + 0.5, new ItemStack((IItemProvider)Items.field_151166_bC)));
                }
                particles = true;
            }
            if (entity instanceof SquidEntity && ((SquidEntity)entity).func_110143_aJ() > 0.0f) {
                n = CoreUtil.getRandomIntInRange(10, 30);
                for (i = 0; i < n; ++i) {
                    serverWorld.func_217376_c((Entity)new ItemEntity((World)serverWorld, entity.func_226277_ct_() + 0.5, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + 0.5, new ItemStack((IItemProvider)Items.field_196136_br)));
                }
                particles = true;
            }
        }
        if (this.wandPower >= 2) {
            if (entity instanceof CowEntity && ((CowEntity)entity).func_110143_aJ() > 0.0f && ((CowEntity)entity).func_70874_b() >= 0) {
                n = CoreUtil.getRandomIntInRange(2, 6);
                for (i = 0; i < n; ++i) {
                    serverWorld.func_217376_c((Entity)new ItemEntity((World)serverWorld, entity.func_226277_ct_() + 0.5, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + 0.5, new ItemStack((IItemProvider)Items.field_151116_aA)));
                }
                particles = true;
            } else if (entity instanceof TurtleEntity && ((TurtleEntity)entity).func_110143_aJ() > 0.0f && this.evil) {
                n = CoreUtil.getRandomIntInRange(2, 3);
                for (i = 0; i < n; ++i) {
                    serverWorld.func_217376_c((Entity)new ItemEntity((World)serverWorld, entity.func_226277_ct_() + 0.5, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + 0.5, new ItemStack((IItemProvider)Items.field_203183_eM)));
                }
                particles = true;
            }
        }
        if (particles) {
            this.onDeath((LivingEntity)entity, DamageSource.func_76365_a((PlayerEntity)playerIn), (ServerPlayerEntity)playerIn);
        }
        return particles;
    }

    public void onDeath(LivingEntity mob, DamageSource cause, ServerPlayerEntity player) {
        if (ForgeHooks.onLivingDeath((LivingEntity)mob, (DamageSource)cause)) {
            return;
        }
        if (!mob.field_70128_L && mob.func_110143_aJ() > 0.0f) {
            Entity entity = cause.func_76346_g();
            LivingEntity livingentity = mob.func_94060_bK();
            CriteriaTriggers.field_192122_b.func_192211_a(player, (Entity)mob, cause);
            if (mob.func_70608_bn()) {
                mob.func_213366_dy();
            }
            mob.func_70606_j(0.0f);
            mob.func_110142_aN().func_94549_h();
            if (entity != null) {
                entity.func_241847_a((ServerWorld)mob.field_70170_p, mob);
            }
            mob.field_70170_p.func_72960_a((Entity)mob, (byte)3);
            mob.func_213301_b(Pose.DYING);
        }
    }
}

