/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.items;

import com.github.alienpatois.turtlemancy.client.render.model.CuriosBasicModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CurioItem
extends Item
implements ICurioItem {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[]{new ResourceLocation("turtlemancy", "textures/entities/nautilus_belt.png")};
    private Object model;
    protected int id = -1;

    public CurioItem(Item.Properties properties, int idIn) {
        super(properties);
        this.id = idIn;
    }

    public CurioItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return this.id != -1;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
        ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
        if (!(this.model instanceof CuriosBasicModel)) {
            this.model = new CuriosBasicModel(this.id);
        }
        CuriosBasicModel m = (CuriosBasicModel)((Object)this.model);
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)m.func_228282_a_(TEXTURE[this.id]), (boolean)false, (boolean)stack.func_77962_s());
        m.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ICurio.DropRule getDropRule(LivingEntity livingEntity, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public boolean canRightClickEquip(ItemStack stack) {
        return true;
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return false;
    }

    public static void followBodyRotations(LivingEntity livingEntity, BipedModel<LivingEntity> ... models) {
        LivingRenderer livingRenderer;
        EntityModel entityModel;
        EntityRenderer render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)livingEntity);
        if (render instanceof LivingRenderer && (entityModel = (livingRenderer = (LivingRenderer)render).func_217764_d()) instanceof BipedModel) {
            for (BipedModel<LivingEntity> model : models) {
                BipedModel bipedModel = (BipedModel)entityModel;
                bipedModel.func_217148_a(model);
            }
        }
    }
}

