/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.entities;

import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class TurtleBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.func_187226_a(TurtleBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private BoatEntity.Status status;

    public TurtleBoatEntity(EntityType<? extends BoatEntity> type, World world) {
        super(type, world);
    }

    public TurtleBoatEntity(World worldIn, double x, double y, double z) {
        this((EntityType<? extends BoatEntity>)((EntityType)EntityTypeInit.TURTLE_BOAT.get()), worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public TurtleBoatEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super((EntityType)EntityTypeInit.TURTLE_BOAT.get(), worldIn);
    }

    public Item func_184455_j() {
        return (Item)ItemInit.TURTLE_BOAT.get();
    }

    public boolean func_204231_K() {
        return this.status == BoatEntity.Status.UNDER_WATER || this.status == BoatEntity.Status.UNDER_FLOWING_WATER;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOAT_TYPE, (Object)TurtleBoatType.SCUTE.ordinal());
    }

    public void setTurtleBoatType(TurtleBoatType turtleBoatType) {
        this.field_70180_af.func_187227_b(BOAT_TYPE, (Object)turtleBoatType.ordinal());
    }

    public TurtleBoatType getTurtleBoatType() {
        return TurtleBoatType.byId((Integer)this.field_70180_af.func_187225_a(BOAT_TYPE));
    }

    public void func_213293_j(double x, double y, double z) {
        super.func_213293_j(x * 1.036, y * 1.036, z * 1.036);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum TurtleBoatType {
        SCUTE(Items.field_203183_eM, "scute");

        private final String name;
        private final Item item;

        private TurtleBoatType(Item scute, String name) {
            this.name = name;
            this.item = scute;
        }

        public String getName() {
            return this.name;
        }

        public Item asPlank() {
            return this.item;
        }

        public String toString() {
            return this.name;
        }

        public static TurtleBoatType byId(int id) {
            TurtleBoatType[] aboatentity$type = TurtleBoatType.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static TurtleBoatType getTypeFromString(String nameIn) {
            TurtleBoatType[] aboatentity$type = TurtleBoatType.values();
            for (int i = 0; i < aboatentity$type.length; ++i) {
                if (!aboatentity$type[i].getName().equals(nameIn)) continue;
                return aboatentity$type[i];
            }
            return aboatentity$type[0];
        }
    }
}

