/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.entities;

import com.github.alienpatois.turtlemancy.common.blocks.MagmaTurtleEggBlock;
import com.github.alienpatois.turtlemancy.core.init.BlockInit;
import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class MagmaTurtleEntity
extends AnimalEntity {
    private static final DataParameter<BlockPos> HOME_POS = EntityDataManager.func_187226_a(MagmaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(MagmaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(MagmaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> TRAVEL_POS = EntityDataManager.func_187226_a(MagmaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> GOING_HOME = EntityDataManager.func_187226_a(MagmaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TRAVELLING = EntityDataManager.func_187226_a(MagmaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int isDigging;
    public static final Predicate<LivingEntity> TARGET_DRY_BABY = p_213616_0_ -> p_213616_0_.func_70631_g_() && !p_213616_0_.func_180799_ab();

    public boolean func_213358_a(EntityType<?> typeIn) {
        return true;
    }

    public MagmaTurtleEntity(EntityType<? extends MagmaTurtleEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    public MagmaTurtleEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super((EntityType)EntityTypeInit.MAGMA_TURTLE.get(), worldIn);
    }

    public static boolean canMASpawn(EntityType<? extends MagmaTurtleEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rando) {
        return MagmaTurtleEggBlock.hasProperHabitat((IBlockReader)worldIn, pos) || worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_235381_mu_);
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public void setHome(BlockPos position) {
        this.field_70180_af.func_187227_b(HOME_POS, (Object)position);
    }

    private BlockPos getHome() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME_POS);
    }

    private void setTravelPos(BlockPos position) {
        this.field_70180_af.func_187227_b(TRAVEL_POS, (Object)position);
    }

    private BlockPos getTravelPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TRAVEL_POS);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    private boolean isGoingHome() {
        return (Boolean)this.field_70180_af.func_187225_a(GOING_HOME);
    }

    private void setGoingHome(boolean isGoingHome) {
        this.field_70180_af.func_187227_b(GOING_HOME, (Object)isGoingHome);
    }

    private boolean isTravelling() {
        return (Boolean)this.field_70180_af.func_187225_a(TRAVELLING);
    }

    private void setTravelling(boolean isTravelling) {
        this.field_70180_af.func_187227_b(TRAVELLING, (Object)isTravelling);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HOME_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(TRAVEL_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(GOING_HOME, (Object)false);
        this.field_70180_af.func_187214_a(TRAVELLING, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("HomePosX", this.getHome().func_177958_n());
        compound.func_74768_a("HomePosY", this.getHome().func_177956_o());
        compound.func_74768_a("HomePosZ", this.getHome().func_177952_p());
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74768_a("TravelPosX", this.getTravelPos().func_177958_n());
        compound.func_74768_a("TravelPosY", this.getTravelPos().func_177956_o());
        compound.func_74768_a("TravelPosZ", this.getTravelPos().func_177952_p());
    }

    public void func_70037_a(CompoundNBT compound) {
        int i = compound.func_74762_e("HomePosX");
        int j = compound.func_74762_e("HomePosY");
        int k = compound.func_74762_e("HomePosZ");
        this.setHome(new BlockPos(i, j, k));
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        int l = compound.func_74762_e("TravelPosX");
        int i1 = compound.func_74762_e("TravelPosY");
        int j1 = compound.func_74762_e("TravelPosZ");
        this.setTravelPos(new BlockPos(l, i1, j1));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setHome(this.func_233580_cy_());
        this.setTravelPos(BlockPos.field_177992_a);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new PlayerTemptGoal(this, 1.1, Blocks.field_235375_mo_.func_199767_j()));
        this.field_70714_bg.func_75776_a(2, (Goal)new PlayerTemptGoal(this, 1.1, Blocks.field_235343_mB_.func_199767_j()));
        this.field_70714_bg.func_75776_a(4, (Goal)new GoHomeGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new TravelGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new WanderGoal(this, 1.0, 100));
    }

    public static AttributeModifierMap.MutableAttribute func_234228_eK_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_70044_A() {
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_70648_aU() {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public int func_70627_aG() {
        return 200;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return !this.func_180799_ab() && this.field_70122_E && !this.func_70631_g_() ? SoundEvents.field_203277_iv : super.func_184639_G();
    }

    protected void func_203006_d(float volume) {
        super.func_203006_d(volume * 1.5f);
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203265_iE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_70631_g_() ? SoundEvents.field_203262_iB : SoundEvents.field_203261_iA;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.func_70631_g_() ? SoundEvents.field_203264_iD : SoundEvents.field_203263_iC;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        SoundEvent soundevent = this.func_70631_g_() ? SoundEvents.field_203267_iG : SoundEvents.field_203266_iF;
        this.func_184185_a(soundevent, 0.15f, 1.0f);
    }

    public boolean func_204701_dC() {
        return super.func_204701_dC() && !this.hasEgg();
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 0.15f;
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.3f : 1.0f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator(this, worldIn);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)((EntityType)EntityTypeInit.MAGMA_TURTLE.get()).func_200721_a((World)p_241840_1_);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Blocks.field_235375_mo_.func_199767_j() || stack.func_77973_b() == Blocks.field_235343_mB_.func_199767_j();
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (!this.isGoingHome() && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206960_b)) {
            return 10.0f;
        }
        if (MagmaTurtleEggBlock.hasProperHabitat((IBlockReader)worldIn, pos) || worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_235381_mu_) || worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_235372_ml_)) {
            return 10.0f;
        }
        return 0.0f;
    }

    public void func_70636_d() {
        BlockPos blockpos;
        super.func_70636_d();
        if (this.func_70089_S() && this.isDigging() && this.isDigging >= 1 && this.isDigging % 5 == 0 && MagmaTurtleEggBlock.hasProperHabitat((IBlockReader)this.field_70170_p, blockpos = this.func_233580_cy_())) {
            this.field_70170_p.func_217379_c(2001, blockpos, Block.func_196246_j((BlockState)Blocks.field_150424_aL.func_176223_P()));
        }
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_199702_a((IItemProvider)ItemInit.MAGMA_SCUTE.get(), 1);
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_180799_ab()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (!(this.func_70638_az() != null || this.isGoingHome() && this.getHome().func_218137_a((IPosition)this.func_213303_ch(), 20.0))) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        this.func_70097_a(DamageSource.field_180137_b, Float.MAX_VALUE);
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private final MagmaTurtleEntity turtle;

        private WanderGoal(MagmaTurtleEntity turtle, double speedIn, int chance) {
            super((CreatureEntity)turtle, speedIn, chance);
            this.turtle = turtle;
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_180799_ab() && !this.turtle.isGoingHome() && !this.turtle.hasEgg() ? super.func_75250_a() : false;
        }
    }

    static class TravelGoal
    extends Goal {
        private final MagmaTurtleEntity turtle;
        private final double speed;
        private boolean field_203139_c;

        TravelGoal(MagmaTurtleEntity turtle, double speedIn) {
            this.turtle = turtle;
            this.speed = speedIn;
        }

        public boolean func_75250_a() {
            return !this.turtle.isGoingHome() && !this.turtle.hasEgg() && this.turtle.func_180799_ab();
        }

        public void func_75249_e() {
            int i = 512;
            int j = 4;
            Random random = this.turtle.field_70146_Z;
            int k = random.nextInt(1025) - 512;
            int l = random.nextInt(9) - 4;
            int i1 = random.nextInt(1025) - 512;
            if ((double)l + this.turtle.func_226278_cu_() > (double)(this.turtle.field_70170_p.func_181545_F() - 1)) {
                l = 0;
            }
            BlockPos blockpos = new BlockPos((double)k + this.turtle.func_226277_ct_(), (double)l + this.turtle.func_226278_cu_(), (double)i1 + this.turtle.func_226281_cx_());
            this.turtle.setTravelPos(blockpos);
            this.turtle.setTravelling(true);
            this.field_203139_c = false;
        }

        public void func_75246_d() {
            if (this.turtle.func_70661_as().func_75500_f()) {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)this.turtle.getTravelPos());
                Vector3d vector3d1 = RandomPositionGenerator.func_203155_a((CreatureEntity)this.turtle, (int)16, (int)3, (Vector3d)vector3d, (double)0.3141592741012573);
                if (vector3d1 == null) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)this.turtle, (int)8, (int)7, (Vector3d)vector3d);
                }
                if (vector3d1 != null) {
                    int i = MathHelper.func_76128_c((double)vector3d1.field_72450_a);
                    int j = MathHelper.func_76128_c((double)vector3d1.field_72449_c);
                    int k = 34;
                    if (!this.turtle.field_70170_p.func_217344_a(i - 34, 0, j - 34, i + 34, 0, j + 34)) {
                        vector3d1 = null;
                    }
                }
                if (vector3d1 == null) {
                    this.field_203139_c = true;
                    return;
                }
                this.turtle.func_70661_as().func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.speed);
            }
        }

        public boolean func_75253_b() {
            return !this.turtle.func_70661_as().func_75500_f() && !this.field_203139_c && !this.turtle.isGoingHome() && !this.turtle.func_70880_s() && !this.turtle.hasEgg();
        }

        public void func_75251_c() {
            this.turtle.setTravelling(false);
            super.func_75251_c();
        }
    }

    static class PlayerTemptGoal
    extends Goal {
        private static final EntityPredicate field_220834_a = new EntityPredicate().func_221013_a(10.0).func_221011_b().func_221008_a();
        private final MagmaTurtleEntity turtle;
        private final double speed;
        private PlayerEntity tempter;
        private int cooldown;
        private final Set<Item> temptItems;

        PlayerTemptGoal(MagmaTurtleEntity turtle, double speedIn, Item temptItem) {
            this.turtle = turtle;
            this.speed = speedIn;
            this.temptItems = Sets.newHashSet((Object[])new Item[]{temptItem});
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.tempter = this.turtle.field_70170_p.func_217370_a(field_220834_a, (LivingEntity)this.turtle);
            if (this.tempter == null) {
                return false;
            }
            return this.isTemptedBy(this.tempter.func_184614_ca()) || this.isTemptedBy(this.tempter.func_184592_cb());
        }

        private boolean isTemptedBy(ItemStack p_203131_1_) {
            return this.temptItems.contains(p_203131_1_.func_77973_b());
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75251_c() {
            this.tempter = null;
            this.turtle.func_70661_as().func_75499_g();
            this.cooldown = 100;
        }

        public void func_75246_d() {
            this.turtle.func_70671_ap().func_75651_a((Entity)this.tempter, (float)(this.turtle.func_184649_cE() + 20), (float)this.turtle.func_70646_bf());
            if (this.turtle.func_70068_e((Entity)this.tempter) < 6.25) {
                this.turtle.func_70661_as().func_75499_g();
            } else {
                this.turtle.func_70661_as().func_75497_a((Entity)this.tempter, this.speed);
            }
        }
    }

    static class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        PanicGoal(MagmaTurtleEntity turtle, double speedIn) {
            super((CreatureEntity)turtle, speedIn);
        }

        public boolean func_75250_a() {
            if (this.field_75267_a.func_70643_av() == null && !this.field_75267_a.func_70027_ad()) {
                return false;
            }
            BlockPos blockpos = this.func_188497_a((IBlockReader)this.field_75267_a.field_70170_p, (Entity)this.field_75267_a, 7, 4);
            if (blockpos != null) {
                this.field_75266_c = blockpos.func_177958_n();
                this.field_75263_d = blockpos.func_177956_o();
                this.field_75264_e = blockpos.func_177952_p();
                return true;
            }
            return this.func_190863_f();
        }
    }

    static class Navigator
    extends SwimmerPathNavigator {
        Navigator(MagmaTurtleEntity turtle, World worldIn) {
            super((MobEntity)turtle, worldIn);
        }

        protected boolean func_75485_k() {
            return true;
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }

        public boolean func_188555_b(BlockPos pos) {
            MagmaTurtleEntity turtleentity;
            if (this.field_75515_a instanceof MagmaTurtleEntity && (turtleentity = (MagmaTurtleEntity)this.field_75515_a).isTravelling()) {
                return this.field_75513_b.func_180495_p(pos).func_203425_a(Blocks.field_150353_l);
            }
            return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final MagmaTurtleEntity turtle;

        MoveHelperController(MagmaTurtleEntity turtleIn) {
            super((MobEntity)turtleIn);
            this.turtle = turtleIn;
        }

        private void updateSpeed() {
            if (this.turtle.func_180799_ab()) {
                this.turtle.func_213317_d(this.turtle.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (!this.turtle.getHome().func_218137_a((IPosition)this.turtle.func_213303_ch(), 16.0)) {
                    this.turtle.func_70659_e(Math.max(this.turtle.func_70689_ay() / 2.0f, 0.08f));
                }
                if (this.turtle.func_70631_g_()) {
                    this.turtle.func_70659_e(Math.max(this.turtle.func_70689_ay() / 3.0f, 0.06f));
                }
            } else if (this.turtle.field_70122_E) {
                this.turtle.func_70659_e(Math.max(this.turtle.func_70689_ay() / 2.0f, 0.06f));
            }
        }

        public void func_75641_c() {
            this.updateSpeed();
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.turtle.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.turtle.func_226277_ct_();
                double d1 = this.field_75647_c - this.turtle.func_226278_cu_();
                double d2 = this.field_75644_d - this.turtle.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.turtle.field_70761_aq = this.turtle.field_70177_z = this.func_75639_a(this.turtle.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.turtle.func_233637_b_(Attributes.field_233821_d_));
                this.turtle.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.turtle.func_70689_ay(), (float)f1));
                this.turtle.func_213317_d(this.turtle.func_213322_ci().func_72441_c(0.0, (double)this.turtle.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.turtle.func_70659_e(0.0f);
            }
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final MagmaTurtleEntity turtle;

        MateGoal(MagmaTurtleEntity turtle, double speedIn) {
            super((AnimalEntity)turtle, speedIn);
            this.turtle = turtle;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.turtle.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.turtle.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final MagmaTurtleEntity turtle;

        LayEggGoal(MagmaTurtleEntity turtle, double speedIn) {
            super((CreatureEntity)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public boolean func_75250_a() {
            return this.turtle.hasEgg() && this.turtle.getHome().func_218137_a((IPosition)this.turtle.func_213303_ch(), 9.0) ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.turtle.hasEgg() && this.turtle.getHome().func_218137_a((IPosition)this.turtle.func_213303_ch(), 9.0);
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = this.turtle.func_233580_cy_();
            if (!this.turtle.func_180799_ab() && this.func_179487_f()) {
                if (this.turtle.isDigging < 1) {
                    this.turtle.setDigging(true);
                } else if (this.turtle.isDigging > 200) {
                    World world = this.turtle.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)((Block)BlockInit.MAGMA_TURTLE_EGG.get()).func_176223_P().func_206870_a((Property)MagmaTurtleEggBlock.EGGS, (Comparable)Integer.valueOf(this.turtle.field_70146_Z.nextInt(4) + 1)), 3);
                    this.turtle.setHasEgg(false);
                    this.turtle.setDigging(false);
                    this.turtle.func_204700_e(600);
                }
                if (this.turtle.isDigging()) {
                    this.turtle.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            return !worldIn.func_175623_d(pos.func_177984_a()) ? false : MagmaTurtleEggBlock.isProperHabitat((IBlockReader)worldIn, pos);
        }
    }

    static class GoToLavaGoal
    extends MoveToBlockGoal {
        private final MagmaTurtleEntity turtle;

        private GoToLavaGoal(MagmaTurtleEntity turtle, double speedIn) {
            super((CreatureEntity)turtle, turtle.func_70631_g_() ? 2.0 : speedIn, 24);
            this.turtle = turtle;
            this.field_203112_e = -1;
        }

        public boolean func_75253_b() {
            return !this.turtle.func_180799_ab() && this.field_179493_e <= 1200 && this.func_179488_a((IWorldReader)this.turtle.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            if (this.turtle.func_70631_g_() && !this.turtle.func_180799_ab()) {
                return super.func_75250_a();
            }
            return !this.turtle.isGoingHome() && !this.turtle.func_180799_ab() && !this.turtle.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 160 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            return worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150353_l);
        }
    }

    static class GoHomeGoal
    extends Goal {
        private final MagmaTurtleEntity turtle;
        private final double speed;
        private boolean field_203129_c;
        private int field_203130_d;

        GoHomeGoal(MagmaTurtleEntity turtle, double speedIn) {
            this.turtle = turtle;
            this.speed = speedIn;
        }

        public boolean func_75250_a() {
            if (this.turtle.func_70631_g_()) {
                return false;
            }
            if (this.turtle.hasEgg()) {
                return true;
            }
            if (this.turtle.func_70681_au().nextInt(700) != 0) {
                return false;
            }
            return !this.turtle.getHome().func_218137_a((IPosition)this.turtle.func_213303_ch(), 64.0);
        }

        public void func_75249_e() {
            this.turtle.setGoingHome(true);
            this.field_203129_c = false;
            this.field_203130_d = 0;
        }

        public void func_75251_c() {
            this.turtle.setGoingHome(false);
        }

        public boolean func_75253_b() {
            return !this.turtle.getHome().func_218137_a((IPosition)this.turtle.func_213303_ch(), 7.0) && !this.field_203129_c && this.field_203130_d <= 600;
        }

        public void func_75246_d() {
            BlockPos blockpos = this.turtle.getHome();
            boolean flag = blockpos.func_218137_a((IPosition)this.turtle.func_213303_ch(), 16.0);
            if (flag) {
                ++this.field_203130_d;
            }
            if (this.turtle.func_70661_as().func_75500_f()) {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)blockpos);
                Vector3d vector3d1 = RandomPositionGenerator.func_203155_a((CreatureEntity)this.turtle, (int)16, (int)3, (Vector3d)vector3d, (double)0.3141592741012573);
                if (vector3d1 == null) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)this.turtle, (int)8, (int)7, (Vector3d)vector3d);
                }
                if (vector3d1 != null && !flag && !this.turtle.field_70170_p.func_180495_p(new BlockPos(vector3d1)).func_203425_a(Blocks.field_150353_l)) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)this.turtle, (int)16, (int)5, (Vector3d)vector3d);
                }
                if (vector3d1 == null) {
                    this.field_203129_c = true;
                    return;
                }
                this.turtle.func_70661_as().func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.speed);
            }
        }
    }
}

