/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.entities;

import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class MagicPearlEntity
extends Entity
implements IRendersAsItem {
    private static DataParameter<ItemStack> field_213864_b = EntityDataManager.func_187226_a(MagicPearlEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private double targetX;
    private double targetY;
    private double targetZ;
    private int despawnTimer;
    private boolean shatterOrDrop;
    private Item item = (Item)ItemInit.BEETROOT_SOUP.get();

    public MagicPearlEntity(EntityType<? extends MagicPearlEntity> p_i50169_1_, World p_i50169_2_) {
        super(p_i50169_1_, p_i50169_2_);
    }

    public MagicPearlEntity(World worldIn, double x, double y, double z) {
        this((EntityType<? extends MagicPearlEntity>)((EntityType)EntityTypeInit.BLESSED_OR_CURSED_PEARL_ENTITY.get()), worldIn);
        this.despawnTimer = 0;
        this.func_70107_b(x, y, z);
    }

    public MagicPearlEntity(World worldIn, double x, double y, double z, Item itemIn) {
        this((EntityType<? extends MagicPearlEntity>)((EntityType)EntityTypeInit.BLESSED_OR_CURSED_PEARL_ENTITY.get()), worldIn);
        this.despawnTimer = 0;
        this.func_70107_b(x, y, z);
        this.item = itemIn;
        this.setItemstack(new ItemStack((IItemProvider)itemIn));
    }

    public MagicPearlEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super((EntityType)EntityTypeInit.BLESSED_OR_CURSED_PEARL_ENTITY.get(), worldIn);
    }

    public void setItemstack(ItemStack i) {
        this.func_184212_Q().func_187227_b(field_213864_b, Util.func_200696_a((Object)i.func_77946_l(), p_213862_0_ -> p_213862_0_.func_190920_e(1)));
    }

    public void func_213863_b(ItemStack p_213863_1_) {
        if (p_213863_1_.func_77973_b() != this.item || p_213863_1_.func_77942_o()) {
            this.func_184212_Q().func_187227_b(field_213864_b, Util.func_200696_a((Object)p_213863_1_.func_77946_l(), p_213862_0_ -> p_213862_0_.func_190920_e(1)));
        }
    }

    private ItemStack getItemStackFromData() {
        return (ItemStack)this.func_184212_Q().func_187225_a(field_213864_b);
    }

    public ItemStack func_184543_l() {
        ItemStack itemstack = this.getItemStackFromData();
        return itemstack.func_190926_b() ? new ItemStack((IItemProvider)this.item) : itemstack;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_213864_b, (Object)ItemStack.field_190927_a);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void moveTowards(BlockPos pos) {
        double d3;
        double d0 = pos.func_177958_n();
        int i = pos.func_177956_o();
        double d1 = pos.func_177952_p();
        double d2 = d0 - this.func_226277_ct_();
        float f = MathHelper.func_76133_a((double)(d2 * d2 + (d3 = d1 - this.func_226281_cx_()) * d3));
        if (f > 12.0f) {
            this.targetX = this.func_226277_ct_() + d2 / (double)f * 12.0;
            this.targetZ = this.func_226281_cx_() + d3 / (double)f * 12.0;
            this.targetY = this.func_226278_cu_() + 8.0;
        } else {
            this.targetX = d0;
            this.targetY = i;
            this.targetZ = d1;
        }
        this.despawnTimer = 0;
        this.shatterOrDrop = this.field_70146_Z.nextInt(5) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d vector3d = this.func_213322_ci();
        double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vector3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vector3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)MagicPearlEntity.func_213296_b((Vector3d)vector3d));
        this.field_70125_A = MagicPearlEntity.func_234614_e_(this.field_70127_C, (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875));
        this.field_70177_z = MagicPearlEntity.func_234614_e_(this.field_70126_B, (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875));
        if (!this.field_70170_p.field_72995_K) {
            double d3 = this.targetX - d0;
            double d4 = this.targetZ - d2;
            float f1 = (float)Math.sqrt(d3 * d3 + d4 * d4);
            float f2 = (float)MathHelper.func_181159_b((double)d4, (double)d3);
            double d5 = MathHelper.func_219803_d((double)0.0025, (double)f, (double)f1);
            double d6 = vector3d.field_72448_b;
            if (f1 < 1.0f) {
                d5 *= 0.8;
                d6 *= 0.8;
            }
            int j = this.func_226278_cu_() < this.targetY ? 1 : -1;
            vector3d = new Vector3d(Math.cos(f2) * d5, d6 + ((double)j - d6) * (double)0.015f, Math.sin(f2) * d5);
            this.func_213317_d(vector3d);
        }
        float f3 = 0.25f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vector3d.field_72450_a * 0.25, d1 - vector3d.field_72448_b * 0.25, d2 - vector3d.field_72449_c * 0.25, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            }
        } else {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 - vector3d.field_72450_a * 0.25 + this.field_70146_Z.nextDouble() * 0.6 - 0.3, d1 - vector3d.field_72448_b * 0.25 - 0.5, d2 - vector3d.field_72449_c * 0.25 + this.field_70146_Z.nextDouble() * 0.6 - 0.3, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70107_b(d0, d1, d2);
            ++this.despawnTimer;
            if (this.despawnTimer > 80 && !this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_193777_bb, 1.0f, 1.0f);
                this.func_70106_y();
                if (this.shatterOrDrop) {
                    this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184543_l()));
                } else {
                    this.field_70170_p.func_217379_c(2003, this.func_233580_cy_(), 0);
                }
            }
        } else {
            this.func_226288_n_(d0, d1, d2);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        ItemStack itemstack = this.getItemStackFromData();
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("Item", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        this.func_213863_b(itemstack);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_70075_an() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected static float func_234614_e_(float p_234614_0_, float p_234614_1_) {
        while (p_234614_1_ - p_234614_0_ < -180.0f) {
            p_234614_0_ -= 360.0f;
        }
        while (p_234614_1_ - p_234614_0_ >= 180.0f) {
            p_234614_0_ += 360.0f;
        }
        return MathHelper.func_219799_g((float)0.2f, (float)p_234614_0_, (float)p_234614_1_);
    }
}

