/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.entities;

import com.github.alienpatois.turtlemancy.common.entities.BubbleEntity;
import com.github.alienpatois.turtlemancy.common.items.TurtlemancerWand;
import com.github.alienpatois.turtlemancy.config.CommonConfig;
import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ShieldItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BubbleProjectile
extends ThrowableEntity {
    private static final DataParameter<Boolean> EVIL = EntityDataManager.func_187226_a(BubbleProjectile.class, (IDataSerializer)DataSerializers.field_187198_h);
    private PlayerEntity turtlemancer;
    protected float damage;
    private boolean heal = true;
    public int dmg = 0;
    private int maxTicks = 40;
    private int maxTimeBubble = 30;
    Vector3d pos = null;

    public BubbleProjectile(EntityType<? extends BubbleProjectile> type, World world) {
        super(type, world);
    }

    public BubbleProjectile(EntityType<BubbleProjectile> type, double x, double y, double z, World worldIn) {
        super(type, x, y, z, worldIn);
    }

    public BubbleProjectile(EntityType<BubbleProjectile> type, PlayerEntity turtlemancer, World worldIn) {
        super(type, (LivingEntity)turtlemancer, worldIn);
        this.turtlemancer = turtlemancer;
        this.damage = 1.0f;
    }

    public boolean func_70090_H() {
        return false;
    }

    public BubbleProjectile(EntityType<BubbleProjectile> type, PlayerEntity turtlemancer, World worldIn, int maxTicksIn, int maxTimeBubbleIn, boolean healIn, int dmgIn) {
        super(type, (LivingEntity)turtlemancer, worldIn);
        this.turtlemancer = turtlemancer;
        this.damage = 1.0f;
        this.heal = healIn;
        this.dmg = dmgIn;
        this.maxTicks = maxTicksIn;
        this.maxTimeBubble = maxTimeBubbleIn;
        this.field_70180_af.func_187227_b(EVIL, (Object)false);
    }

    public BubbleProjectile(EntityType<BubbleProjectile> type, PlayerEntity turtlemancer, World worldIn, int maxTicksIn, int maxTimeBubbleIn, boolean healIn, int dmgIn, Vector3d playerPos) {
        super(type, (LivingEntity)turtlemancer, worldIn);
        this.turtlemancer = turtlemancer;
        this.damage = 1.0f;
        this.heal = healIn;
        this.dmg = dmgIn;
        this.maxTicks = maxTicksIn;
        this.maxTimeBubble = maxTimeBubbleIn;
        this.pos = playerPos;
        this.field_70180_af.func_187227_b(EVIL, (Object)true);
    }

    public BubbleProjectile(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super((EntityType)EntityTypeInit.BUBBLE_PROJECTILE_ENTITY.get(), worldIn);
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > this.maxTicks) {
            this.func_241204_bJ_();
        }
        super.func_70071_h_();
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && result.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a() != null && ((EntityRayTraceResult)result).func_216348_a() != this.turtlemancer) {
            this.func_70108_f(((EntityRayTraceResult)result).func_216348_a());
        }
        super.func_70227_a(result);
    }

    public void func_70108_f(Entity entityHit) {
        if (!(entityHit instanceof LivingEntity)) {
            return;
        }
        if (entityHit == this.turtlemancer) {
            return;
        }
        if (entityHit instanceof BubbleEntity || entityHit instanceof BubbleProjectile) {
            return;
        }
        if (entityHit.func_184218_aH() && entityHit.func_184187_bx() instanceof BubbleEntity) {
            return;
        }
        if (entityHit instanceof LivingEntity && ((LivingEntity)entityHit).func_184607_cu().func_77973_b() instanceof ShieldItem) {
            return;
        }
        if (this.heal) {
            ((LivingEntity)entityHit).func_70691_i((float)this.dmg);
        } else {
            entityHit.func_70097_a(DamageSource.func_76354_b((Entity)this.turtlemancer, (Entity)this), (float)this.dmg);
        }
        BubbleEntity bubbles = null;
        bubbles = (Boolean)this.field_70180_af.func_187225_a(EVIL) != false ? new BubbleEntity((EntityType<? extends BubbleEntity>)((EntityType)EntityTypeInit.BUBBLE_ENTITY.get()), this.field_70170_p, this.maxTimeBubble, this.heal, this.dmg, this.pos, this.turtlemancer) : new BubbleEntity((EntityType<? extends BubbleEntity>)((EntityType)EntityTypeInit.BUBBLE_ENTITY.get()), this.field_70170_p, this.maxTimeBubble, this.heal, this.dmg, this.turtlemancer);
        bubbles.func_174828_a(entityHit.func_233580_cy_().func_177963_a(0.0, 1.5, 0.0), entityHit.field_70177_z, entityHit.field_70125_A);
        this.field_70170_p.func_217376_c((Entity)bubbles);
        entityHit.func_184205_a((Entity)bubbles, true);
        this.func_241204_bJ_();
        if (this.turtlemancer.func_184614_ca().func_77973_b() instanceof TurtlemancerWand) {
            TurtlemancerWand t = (TurtlemancerWand)this.turtlemancer.func_184614_ca().func_77973_b();
            t.setWandsCoolDown(this.turtlemancer, (Integer)CommonConfig.bubble_cd.get() / t.castModifier);
        } else {
            for (int i = 0; i < this.turtlemancer.field_71071_by.func_70302_i_(); ++i) {
                if (!(this.turtlemancer.field_71071_by.func_70301_a(i).func_77973_b() instanceof TurtlemancerWand)) continue;
                TurtlemancerWand t = (TurtlemancerWand)this.turtlemancer.field_71071_by.func_70301_a(i).func_77973_b();
                t.setWandsCoolDown(this.turtlemancer, (Integer)CommonConfig.bubble_cd.get() / t.castModifier);
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EVIL, (Object)false);
    }

    public boolean getEvil() {
        return (Boolean)this.field_70180_af.func_187225_a(EVIL);
    }
}

