/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.entities;

import com.github.alienpatois.turtlemancy.Turtlemancy;
import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BubbleEntity
extends Entity {
    private static final DataParameter<Boolean> EVIL = EntityDataManager.func_187226_a(BubbleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> POS = EntityDataManager.func_187226_a(BubbleEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private int fly_time_max = 80;
    private int flyTicks = 0;
    private boolean heal = true;
    private int dmg = 0;
    private boolean self = false;
    private PlayerEntity turtlemancer = null;

    public BubbleEntity(EntityType<? extends BubbleEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
        this.heal = true;
        this.dmg = 0;
        this.self = true;
        this.fly_time_max = 80;
    }

    public BubbleEntity(EntityType<? extends BubbleEntity> entityTypeIn, World worldIn, int max, int dmgIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
        this.heal = true;
        this.dmg = dmgIn;
        this.self = true;
        this.fly_time_max = max;
    }

    public BubbleEntity(EntityType<? extends BubbleEntity> entityTypeIn, World worldIn, int max, boolean healIn, int dmgIn, PlayerEntity playerIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
        this.fly_time_max = max;
        this.heal = healIn;
        this.dmg = dmgIn;
        if (this.field_70180_af.func_187225_a(EVIL) != null) {
            this.field_70180_af.func_187227_b(EVIL, (Object)false);
        }
        this.turtlemancer = playerIn;
    }

    public BubbleEntity(EntityType<? extends BubbleEntity> entityTypeIn, World worldIn, int max, boolean healIn, int dmgIn, Vector3d playerPosIn, PlayerEntity playerIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
        this.fly_time_max = max;
        this.heal = healIn;
        this.dmg = dmgIn;
        if (this.field_70180_af.func_187225_a(EVIL) != null) {
            this.field_70180_af.func_187227_b(EVIL, (Object)true);
        }
        if (this.field_70180_af.func_187225_a(POS) != null) {
            this.field_70180_af.func_187227_b(POS, (Object)new BlockPos(playerPosIn));
        }
        this.turtlemancer = playerIn;
    }

    public BubbleEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super((EntityType)EntityTypeInit.BUBBLE_ENTITY.get(), worldIn);
    }

    public int setFlyTimeMax(int max) {
        this.fly_time_max = max;
        return this.fly_time_max;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Entity entity;
            if (!this.func_184207_aI() || this.func_180799_ab() || this.field_70124_G && !this.field_70122_E || this.flyTicks > this.fly_time_max) {
                if ((this.func_184207_aI() || !this.self) && this.func_184188_bt().size() > 0) {
                    Entity entity2 = (Entity)this.func_184188_bt().get(0);
                    entity2.func_184210_p();
                    entity2.func_70634_a(this.func_226277_ct_(), this.func_226278_cu_() + 0.5 * (double)(this.func_213302_cg() - entity2.func_213302_cg()), this.func_226281_cx_());
                } else if (this.flyTicks > this.fly_time_max && this.func_184188_bt().size() > 0) {
                    Entity entity3 = (Entity)this.func_184188_bt().get(0);
                    entity3.func_184210_p();
                    entity3.func_70634_a(this.func_226277_ct_(), this.func_226278_cu_() + 0.5 * (double)(this.func_213302_cg() - entity3.func_213302_cg()), this.func_226281_cx_());
                }
                this.func_241204_bJ_();
                return;
            }
            if (this.dmg > 0 && this.func_184207_aI() && (entity = (Entity)this.func_184188_bt().get(0)) instanceof LivingEntity && this.flyTicks % 20 == 0) {
                if (this.heal) {
                    ((LivingEntity)entity).func_70691_i((float)this.dmg);
                } else {
                    Turtlemancy.LOGGER.info("Turtlemancer: " + this.turtlemancer.func_200200_C_());
                    ((LivingEntity)entity).func_70097_a(DamageSource.func_76365_a((PlayerEntity)this.turtlemancer), (float)this.dmg);
                }
            }
            ++this.flyTicks;
        }
        if (!((BlockPos)this.field_70180_af.func_187225_a(POS)).equals((Object)new BlockPos(0, 0, 0)) && this.field_70180_af.func_187225_a(POS) != null) {
            BlockPos p = (BlockPos)this.field_70180_af.func_187225_a(POS);
            Vector3d motion = new Vector3d((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p()).func_178788_d(this.func_213303_ch()).func_72441_c(0.0, 0.5, 0.0);
            this.func_213315_a(MoverType.SELF, new Vector3d(motion.field_72450_a * 0.05, motion.field_72448_b * 0.05, motion.field_72449_c * 0.05));
        } else {
            this.func_213315_a(MoverType.SELF, new Vector3d(0.0, 0.05, 0.0));
        }
    }

    public boolean getEvil() {
        return (Boolean)this.field_70180_af.func_187225_a(EVIL);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.flyTicks += 40;
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_230279_az_() {
        return true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EVIL, (Object)false);
        this.field_70180_af.func_187214_a(POS, (Object)new BlockPos(0, 0, 0));
    }

    public double func_70042_X() {
        if (this.func_184207_aI()) {
            Entity entity = (Entity)this.func_184188_bt().get(0);
            return 0.5 * (double)(this.func_213302_cg() - entity.func_213302_cg()) - entity.func_70033_W();
        }
        return 0.0;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
    }

    protected boolean func_184219_q(Entity passenger) {
        return !this.func_184207_aI();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_205710_ba() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }
}

