/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.blocks;

import com.github.alienpatois.turtlemancy.common.tiles.TurtleAltarTileEntity;
import com.github.alienpatois.turtlemancy.config.CommonConfig;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import com.github.alienpatois.turtlemancy.core.init.TileEntityTypeInit;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TurtleAltar
extends Block {
    private static final int FED_LIMIT = (Integer)CommonConfig.altar_bless_count.get() - 1;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final IntegerProperty LOADED = IntegerProperty.func_177719_a((String)"loaded", (int)0, (int)2);
    public static final IntegerProperty FED_TIMES = IntegerProperty.func_177719_a((String)"fed_times", (int)0, (int)(FED_LIMIT + 1));
    private static final VoxelShape SHAPE_N = Stream.of(Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)28.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public TurtleAltar(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LOADED, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FED_TIMES, (Comparable)Integer.valueOf(0)));
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - from.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        return buffer[0];
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_N;
            }
            case SOUTH: {
                return SHAPE_N;
            }
            case EAST: {
                return SHAPE_N;
            }
            case WEST: {
                return SHAPE_N;
            }
        }
        return SHAPE_N;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)LOADED, (Comparable)Integer.valueOf(0));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING}).func_206894_a(new Property[]{LOADED}).func_206894_a(new Property[]{FED_TIMES});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Item item;
        if (worldIn.field_72995_K) {
            if ((Integer)state.func_177229_b((Property)LOADED) <= 0 && handIn.equals((Object)Hand.MAIN_HAND) && !player.func_184586_b(handIn).func_190926_b() && (player.func_184586_b(handIn).func_77973_b() == ItemInit.TURTLE_BLESS.get() || player.func_184586_b(handIn).func_77973_b() == ItemInit.TURTLE_CURSE.get())) {
                Random rand = new Random();
                double d0 = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                for (int i = 0; i < 3; ++i) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n() + 2.0 * rand.nextDouble() - 1.0, (double)pos.func_177956_o() + 2.5 * rand.nextDouble(), (double)pos.func_177952_p() + 0.5 * rand.nextDouble(), d0, d1, d2);
                }
            }
            return ActionResultType.CONSUME;
        }
        if (handIn.equals((Object)Hand.OFF_HAND)) {
            return ActionResultType.CONSUME;
        }
        ItemStack itemstack = player.func_184586_b(handIn);
        TurtleAltarTileEntity altar = (TurtleAltarTileEntity)worldIn.func_175625_s(pos);
        if (itemstack.func_190926_b() && (Integer)state.func_177229_b((Property)LOADED) <= 0 && altar.func_191420_l()) {
            return ActionResultType.PASS;
        }
        if ((Integer)state.func_177229_b((Property)LOADED) <= 0 && ((item = itemstack.func_77973_b()) == ItemInit.TURTLE_BLESS.get() || item == ItemInit.TURTLE_CURSE.get())) {
            if (!worldIn.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                if (((ServerPlayerEntity)player).func_192039_O().func_192747_a(worldIn.func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation("turtlemancy:dark_turtlemancer"))).func_192105_a()) {
                    if (item == ItemInit.TURTLE_BLESS.get()) {
                        ((ServerWorld)worldIn).func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187913_gm, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        return ActionResultType.FAIL;
                    }
                } else if (item == ItemInit.TURTLE_CURSE.get()) {
                    ((ServerWorld)worldIn).func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187913_gm, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return ActionResultType.FAIL;
                }
                this.setAltarLoaded(worldIn, pos, state, item.getRegistryName());
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203266_iF, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        if (worldIn.func_175625_s(pos) instanceof TurtleAltarTileEntity) {
            if (altar.func_191420_l()) {
                if (!itemstack.func_190926_b()) {
                    altar.func_70299_a(0, itemstack.func_77979_a(1));
                }
            } else {
                player.func_191521_c((ItemStack)altar.func_190576_q().get(0));
                altar.func_70299_a(0, ItemStack.field_190927_a);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        tileentity.func_145843_s();
        super.func_176208_a(worldIn, pos, state, player);
    }

    private void setAltarLoaded(World worldIn, BlockPos pos, BlockState state, ResourceLocation name) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        int level = 0;
        if (name.equals((Object)ItemInit.TURTLE_BLESS.getId())) {
            level = 1;
        } else if (name.equals((Object)ItemInit.TURTLE_CURSE.getId())) {
            level = 2;
        }
        if ((Integer)state.func_177229_b((Property)FED_TIMES) >= FED_LIMIT) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LOADED, (Comparable)Integer.valueOf(level)), 2);
            if (tileentity instanceof TurtleAltarTileEntity) {
                TurtleAltarTileEntity tileEntityData = (TurtleAltarTileEntity)tileentity;
                tileEntityData.setLoaded(level);
            }
        } else {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)FED_TIMES, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)FED_TIMES) + 1)), 2);
            if (tileentity instanceof TurtleAltarTileEntity) {
                TurtleAltarTileEntity tileEntityData = (TurtleAltarTileEntity)tileentity;
                tileEntityData.addFedTimes(level);
            }
        }
        worldIn.func_175666_e(pos, (Block)this);
    }

    public static void emptyFedTimes(World worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)FED_TIMES, (Comparable)Integer.valueOf(0))).func_206870_a((Property)LOADED, (Comparable)Integer.valueOf(0)), 2);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityTypeInit.TURTLE_ALTAR_TE.get()).func_200968_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = worldIn.func_175625_s(pos)) instanceof TurtleAltarTileEntity) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((TurtleAltarTileEntity)tile).func_190576_q());
        }
    }

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }
}

