/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.blocks;

import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MineTurtle
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private boolean on = false;
    private int countDown = 0;
    private static VoxelShape SHAPE_N = Stream.of(Block.func_208617_a((double)5.0, (double)0.0, (double)6.0, (double)6.0, (double)1.0, (double)7.0), Block.func_208617_a((double)7.0, (double)4.0, (double)8.0, (double)9.0, (double)5.0, (double)10.0), Block.func_208617_a((double)5.0, (double)0.0, (double)11.0, (double)6.0, (double)1.0, (double)12.0), Block.func_208617_a((double)10.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.func_208617_a((double)10.0, (double)0.0, (double)6.0, (double)11.0, (double)1.0, (double)7.0), Block.func_208617_a((double)4.0, (double)1.0, (double)5.0, (double)12.0, (double)2.0, (double)13.0), Block.func_208617_a((double)5.0, (double)2.0, (double)6.0, (double)11.0, (double)3.0, (double)12.0), Block.func_208617_a((double)6.0, (double)3.0, (double)7.0, (double)10.0, (double)4.0, (double)11.0), Block.func_208617_a((double)6.0, (double)1.0, (double)2.0, (double)10.0, (double)3.0, (double)5.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public MineTurtle(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.on = false;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - from.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        return buffer[0];
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.on = true;
        this.func_225534_a_(state, (ServerWorld)worldIn, pos, this.RANDOM);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!this.on) {
            return;
        }
        if (this.countDown < 40) {
            ++this.countDown;
        } else {
            worldIn.func_217385_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4.0f, Explosion.Mode.NONE);
            worldIn.func_217377_a(pos, false);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return MineTurtle.rotateShape(Direction.NORTH, (Direction)state.func_177229_b((Property)FACING), SHAPE_N);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }
}

