/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.common.blocks;

import com.github.alienpatois.turtlemancy.common.entities.MagmaTurtleEntity;
import com.github.alienpatois.turtlemancy.core.init.BlockInit;
import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import com.github.alienpatois.turtlemancy.core.util.CoreUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class MagmaTurtleEggBlock
extends Block {
    private static final VoxelShape ONE_EGG_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTI_EGG_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.field_208128_ac;
    public static final IntegerProperty EGGS = BlockStateProperties.field_208127_ab;

    public MagmaTurtleEggBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HATCH, (Comparable)Integer.valueOf(0))).func_206870_a((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.tryTrample(worldIn, pos, entityIn, 100);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!(entityIn instanceof ZombieEntity)) {
            this.tryTrample(worldIn, pos, entityIn, 3);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    private void tryTrample(World worldIn, BlockPos pos, Entity trampler, int chances) {
        BlockState blockstate;
        if (this.canTrample(worldIn, trampler) && !worldIn.field_72995_K && worldIn.field_73012_v.nextInt(chances) == 0 && (blockstate = worldIn.func_180495_p(pos)).func_203425_a((Block)BlockInit.MAGMA_TURTLE_EGG.get())) {
            this.removeOneEgg(worldIn, pos, blockstate);
        }
    }

    private void removeOneEgg(World worldIn, BlockPos pos, BlockState state) {
        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + worldIn.field_73012_v.nextFloat() * 0.2f);
        int i = (Integer)state.func_177229_b((Property)EGGS);
        if (i <= 1) {
            worldIn.func_175655_b(pos, false);
        } else {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.canGrow((World)worldIn) && MagmaTurtleEggBlock.hasProperHabitat((IBlockReader)worldIn, pos)) {
            int i = (Integer)state.func_177229_b((Property)HATCH);
            if (i < 2) {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203280_iy, SoundCategory.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                worldIn.func_217377_a(pos, false);
                for (int j = 0; j < (Integer)state.func_177229_b((Property)EGGS); ++j) {
                    worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                    MagmaTurtleEntity MagmaTurtleEntity2 = (MagmaTurtleEntity)((EntityType)EntityTypeInit.MAGMA_TURTLE.get()).func_200721_a((World)worldIn);
                    MagmaTurtleEntity2.func_70873_a(-24000);
                    MagmaTurtleEntity2.setHome(pos);
                    MagmaTurtleEntity2.func_70012_b((double)pos.func_177958_n() + 0.3 + (double)j * 0.2, pos.func_177956_o(), (double)pos.func_177952_p() + 0.3, 0.0f, 0.0f);
                    worldIn.func_217376_c((Entity)MagmaTurtleEntity2);
                }
            }
        }
    }

    public static boolean hasProperHabitat(IBlockReader reader, BlockPos blockReader) {
        return MagmaTurtleEggBlock.isProperHabitat(reader, blockReader.func_177977_b());
    }

    public static boolean isProperHabitat(IBlockReader reader, BlockPos pos) {
        return reader.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_241277_aC_);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (MagmaTurtleEggBlock.hasProperHabitat((IBlockReader)worldIn, pos) && !worldIn.field_72995_K) {
            worldIn.func_217379_c(2005, pos, 0);
        }
    }

    private boolean canGrow(World worldIn) {
        return CoreUtil.getRandomIntInRange(0, 7) == 0;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.removeOneEgg(worldIn, pos, state);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)EGGS) < 4 ? true : super.func_196253_a(state, useContext);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        return blockstate.func_203425_a((Block)this) ? (BlockState)blockstate.func_206870_a((Property)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.func_177229_b((Property)EGGS) + 1))) : super.func_196258_a(context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Integer)state.func_177229_b((Property)EGGS) > 1 ? MULTI_EGG_SHAPE : ONE_EGG_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HATCH, EGGS});
    }

    private boolean canTrample(World worldIn, Entity trampler) {
        if (!(trampler instanceof MagmaTurtleEntity) && !(trampler instanceof BatEntity)) {
            if (!(trampler instanceof LivingEntity)) {
                return false;
            }
            return trampler instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)trampler);
        }
        return false;
    }
}

