/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy.client.render.entity;

import com.github.alienpatois.turtlemancy.client.render.model.BubbleModel;
import com.github.alienpatois.turtlemancy.common.entities.BubbleEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BubbleEntityRenderer<T extends BubbleEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("turtlemancy", "textures/entities/bubble_entity.png");
    private static final ResourceLocation EVIL_TEXTURE = new ResourceLocation("turtlemancy", "textures/entities/evil_bubble_entity.png");
    protected final BubbleModel<BubbleEntity> model = new BubbleModel();

    public BubbleEntityRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 1.0, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, -1.0f);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getEntityTexture((BubbleEntity)((Object)entityIn))));
        this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getEntityTexture() {
        return TEXTURE;
    }

    public ResourceLocation getEntityTexture(BubbleEntity entity) {
        if (entity.getEvil()) {
            return EVIL_TEXTURE;
        }
        return TEXTURE;
    }
}

