/*
 * Decompiled with CFR 0.152.
 */
package com.github.alienpatois.turtlemancy;

import com.github.alienpatois.turtlemancy.common.entities.MagmaTurtleEntity;
import com.github.alienpatois.turtlemancy.common.recipes.AltarRecipes;
import com.github.alienpatois.turtlemancy.common.recipes.TurtlemyRecipes;
import com.github.alienpatois.turtlemancy.compat.curios.CuriosCompatibility;
import com.github.alienpatois.turtlemancy.config.CommonConfig;
import com.github.alienpatois.turtlemancy.config.Config;
import com.github.alienpatois.turtlemancy.core.init.BlockInit;
import com.github.alienpatois.turtlemancy.core.init.ContainerTypeInit;
import com.github.alienpatois.turtlemancy.core.init.EnchantmentInit;
import com.github.alienpatois.turtlemancy.core.init.EntityTypeInit;
import com.github.alienpatois.turtlemancy.core.init.ItemInit;
import com.github.alienpatois.turtlemancy.core.init.TileEntityTypeInit;
import com.github.alienpatois.turtlemancy.networking.SimpleImpl;
import com.github.alienpatois.turtlemancy.world.ClientEvents;
import com.github.alienpatois.turtlemancy.world.TurtleStuffGeneration;
import com.github.alienpatois.turtlemancy.world.TurtlemancerInteractions;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.patchouli.api.PatchouliAPI;

@Mod(value="turtlemancy")
public class Turtlemancy {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "turtlemancy";

    public Turtlemancy() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.client_config);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::enqueueIMC);
        Config.loadConfig(Config.client_config, FMLPaths.CONFIGDIR.get().resolve("turtlemancy-common.toml").toString());
        EnchantmentInit.ENCHANTMENTS.register(bus);
        ItemInit.ITEMS.register(bus);
        BlockInit.BLOCKS.register(bus);
        EntityTypeInit.ENTITY_TYPES.register(bus);
        TileEntityTypeInit.TILE_ENTITY_TYPES.register(bus);
        ContainerTypeInit.CONTAINER_TYPES.register(bus);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, TurtleStuffGeneration::generateStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
            return new Object();
        });
    }

    private void setup(FMLCommonSetupEvent event) {
        SimpleImpl.onCommonSetupEvent();
        MinecraftForge.EVENT_BUS.register(TurtlemancerInteractions.class);
        event.enqueueWork(() -> {
            TurtlemyRecipes.init();
            AltarRecipes.init();
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.MAGMA_TURTLE.get()), (AttributeModifierMap)MagmaTurtleEntity.func_234228_eK_().func_233813_a_());
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityTypeInit.MAGMA_TURTLE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MagmaTurtleEntity::canMASpawn);
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        CuriosCompatibility.sendImc(event);
        PatchouliAPI.instance.setConfigFlag("turtlemancy:bedrockPickaxeEnabled", ((Boolean)CommonConfig.bedrock_pickaxe.get()).booleanValue());
        PatchouliAPI.instance.setConfigFlag("turtlemancy:shellOfEncapsulationEnabled", ((Boolean)CommonConfig.bedrock_pickaxe.get()).booleanValue());
        PatchouliAPI.instance.setConfigFlag("turtlemancy:turtlemyBedrockTweak", ((Boolean)CommonConfig.turtlemy_bedrock.get()).booleanValue());
    }

    public static class TurtlemancyItemGroup
    extends ItemGroup {
        public static final TurtlemancyItemGroup instance = new TurtlemancyItemGroup(ItemGroup.field_78032_a.length, "turtlemancytab");

        private TurtlemancyItemGroup(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemInit.BEWITCHED_SHELL_NECKLACE.get());
        }
    }
}

