/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.spell;

import elucent.eidolon.block.TableBlockBase;
import elucent.eidolon.spell.AltarEntries;
import elucent.eidolon.spell.AltarEntry;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AltarInfo {
    Block icon = null;
    Block altar = null;
    Map<ResourceLocation, AltarAttributes> attributes = new HashMap<ResourceLocation, AltarAttributes>();

    public static Set<BlockPos> getAltarPositions(World world, BlockPos pos) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> visit = new ArrayDeque<BlockPos>();
        BlockState below = world.func_180495_p(pos.func_177977_b());
        Block b = below.func_177230_c();
        if (below.func_177230_c() instanceof TableBlockBase) {
            visit.add(pos.func_177977_b());
        }
        while (!visit.isEmpty()) {
            BlockPos visited = (BlockPos)visit.remove();
            if (result.contains(visited)) continue;
            result.add(visited);
            for (Direction d : BlockStateProperties.field_208157_J.func_177700_c()) {
                if (world.func_180495_p(visited.func_177972_a(d)).func_177230_c() != b || result.contains(visited.func_177972_a(d))) continue;
                visit.add(visited.func_177972_a(d));
            }
        }
        return result;
    }

    public static AltarInfo getAltarInfo(World world, BlockPos pos) {
        AltarInfo info = new AltarInfo();
        info.icon = world.func_180495_p(pos).func_177230_c();
        Set<BlockPos> altarPositions = AltarInfo.getAltarPositions(world, pos);
        for (BlockPos p : altarPositions) {
            BlockState state;
            AltarEntry entry;
            if (info.altar == null) {
                info.altar = world.func_180495_p(p).func_177230_c();
            }
            if ((entry = AltarEntries.find(state = world.func_180495_p(p.func_177984_a()))) == null) continue;
            entry.apply(info);
        }
        return info;
    }

    protected void increaseCapacity(ResourceLocation key, double value) {
        AltarAttributes attrs = this.attributes.computeIfAbsent(key, k -> new AltarAttributes());
        attrs.capacity = Math.max(attrs.capacity, value);
    }

    protected void increasePower(ResourceLocation key, double value) {
        AltarAttributes attrs = this.attributes.computeIfAbsent(key, k -> new AltarAttributes());
        attrs.power = Math.max(attrs.power, value);
    }

    public double getCapacity() {
        double sum = 0.0;
        for (Map.Entry<ResourceLocation, AltarAttributes> key : this.attributes.entrySet()) {
            sum += key.getValue().capacity;
        }
        return sum;
    }

    public double getPower() {
        double sum = 0.0;
        for (Map.Entry<ResourceLocation, AltarAttributes> key : this.attributes.entrySet()) {
            sum += key.getValue().power;
        }
        return sum;
    }

    public Block getIcon() {
        return this.icon;
    }

    public Block getAltar() {
        return this.altar;
    }

    public boolean hasKey(ResourceLocation loc) {
        return this.attributes.containsKey(loc);
    }

    static class AltarAttributes {
        public double capacity = 0.0;
        public double power = 0.0;
    }
}

