/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.ritual;

import elucent.eidolon.Registry;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualConsumePacket;
import elucent.eidolon.ritual.IRequirement;
import elucent.eidolon.ritual.RequirementInfo;
import elucent.eidolon.ritual.Ritual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HealthRequirement
implements IRequirement {
    float health;

    public HealthRequirement(float health) {
        this.health = health;
    }

    @Override
    public RequirementInfo isMet(Ritual ritual, World world, BlockPos pos) {
        List entities = world.func_175647_a(CreatureEntity.class, Ritual.getDefaultBounds(pos), entity -> !entity.func_70662_br());
        List players = world.func_217357_a(PlayerEntity.class, Ritual.getDefaultBounds(pos));
        ArrayList targets = new ArrayList();
        targets.addAll(entities);
        targets.addAll(players);
        float acc = 0.0f;
        for (int i = 0; i < targets.size(); ++i) {
            if (!((acc += ((LivingEntity)targets.get(i)).func_110143_aJ()) >= this.health)) continue;
            return RequirementInfo.TRUE;
        }
        return RequirementInfo.FALSE;
    }

    @Override
    public void whenMet(Ritual ritual, World world, BlockPos pos, RequirementInfo info) {
        List entities = world.func_175647_a(CreatureEntity.class, Ritual.getDefaultBounds(pos), entity -> !entity.func_70662_br());
        List players = world.func_217357_a(PlayerEntity.class, Ritual.getDefaultBounds(pos));
        ArrayList targets = new ArrayList();
        targets.addAll(entities);
        targets.addAll(players);
        float acc = 0.0f;
        for (int i = 0; i < targets.size(); ++i) {
            float targetHealth = ((LivingEntity)targets.get(i)).func_110143_aJ();
            if (this.health - acc < targetHealth) {
                ((LivingEntity)targets.get(i)).func_70097_a(Registry.RITUAL_DAMAGE, this.health - acc);
            } else {
                ((LivingEntity)targets.get(i)).func_70097_a(Registry.RITUAL_DAMAGE, targetHealth);
            }
            acc += targetHealth;
            if (!world.field_72995_K) {
                Networking.sendToTracking(world, pos, new RitualConsumePacket(((LivingEntity)targets.get(i)).func_233580_cy_(), pos, ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
            }
            if (!(acc >= this.health)) continue;
            return;
        }
    }
}

