/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.item.curio;

import elucent.eidolon.Registry;
import elucent.eidolon.entity.SpellProjectileEntity;
import elucent.eidolon.item.ItemBase;
import elucent.eidolon.item.curio.EidolonCurio;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class VoidAmuletItem
extends ItemBase {
    public VoidAmuletItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(VoidAmuletItem::onDamage);
    }

    static int getCooldown(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("cooldown")) {
            return stack.func_77978_p().func_74762_e("cooldown");
        }
        return 0;
    }

    static void setCooldown(ItemStack stack, int cooldown) {
        stack.func_196082_o().func_74768_a("cooldown", cooldown);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT unused) {
        return new EidolonCurio(stack){

            public void curioTick(String type, int index, LivingEntity entity) {
                if (!entity.field_70170_p.field_72995_K && VoidAmuletItem.getCooldown(stack) > 0) {
                    VoidAmuletItem.setCooldown(stack, VoidAmuletItem.getCooldown(stack) - 1);
                }
            }

            public boolean canRightClickEquip() {
                return true;
            }
        };
    }

    @SubscribeEvent
    public static void onDamage(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            CuriosApi.getCuriosHelper().getEquippedCurios(event.getEntityLiving()).resolve().ifPresent(slots -> {
                int i;
                boolean hasVoid = false;
                for (i = 0; i < slots.getSlots(); ++i) {
                    if (slots.getStackInSlot(i).func_77973_b() != Registry.VOID_AMULET.get() || VoidAmuletItem.getCooldown(slots.getStackInSlot(i)) != 0) continue;
                    hasVoid = true;
                    break;
                }
                ItemStack stack = slots.getStackInSlot(i);
                if (hasVoid && (event.getSource().func_76364_f() instanceof FireballEntity || event.getSource().func_76364_f() instanceof LlamaSpitEntity || event.getSource().func_76364_f() instanceof SmallFireballEntity || event.getSource().func_76364_f() instanceof ShulkerBulletEntity || event.getSource().func_76364_f() instanceof PotionEntity || event.getSource().func_76364_f() instanceof SpellProjectileEntity)) {
                    event.setCanceled(true);
                    if (!event.getEntity().func_130014_f_().field_72995_K) {
                        event.getEntity().func_130014_f_().func_184133_a(null, event.getEntity().func_233580_cy_(), SoundEvents.field_187851_gB, SoundCategory.PLAYERS, 1.0f, 0.75f);
                        VoidAmuletItem.setCooldown(stack, 200);
                    }
                }
            });
        }
    }
}

