/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui.jei;

import elucent.eidolon.Registry;
import elucent.eidolon.gui.jei.CrucibleCategory;
import elucent.eidolon.gui.jei.RitualCategory;
import elucent.eidolon.gui.jei.WorktableCategory;
import elucent.eidolon.recipe.CrucibleRegistry;
import elucent.eidolon.recipe.WorktableRegistry;
import elucent.eidolon.ritual.RitualRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIRegistry
implements IModPlugin {
    public static IRecipeCategory CRUCIBLE_CATEGORY;
    public static IRecipeCategory WORKTABLE_CATEGORY;
    public static IRecipeCategory RITUAL_CATEGORY;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("eidolon", "jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Registry.CRUCIBLE.get()), new ResourceLocation[]{CRUCIBLE_CATEGORY.getUid()});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Registry.WORKTABLE.get()), new ResourceLocation[]{WORKTABLE_CATEGORY.getUid()});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Registry.BRAZIER.get()), new ResourceLocation[]{RITUAL_CATEGORY.getUid()});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        CRUCIBLE_CATEGORY = new CrucibleCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{CRUCIBLE_CATEGORY});
        WORKTABLE_CATEGORY = new WorktableCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{WORKTABLE_CATEGORY});
        RITUAL_CATEGORY = new RitualCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{RITUAL_CATEGORY});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(CrucibleRegistry.getWrappedRecipes(), CRUCIBLE_CATEGORY.getUid());
        registry.addRecipes(WorktableRegistry.getWrappedRecipes(), WORKTABLE_CATEGORY.getUid());
        registry.addRecipes(RitualRegistry.getWrappedRecipes(), RITUAL_CATEGORY.getUid());
    }
}

