/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import elucent.eidolon.Registry;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.gui.jei.RecipeWrappers;
import elucent.eidolon.recipe.CrucibleRecipe;
import elucent.eidolon.recipe.CrucibleRegistry;
import elucent.eidolon.util.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CrucibleCategory
implements IRecipeCategory<RecipeWrappers.Crucible> {
    static final ResourceLocation UID = new ResourceLocation("eidolon", "crucible");
    private final IDrawable background;
    private final IDrawable icon;

    public CrucibleCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("eidolon", "textures/gui/jei_page_bg.png"), 0, 0, 138, 172);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Registry.CRUCIBLE.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class getRecipeClass() {
        return RecipeWrappers.Crucible.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.eidolon.crucible", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public static void condense(List<StackIngredient> stacks) {
        Iterator<StackIngredient> iter = stacks.iterator();
        StackIngredient last = new StackIngredient(ItemStack.field_190927_a, Ingredient.field_193370_a);
        while (iter.hasNext()) {
            StackIngredient i = iter.next();
            if (!ItemStack.func_179545_c((ItemStack)i.stack, (ItemStack)last.stack) || !ItemStack.func_77970_a((ItemStack)i.stack, (ItemStack)last.stack) || last.stack.func_190916_E() + i.stack.func_190916_E() > last.stack.func_77976_d()) {
                last = i;
                continue;
            }
            last.stack.func_190917_f(i.stack.func_190916_E());
            iter.remove();
        }
    }

    public void setIngredients(RecipeWrappers.Crucible wrapper, IIngredients ingredients) {
        if (wrapper.page == null) {
            wrapper.page = CrucibleRegistry.getDefaultPage(wrapper.recipe);
        }
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        for (CrucibleRecipe.Step step : wrapper.recipe.getSteps()) {
            ArrayList<StackIngredient> stepInputs = new ArrayList<StackIngredient>();
            for (Object o : step.matches) {
                ItemStack stack = StackUtil.stackFromObject(o);
                if (stack.func_190926_b()) continue;
                stepInputs.add(new StackIngredient(stack, StackUtil.ingredientFromObject(o)));
            }
            CrucibleCategory.condense(stepInputs);
            for (StackIngredient i : stepInputs) {
                ItemStack[] valid;
                for (ItemStack stack : valid = i.ingredient.func_193365_a()) {
                    stack.func_190920_e(i.stack.func_190916_E());
                }
                inputs.add(Arrays.asList(valid));
            }
        }
        ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)wrapper.recipe.getResult());
    }

    public void setRecipe(IRecipeLayout layout, RecipeWrappers.Crucible recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List<CrucibleRecipe.Step> steps = recipe.recipe.getSteps();
        int h = steps.size() * 20 + 32;
        int yoff = 80 - h / 2;
        int slot = 0;
        for (int i = 0; i < steps.size(); ++i) {
            int tx = 4;
            int ty = 3 + yoff + i * 20;
            tx += 24;
            ArrayList<StackIngredient> stepInputs = new ArrayList<StackIngredient>();
            for (Object o : steps.get((int)i).matches) {
                ItemStack stack = StackUtil.stackFromObject(o);
                if (stack.func_190926_b()) continue;
                stepInputs.add(new StackIngredient(stack, Ingredient.field_193370_a));
            }
            CrucibleCategory.condense(stepInputs);
            for (int j = 0; j < stepInputs.size(); ++j) {
                stacks.init(slot++, true, tx, ty);
                tx += 17;
            }
        }
        stacks.init(slot++, false, 60, yoff + steps.size() * 20 + 14);
        stacks.set(ingredients);
    }

    public void draw(RecipeWrappers.Crucible recipe, MatrixStack mStack, double mouseX, double mouseY) {
        recipe.page.renderBackground(CodexGui.DUMMY, mStack, 5, 4, (int)mouseX, (int)mouseY);
        recipe.page.render(CodexGui.DUMMY, mStack, 5, 4, (int)mouseX, (int)mouseY);
    }

    protected static class StackIngredient {
        ItemStack stack;
        Ingredient ingredient;

        public StackIngredient(ItemStack stack, Ingredient ingredient) {
            this.stack = stack;
            this.ingredient = ingredient;
        }
    }
}

