/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.matrix.MatrixStack;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.recipe.CrucibleRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CruciblePage
extends Page {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_crucible_page.png");
    ItemStack result;
    CrucibleStep[] steps;

    public CruciblePage(ItemStack result, CrucibleStep ... steps) {
        super(BACKGROUND);
        this.result = result;
        this.steps = steps;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, MatrixStack mStack, int x, int y, int mouseX, int mouseY) {
        int h = this.steps.length * 20 + 32;
        int yoff = 80 - h / 2;
        for (int i = 0; i < this.steps.length; ++i) {
            int j;
            int tx = x;
            int ty = y + yoff + i * 20;
            gui.func_238474_b_(mStack, tx, ty, 128, 0, 128, 20);
            tx += 24;
            for (j = 0; j < this.steps[i].stacks.length; ++j) {
                if (this.steps[i].stacks[j].func_190926_b()) continue;
                gui.func_238474_b_(mStack, tx, ty + 1, 176, 32, 16, 17);
                tx += 17;
            }
            for (j = 0; j < this.steps[i].stirs; ++j) {
                gui.func_238474_b_(mStack, tx, ty + 1, 192, 32, 16, 17);
                tx += 17;
            }
        }
        gui.func_238474_b_(mStack, x, y + yoff + this.steps.length * 20, 128, 64, 128, 32);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < this.steps.length; ++i) {
            int tx = x;
            int ty = y + yoff + i * 20;
            String string = I18n.func_135052_a((String)("enchantment.level." + (i + 1)), (Object[])new Object[0]) + ".";
            font.getClass();
            CruciblePage.drawText(gui, mStack, string, tx + 7, ty + 17 - 9);
            tx += 24;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderIngredients(CodexGui gui, MatrixStack mStack, int x, int y, int mouseX, int mouseY) {
        int h = this.steps.length * 20 + 32;
        int yoff = 80 - h / 2;
        for (int i = 0; i < this.steps.length; ++i) {
            int tx = x;
            int ty = y + yoff + i * 20;
            tx += 24;
            for (int j = 0; j < this.steps[i].stacks.length; ++j) {
                if (this.steps[i].stacks[j].func_190926_b()) continue;
                CruciblePage.drawItem(gui, mStack, this.steps[i].stacks[j], tx, ty + 1, mouseX, mouseY);
                tx += 17;
            }
        }
        CruciblePage.drawItem(gui, mStack, this.result, x + 56, y + yoff + this.steps.length * 20 + 11, mouseX, mouseY);
    }

    public CruciblePage linkRecipe(String modid, String recipe) {
        return this.linkRecipe(new ResourceLocation(modid, recipe));
    }

    public CruciblePage linkRecipe(ResourceLocation recipe) {
        CrucibleRegistry.linkPage(recipe, this);
        return this;
    }

    public static class CrucibleStep {
        ItemStack[] stacks;
        int stirs;

        public CrucibleStep(int stirs) {
            this(stirs, ItemStack.field_190927_a);
        }

        public CrucibleStep(ItemStack ... stacks) {
            this(0, stacks);
        }

        public CrucibleStep(int stirs, ItemStack ... stacks) {
            this.stacks = stacks;
            this.stirs = stirs;
        }
    }
}

