/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import elucent.eidolon.ClientEvents;
import elucent.eidolon.codex.Category;
import elucent.eidolon.codex.Chapter;
import elucent.eidolon.codex.CodexChapters;
import elucent.eidolon.codex.Page;
import elucent.eidolon.network.AttemptCastPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CodexGui
extends Screen {
    public static final CodexGui DUMMY = new CodexGui();
    public static final ResourceLocation CODEX_BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_bg.png");
    static int xSize = 312;
    static int ySize = 208;
    List<Sign> chant = new ArrayList<Sign>();
    Chapter currentChapter = CodexChapters.NATURE_INDEX;
    int currentPage = 0;
    static CodexGui INSTANCE = null;

    public static CodexGui getInstance() {
        for (Category cat : CodexChapters.categories) {
            cat.reset();
        }
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new CodexGui();
        return INSTANCE;
    }

    protected CodexGui() {
        super((ITextComponent)new TranslationTextComponent("gui.eidolon.codex.title"));
    }

    protected void resetPages() {
        Page left = this.currentChapter.get(this.currentPage);
        Page right = this.currentChapter.get(this.currentPage + 1);
        if (left != null) {
            left.reset();
        }
        if (right != null) {
            right.reset();
        }
    }

    protected void changeChapter(Chapter next) {
        this.currentChapter = next;
        this.currentPage = 0;
    }

    public void addToChant(Sign sign) {
        if (this.chant.size() < 9) {
            this.chant.add(sign);
        }
    }

    protected void renderChant(MatrixStack mStack, int x, int y, int mouseX, int mouseY, float pticks) {
        int chantWidth = 32 + 24 * this.chant.size();
        int baseX = x + xSize / 2 - chantWidth / 2;
        int baseY = y + 180;
        RenderSystem.enableBlend();
        RenderSystem.alphaFunc((int)518, (float)0.00390625f);
        int bgx = baseX;
        CodexGui.func_238463_a_((MatrixStack)mStack, (int)bgx, (int)baseY, (float)256.0f, (float)208.0f, (int)16, (int)32, (int)512, (int)512);
        bgx += 16;
        for (int i = 0; i < this.chant.size(); ++i) {
            CodexGui.func_238463_a_((MatrixStack)mStack, (int)bgx, (int)baseY, (float)272.0f, (float)208.0f, (int)24, (int)32, (int)512, (int)512);
            CodexGui.func_238463_a_((MatrixStack)mStack, (int)bgx, (int)baseY, (float)312.0f, (float)208.0f, (int)24, (int)24, (int)512, (int)512);
            bgx += 24;
        }
        CodexGui.func_238463_a_((MatrixStack)mStack, (int)bgx, (int)baseY, (float)296.0f, (float)208.0f, (int)16, (int)32, (int)512, (int)512);
        boolean chantHover = mouseX >= (bgx += 24) && mouseY >= baseY - 4 && mouseX <= bgx + 32 && mouseY <= baseY + 28;
        CodexGui.func_238463_a_((MatrixStack)mStack, (int)bgx, (int)(baseY - 4), (float)336.0f, (float)(chantHover ? 240.0f : 208.0f), (int)32, (int)32, (int)512, (int)512);
        boolean cancelHover = mouseX >= (bgx += 36) && mouseY >= baseY - 4 && mouseX <= bgx + 32 && mouseY <= baseY + 28;
        CodexGui.func_238463_a_((MatrixStack)mStack, (int)bgx, (int)(baseY - 4), (float)368.0f, (float)(cancelHover ? 240.0f : 208.0f), (int)32, (int)32, (int)512, (int)512);
        if (chantHover) {
            this.func_238652_a_(mStack, (ITextComponent)new TranslationTextComponent("eidolon.codex.chant_hover"), mouseX, mouseY);
        }
        if (cancelHover) {
            this.func_238652_a_(mStack, (ITextComponent)new TranslationTextComponent("eidolon.codex.cancel_hover"), mouseX, mouseY);
        }
        RenderSystem.enableBlend();
        RenderSystem.alphaFunc((int)518, (float)0.00390625f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        bgx = baseX + 16;
        Tessellator tess = Tessellator.func_178181_a();
        for (int i = 0; i < this.chant.size(); ++i) {
            Sign sign = this.chant.get(i);
            RenderUtil.litQuad(mStack, (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)tess.func_178180_c()), bgx + 4, baseY + 4, 16.0, 16.0, sign.getRed(), sign.getGreen(), sign.getBlue(), (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(sign.getSprite()));
            tess.func_78381_a();
            bgx += 24;
        }
        bgx = baseX + 16;
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        float flicker = 0.875f + 0.125f * (float)Math.sin(Math.toRadians(12.0f * ClientEvents.getClientTicks()));
        for (int i = 0; i < this.chant.size(); ++i) {
            Sign sign = this.chant.get(i);
            RenderUtil.litQuad(mStack, (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)tess.func_178180_c()), bgx + 4, baseY + 4, 16.0, 16.0, sign.getRed() * flicker, sign.getGreen() * flicker, sign.getBlue() * flicker, (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(sign.getSprite()));
            tess.func_78381_a();
            bgx += 24;
        }
        RenderSystem.defaultAlphaFunc();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(field_230663_f_);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int v;
        int y;
        int x;
        this.func_230446_a_(matrixStack);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(CODEX_BACKGROUND);
        this.field_230708_k_ = mc.func_228018_at_().func_198107_o();
        this.field_230709_l_ = mc.func_228018_at_().func_198087_p();
        int guiLeft = (this.field_230708_k_ - xSize) / 2;
        int guiTop = (this.field_230709_l_ - ySize) / 2;
        CodexGui.func_238463_a_((MatrixStack)matrixStack, (int)guiLeft, (int)guiTop, (float)0.0f, (float)256.0f, (int)xSize, (int)ySize, (int)512, (int)512);
        for (int i = 0; i < CodexChapters.categories.size(); ++i) {
            int y2 = guiTop + 28 + i % 8 * 20;
            CodexChapters.categories.get(i).draw(this, matrixStack, guiLeft + (i >= 8 ? 304 : 8), y2, i >= 8, mouseX, mouseY);
        }
        mc.func_110434_K().func_110577_a(CODEX_BACKGROUND);
        CodexGui.func_238463_a_((MatrixStack)matrixStack, (int)guiLeft, (int)guiTop, (float)0.0f, (float)0.0f, (int)xSize, (int)ySize, (int)512, (int)512);
        Page left = this.currentChapter.get(this.currentPage);
        Page right = this.currentChapter.get(this.currentPage + 1);
        if (left != null) {
            left.fullRender(this, matrixStack, guiLeft + 14, guiTop + 24, mouseX, mouseY);
        }
        if (right != null) {
            right.fullRender(this, matrixStack, guiLeft + 170, guiTop + 24, mouseX, mouseY);
        }
        mc.func_110434_K().func_110577_a(CODEX_BACKGROUND);
        if (this.currentPage > 0) {
            x = 10;
            y = 169;
            v = 208;
            if (mouseX >= guiLeft + x && mouseY >= guiTop + y && mouseX <= guiLeft + x + 32 && mouseY <= guiTop + y + 16) {
                v += 18;
            }
            CodexGui.func_238463_a_((MatrixStack)matrixStack, (int)(guiLeft + x), (int)(guiTop + y), (float)128.0f, (float)v, (int)32, (int)18, (int)512, (int)512);
        }
        if (this.currentPage + 2 < this.currentChapter.size()) {
            x = 270;
            y = 169;
            v = 208;
            if (mouseX >= guiLeft + x && mouseY >= guiTop + y && mouseX <= guiLeft + x + 32 && mouseY <= guiTop + y + 16) {
                v += 18;
            }
            CodexGui.func_238463_a_((MatrixStack)matrixStack, (int)(guiLeft + x), (int)(guiTop + y), (float)160.0f, (float)v, (int)32, (int)18, (int)512, (int)512);
        }
        if (this.chant.size() > 0) {
            this.renderChant(matrixStack, guiLeft, guiTop, mouseX, mouseY, partialTicks);
        }
        for (int i = 0; i < CodexChapters.categories.size(); ++i) {
            y = guiTop + 28 + i % 8 * 20;
            CodexChapters.categories.get(i).drawTooltip(this, matrixStack, guiLeft + (i >= 8 ? 304 : 8), y, i >= 8, mouseX, mouseY);
        }
    }

    protected boolean interactChant(int x, int y, int mouseX, int mouseY) {
        boolean cancelHover;
        int chantWidth = 32 + 24 * this.chant.size();
        int baseX = x + xSize / 2 - chantWidth / 2;
        int baseY = y + 180;
        int bgx = baseX + chantWidth + 8;
        boolean chantHover = mouseX >= bgx && mouseY >= baseY - 4 && mouseX <= bgx + 32 && mouseY <= baseY + 28;
        boolean bl = cancelHover = mouseX >= (bgx += 36) && mouseY >= baseY - 4 && mouseX <= bgx + 32 && mouseY <= baseY + 28;
        if (chantHover) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Networking.sendToServer(new AttemptCastPacket((PlayerEntity)player, this.chant));
            this.chant.clear();
            player.func_213823_a(SoundEvents.field_187909_gi, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            this.func_231175_as__();
            return true;
        }
        if (cancelHover) {
            this.chant.clear();
            Minecraft.func_71410_x().field_71439_g.func_213823_a(SoundEvents.field_187909_gi, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int y;
            int x;
            Minecraft mc = Minecraft.func_71410_x();
            this.field_230708_k_ = mc.func_228018_at_().func_198107_o();
            this.field_230709_l_ = mc.func_228018_at_().func_198087_p();
            int guiLeft = (this.field_230708_k_ - xSize) / 2;
            int guiTop = (this.field_230709_l_ - ySize) / 2;
            if (this.currentPage > 0) {
                x = guiLeft + 10;
                y = guiTop + 169;
                if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 32) && mouseY <= (double)(y + 16)) {
                    this.currentPage -= 2;
                    Minecraft.func_71410_x().field_71439_g.func_213823_a(SoundEvents.field_219617_ah, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    this.resetPages();
                    return true;
                }
            }
            if (this.currentPage + 2 < this.currentChapter.size()) {
                x = guiLeft + 270;
                y = guiTop + 169;
                if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 32) && mouseY <= (double)(y + 16)) {
                    this.currentPage += 2;
                    Minecraft.func_71410_x().field_71439_g.func_213823_a(SoundEvents.field_219617_ah, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    this.resetPages();
                    return true;
                }
            }
            for (int i = 0; i < CodexChapters.categories.size(); ++i) {
                y = guiTop + 28 + i % 8 * 20;
                if (!CodexChapters.categories.get(i).click(this, guiLeft + (i >= 8 ? 304 : 8), y, i >= 8, (int)mouseX, (int)mouseY)) continue;
                return true;
            }
            Page left = this.currentChapter.get(this.currentPage);
            Page right = this.currentChapter.get(this.currentPage + 1);
            if (left != null && left.click(this, guiLeft + 14, guiTop + 24, (int)mouseX, (int)mouseY)) {
                return true;
            }
            if (right != null && right.click(this, guiLeft + 170, guiTop + 24, (int)mouseX, (int)mouseY)) {
                return true;
            }
            if (this.chant.size() > 0 && this.interactChant(guiLeft, guiTop, (int)mouseX, (int)mouseY)) {
                return true;
            }
        }
        return false;
    }

    public void func_230457_a_(MatrixStack mStack, ItemStack stack, int x, int y) {
        if (!stack.func_190926_b()) {
            super.func_230457_a_(mStack, stack, x, y);
        }
    }
}

