/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import elucent.eidolon.Config;
import elucent.eidolon.Registry;
import elucent.eidolon.world.CatacombPieces;
import elucent.eidolon.world.CatacombStructure;
import elucent.eidolon.world.LabStructure;
import elucent.eidolon.world.StrayTowerStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class WorldGen {
    static List<ConfiguredFeature<?, ?>> ORES = new ArrayList();
    static ConfiguredFeature<?, ?> LEAD_ORE_GEN;
    static DeferredRegister<Structure<?>> STRUCTURES;
    static List<Structure<?>> STRUCTURE_LIST;
    static Map<ResourceLocation, StructureSeparationSettings> STRUCTURE_SETTINGS;
    static RuleTest IN_STONE;
    public static IStructurePieceType LAB_PIECE;
    public static IStructurePieceType STRAY_TOWER_PIECE;
    public static RegistryObject<Structure<NoFeatureConfig>> LAB_STRUCTURE;
    public static RegistryObject<Structure<NoFeatureConfig>> STRAY_TOWER_STRUCTURE;
    public static RegistryObject<Structure<NoFeatureConfig>> CATACOMB_STRUCTURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> LAB_FEATURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> STRAY_TOWER_FEATURE;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> CATACOMB_FEATURE;

    static IStructurePieceType register(IStructurePieceType type, String name) {
        net.minecraft.util.registry.Registry.func_218322_a((net.minecraft.util.registry.Registry)net.minecraft.util.registry.Registry.field_218362_C, (ResourceLocation)new ResourceLocation("eidolon", name), (Object)type);
        return type;
    }

    static <C extends IFeatureConfig, F extends Feature<C>> ConfiguredFeature<C, F> register(ConfiguredFeature<C, F> feature, String name) {
        WorldGenRegistries.func_243664_a((net.minecraft.util.registry.Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("eidolon", name), feature);
        return feature;
    }

    static <C extends IFeatureConfig, S extends Structure<C>> StructureFeature<C, S> register(StructureFeature<C, S> feature, String name) {
        WorldGenRegistries.func_243664_a((net.minecraft.util.registry.Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("eidolon", name), feature);
        return feature;
    }

    static <C extends IFeatureConfig> RegistryObject<Structure<C>> addStructure(String name, Structure<C> structure, GenerationStage.Decoration stage, StructureSeparationSettings settings) {
        Structure.field_236365_a_.put((Object)("eidolon:" + name), structure);
        Structure.field_236385_u_.put(structure, stage);
        STRUCTURE_LIST.add(structure);
        STRUCTURE_SETTINGS.put(new ResourceLocation("eidolon", name), settings);
        if (stage != GenerationStage.Decoration.UNDERGROUND_STRUCTURES) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        return STRUCTURES.register(name, () -> structure);
    }

    public static void preInit() {
        STRUCTURES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void init() {
        LEAD_ORE_GEN = WorldGen.register((ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(IN_STONE, ((Block)Registry.LEAD_ORE.get()).func_176223_P(), ((Integer)Config.LEAD_VEIN_SIZE.get()).intValue())).func_242728_a()).func_242731_b(((Integer)Config.LEAD_VEIN_COUNT.get()).intValue())).func_242733_d(((Integer)Config.LEAD_MAX_Y.get()).intValue()), "lead_ore");
        if (((Boolean)Config.LEAD_ENABLED.get()).booleanValue()) {
            ORES.add(LEAD_ORE_GEN);
        }
        LAB_PIECE = WorldGen.register(LabStructure.Piece::new, "lab");
        LAB_FEATURE = WorldGen.register(((Structure)LAB_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "lab");
        STRAY_TOWER_PIECE = WorldGen.register(StrayTowerStructure.Piece::new, "stray_tower");
        STRAY_TOWER_FEATURE = WorldGen.register(((Structure)STRAY_TOWER_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "stray_tower");
        CatacombPieces.CORRIDOR_CENTER = WorldGen.register(CatacombPieces.CorridorCenter::new, CatacombPieces.CORRIDOR_CENTER_ID.func_110623_a());
        CatacombPieces.CORRIDOR_DOOR = WorldGen.register(CatacombPieces.CorridorDoor::new, CatacombPieces.CORRIDOR_DOOR_ID.func_110623_a());
        CatacombPieces.SMALL_ROOM = WorldGen.register(CatacombPieces.SmallRoom::new, CatacombPieces.SMALL_ROOM_ID.func_110623_a());
        CatacombPieces.SHRINE = WorldGen.register(CatacombPieces.Shrine::new, CatacombPieces.SHRINE_ID.func_110623_a());
        CatacombPieces.TRAP = WorldGen.register(CatacombPieces.Trap::new, CatacombPieces.TRAP_ID.func_110623_a());
        CatacombPieces.SKULL = WorldGen.register(CatacombPieces.Skull::new, CatacombPieces.SKULL_ID.func_110623_a());
        CatacombPieces.SPAWNER = WorldGen.register(CatacombPieces.Spawner::new, CatacombPieces.SPAWNER_ID.func_110623_a());
        CatacombPieces.COFFIN = WorldGen.register(CatacombPieces.Coffin::new, CatacombPieces.COFFIN_ID.func_110623_a());
        CatacombPieces.MEDIUM_ROOM = WorldGen.register(CatacombPieces.MediumRoom::new, CatacombPieces.MEDIUM_ROOM_ID.func_110623_a());
        CatacombPieces.GRAVEYARD = WorldGen.register(CatacombPieces.Graveyard::new, CatacombPieces.GRAVEYARD_ID.func_110623_a());
        CatacombPieces.TURNAROUND = WorldGen.register(CatacombPieces.Turnaround::new, CatacombPieces.TURNAROUND_ID.func_110623_a());
        CatacombPieces.LAB = WorldGen.register(CatacombPieces.Lab::new, CatacombPieces.LAB_ID.func_110623_a());
        CATACOMB_FEATURE = WorldGen.register(((Structure)CATACOMB_STRUCTURE.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_), "catacomb");
        for (Structure<?> s : STRUCTURE_LIST) {
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(s, (Object)STRUCTURE_SETTINGS.get(s.getRegistryName())).build();
            DimensionSettings.field_242740_q.func_236108_a_().field_236193_d_.put(s, STRUCTURE_SETTINGS.get(s.getRegistryName()));
        }
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        for (ConfiguredFeature<?, ?> feature : ORES) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature);
        }
        if (((Boolean)Config.LAB_ENABLED.get()).booleanValue()) {
            event.getGeneration().func_242516_a(LAB_FEATURE);
        }
        if (((Boolean)Config.CATACOMB_ENABLED.get()).booleanValue()) {
            event.getGeneration().func_242516_a(CATACOMB_FEATURE);
        }
        if (event.getCategory() == Biome.Category.ICY && ((Boolean)Config.STRAY_TOWER_ENABLED.get()).booleanValue()) {
            event.getGeneration().func_242516_a(STRAY_TOWER_FEATURE);
        }
    }

    static {
        STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"eidolon");
        STRUCTURE_LIST = new ArrayList();
        STRUCTURE_SETTINGS = new HashMap<ResourceLocation, StructureSeparationSettings>();
        IN_STONE = new TagMatchRuleTest((ITag)Tags.Blocks.STONE);
        LAB_STRUCTURE = WorldGen.addStructure("lab", new LabStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(7, 5, 1337));
        STRAY_TOWER_STRUCTURE = WorldGen.addStructure("stray_tower", new StrayTowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(16, 8, 1341));
        CATACOMB_STRUCTURE = WorldGen.addStructure("catacomb", new CatacombStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(11, 7, 1347));
    }
}

