/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon;

import elucent.eidolon.Eidolon;
import elucent.eidolon.block.BlockBase;
import elucent.eidolon.block.CandleBlock;
import elucent.eidolon.block.CandlestickBlock;
import elucent.eidolon.block.EnchantedAshBlock;
import elucent.eidolon.block.HorizontalWaterloggableBlock;
import elucent.eidolon.block.NecroticFocusBlock;
import elucent.eidolon.block.PlinthBlockBase;
import elucent.eidolon.block.SoulEnchanterBlock;
import elucent.eidolon.block.TableBlockBase;
import elucent.eidolon.block.WoodenStandBlock;
import elucent.eidolon.block.WorktableBlock;
import elucent.eidolon.entity.BonechillProjectileEntity;
import elucent.eidolon.entity.ChantCasterEntity;
import elucent.eidolon.entity.NecromancerEntity;
import elucent.eidolon.entity.NecromancerSpellEntity;
import elucent.eidolon.entity.SoulfireProjectileEntity;
import elucent.eidolon.entity.WraithEntity;
import elucent.eidolon.entity.ZombieBruteEntity;
import elucent.eidolon.gui.SoulEnchanterContainer;
import elucent.eidolon.gui.WoodenBrewingStandContainer;
import elucent.eidolon.gui.WorktableContainer;
import elucent.eidolon.item.BonechillWandItem;
import elucent.eidolon.item.CleavingAxeItem;
import elucent.eidolon.item.CodexItem;
import elucent.eidolon.item.ItemBase;
import elucent.eidolon.item.ReaperScytheItem;
import elucent.eidolon.item.ReversalPickItem;
import elucent.eidolon.item.SappingSwordItem;
import elucent.eidolon.item.SoulfireWandItem;
import elucent.eidolon.item.TopHatItem;
import elucent.eidolon.item.UnholySymbolItem;
import elucent.eidolon.item.WarlockRobesItem;
import elucent.eidolon.item.curio.BasicAmuletItem;
import elucent.eidolon.item.curio.BasicBeltItem;
import elucent.eidolon.item.curio.BasicRingItem;
import elucent.eidolon.item.curio.GlassHandItem;
import elucent.eidolon.item.curio.GravityBeltItem;
import elucent.eidolon.item.curio.MindShieldingPlateItem;
import elucent.eidolon.item.curio.PrestigiousPalmItem;
import elucent.eidolon.item.curio.ResoluteBeltItem;
import elucent.eidolon.item.curio.SanguineAmuletItem;
import elucent.eidolon.item.curio.VoidAmuletItem;
import elucent.eidolon.item.curio.WardedMailItem;
import elucent.eidolon.mixin.PotionBrewingMixin;
import elucent.eidolon.particle.BubbleParticleType;
import elucent.eidolon.particle.FlameParticleType;
import elucent.eidolon.particle.LineWispParticleType;
import elucent.eidolon.particle.SignParticleType;
import elucent.eidolon.particle.SmokeParticleType;
import elucent.eidolon.particle.SparkleParticleType;
import elucent.eidolon.particle.SteamParticleType;
import elucent.eidolon.particle.WispParticleType;
import elucent.eidolon.potion.AnchoredEffect;
import elucent.eidolon.potion.ChilledEffect;
import elucent.eidolon.ritual.AllureRitual;
import elucent.eidolon.ritual.CrystalRitual;
import elucent.eidolon.ritual.DaylightRitual;
import elucent.eidolon.ritual.DeceitRitual;
import elucent.eidolon.ritual.MoonlightRitual;
import elucent.eidolon.ritual.PurifyRitual;
import elucent.eidolon.ritual.RepellingRitual;
import elucent.eidolon.ritual.SanguineRitual;
import elucent.eidolon.ritual.SummonRitual;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.spell.Signs;
import elucent.eidolon.tile.BrazierTileEntity;
import elucent.eidolon.tile.CrucibleTileEntity;
import elucent.eidolon.tile.EffigyTileEntity;
import elucent.eidolon.tile.GobletTileEntity;
import elucent.eidolon.tile.HandTileEntity;
import elucent.eidolon.tile.NecroticFocusTileEntity;
import elucent.eidolon.tile.SoulEnchanterTileEntity;
import elucent.eidolon.tile.SoulEnchanterTileRenderer;
import elucent.eidolon.tile.WoodenStandTileEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.item.Rarity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Registry {
    static Map<String, Block> BLOCK_MAP = new HashMap<String, Block>();
    static Map<String, Item> ITEM_MAP = new HashMap<String, Item>();
    static DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"eidolon");
    static DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"eidolon");
    static DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"eidolon");
    static DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"eidolon");
    static DeferredRegister<Effect> POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"eidolon");
    static DeferredRegister<Potion> POTION_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTION_TYPES, (String)"eidolon");
    static DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"eidolon");
    static DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"eidolon");
    public static RegistryObject<SoundEvent> CAST_SOULFIRE_EVENT = Registry.addSound("cast_soulfire");
    public static RegistryObject<SoundEvent> CAST_BONECHILL_EVENT = Registry.addSound("cast_bonechill");
    public static RegistryObject<SoundEvent> SPLASH_SOULFIRE_EVENT = Registry.addSound("splash_soulfire");
    public static RegistryObject<SoundEvent> SPLASH_BONECHILL_EVENT = Registry.addSound("splash_bonechill");
    public static RegistryObject<SoundEvent> SELECT_SIGN = Registry.addSound("select_sign");
    public static RegistryObject<SoundEvent> CHANT_WORD = Registry.addSound("chant_word");
    public static RegistryObject<SoundEvent> PAROUSIA = Registry.addSound("parousia");
    public static RegistryObject<Effect> CHILLED_EFFECT = POTIONS.register("chilled", () -> new ChilledEffect());
    public static RegistryObject<Effect> ANCHORED_EFFECT = POTIONS.register("anchored", () -> new AnchoredEffect());
    public static RegistryObject<Potion> CHILLED_POTION = POTION_TYPES.register("chilled", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)CHILLED_EFFECT.get(), 3600)}));
    public static RegistryObject<Potion> LONG_CHILLED_POTION = POTION_TYPES.register("long_chilled", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)CHILLED_EFFECT.get(), 9600)}));
    public static RegistryObject<Potion> ANCHORED_POTION = POTION_TYPES.register("anchored", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)ANCHORED_EFFECT.get(), 3600)}));
    public static RegistryObject<Potion> LONG_ANCHORED_POTION = POTION_TYPES.register("long_anchored", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)ANCHORED_EFFECT.get(), 9600)}));
    public static RegistryObject<Item> LEAD_INGOT = Registry.addItem("lead_ingot");
    public static RegistryObject<Item> LEAD_NUGGET = Registry.addItem("lead_nugget");
    public static RegistryObject<Item> PEWTER_BLEND = Registry.addItem("pewter_blend");
    public static RegistryObject<Item> PEWTER_INGOT = Registry.addItem("pewter_ingot");
    public static RegistryObject<Item> PEWTER_NUGGET = Registry.addItem("pewter_nugget");
    public static RegistryObject<Item> PEWTER_INLAY = Registry.addItem("pewter_inlay");
    public static RegistryObject<Item> ARCANE_GOLD_INGOT = Registry.addItem("arcane_gold_ingot");
    public static RegistryObject<Item> ARCANE_GOLD_NUGGET = Registry.addItem("arcane_gold_nugget");
    public static RegistryObject<Item> SULFUR = Registry.addItem("sulfur");
    public static RegistryObject<Item> GOLD_INLAY = Registry.addItem("gold_inlay");
    public static RegistryObject<Item> ZOMBIE_HEART = Registry.addItem("zombie_heart", new ItemBase(Registry.itemProps().func_208103_a(Rarity.UNCOMMON)).setLore("lore.eidolon.zombie_heart"));
    public static RegistryObject<Item> TATTERED_CLOTH = Registry.addItem("tattered_cloth");
    public static RegistryObject<Item> WRAITH_HEART = Registry.addItem("wraith_heart", new ItemBase(Registry.itemProps().func_208103_a(Rarity.UNCOMMON)).setLore("lore.eidolon.wraith_heart"));
    public static RegistryObject<Item> TOP_HAT = Registry.addItem("top_hat", new TopHatItem(Registry.itemProps().func_200917_a(1).func_208103_a(Rarity.EPIC)).setLore("lore.eidolon.top_hat"));
    public static RegistryObject<Item> BASIC_RING = Registry.addItem("basic_ring", new BasicRingItem(Registry.itemProps().func_200917_a(1)));
    public static RegistryObject<Item> BASIC_AMULET = Registry.addItem("basic_amulet", new BasicAmuletItem(Registry.itemProps().func_200917_a(1)));
    public static RegistryObject<Item> BASIC_BELT = Registry.addItem("basic_belt", new BasicBeltItem(Registry.itemProps().func_200917_a(1)));
    public static RegistryObject<Item> CODEX = Registry.addItem("codex", new CodexItem(Registry.itemProps().func_200917_a(1).func_208103_a(Rarity.UNCOMMON)).setLore("lore.eidolon.codex"));
    public static RegistryObject<Item> SOUL_SHARD = Registry.addItem("soul_shard");
    public static RegistryObject<Item> DEATH_ESSENCE = Registry.addItem("death_essence");
    public static RegistryObject<Item> CRIMSON_ESSENCE = Registry.addItem("crimson_essence");
    public static RegistryObject<Item> FUNGUS_SPROUTS = Registry.addItem("fungus_sprouts", Registry.itemProps().func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(0.1f).func_221453_d()));
    public static RegistryObject<Item> WARPED_SPROUTS = Registry.addItem("warped_sprouts", Registry.itemProps().func_221540_a(new Food.Builder().func_221456_a(4).func_221454_a(0.6f).effect(() -> new EffectInstance((Effect)ANCHORED_EFFECT.get(), 900), 1.0f).func_221453_d()));
    public static RegistryObject<Item> ENDER_CALX = Registry.addItem("ender_calx");
    public static RegistryObject<Item> TALLOW = Registry.addItem("tallow");
    public static RegistryObject<Item> LESSER_SOUL_GEM = Registry.addItem("lesser_soul_gem");
    public static RegistryObject<Item> UNHOLY_SYMBOL = Registry.addItem("unholy_symbol", new UnholySymbolItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)));
    public static RegistryObject<Item> REAPER_SCYTHE = Registry.addItem("reaper_scythe", new ReaperScytheItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON)).setLore("lore.eidolon.reaper_scythe"));
    public static RegistryObject<Item> CLEAVING_AXE = Registry.addItem("cleaving_axe", new CleavingAxeItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON)).setLore("lore.eidolon.cleaving_axe"));
    public static RegistryObject<Item> SHADOW_GEM = Registry.addItem("shadow_gem");
    public static RegistryObject<Item> WICKED_WEAVE = Registry.addItem("wicked_weave");
    public static RegistryObject<Item> WARLOCK_HAT = Registry.addItem("warlock_hat", (Item)new WarlockRobesItem(EquipmentSlotType.HEAD, Registry.itemProps()));
    public static RegistryObject<Item> WARLOCK_CLOAK = Registry.addItem("warlock_cloak", (Item)new WarlockRobesItem(EquipmentSlotType.CHEST, Registry.itemProps()));
    public static RegistryObject<Item> WARLOCK_BOOTS = Registry.addItem("warlock_boots", (Item)new WarlockRobesItem(EquipmentSlotType.FEET, Registry.itemProps()));
    public static RegistryObject<Item> REVERSAL_PICK = Registry.addItem("reversal_pick", (Item)new ReversalPickItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON)));
    public static RegistryObject<Item> VOID_AMULET = Registry.addItem("void_amulet", new VoidAmuletItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)).setLore("lore.eidolon.void_amulet"));
    public static RegistryObject<Item> WARDED_MAIL = Registry.addItem("warded_mail", new WardedMailItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)).setLore("lore.eidolon.warded_mail"));
    public static RegistryObject<Item> SAPPING_SWORD = Registry.addItem("sapping_sword", new SappingSwordItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)).setLore("lore.eidolon.sapping_sword"));
    public static RegistryObject<Item> SANGUINE_AMULET = Registry.addItem("sanguine_amulet", new SanguineAmuletItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)).setLore("lore.eidolon.sanguine_amulet"));
    public static RegistryObject<Item> SOULFIRE_WAND = Registry.addItem("soulfire_wand", new SoulfireWandItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1).func_200918_c(253).setNoRepair()).setLore("lore.eidolon.soulfire_wand"));
    public static RegistryObject<Item> BONECHILL_WAND = Registry.addItem("bonechill_wand", new BonechillWandItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1).func_200918_c(253).setNoRepair()).setLore("lore.eidolon.bonechill_wand"));
    public static RegistryObject<Item> GRAVITY_BELT = Registry.addItem("gravity_belt", new GravityBeltItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)).setLore("lore.eidolon.gravity_belt"));
    public static RegistryObject<Item> RESOLUTE_BELT = Registry.addItem("resolute_belt", new ResoluteBeltItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)).setLore("lore.eidolon.resolute_belt"));
    public static RegistryObject<Item> PRESTIGIOUS_PALM = Registry.addItem("prestigious_palm", new PrestigiousPalmItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)).setLore("lore.eidolon.prestigious_palm"));
    public static RegistryObject<Item> MIND_SHIELDING_PLATE = Registry.addItem("mind_shielding_plate", new MindShieldingPlateItem(Registry.itemProps().func_208103_a(Rarity.UNCOMMON).func_200917_a(1)).setLore("lore.eidolon.mind_shielding_plate"));
    public static RegistryObject<Item> GLASS_HAND = Registry.addItem("glass_hand", new GlassHandItem(Registry.itemProps().func_208103_a(Rarity.RARE).func_200917_a(1)).setLore("lore.eidolon.glass_hand"));
    public static RegistryObject<Item> PAROUSIA_DISC = Registry.addItem("music_disc_parousia", (Item)new MusicDiscItem(9, () -> (SoundEvent)PAROUSIA.get(), Registry.itemProps().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(Rarity.RARE)));
    public static RegistryObject<Block> LEAD_ORE = Registry.addBlock("lead_ore", Registry.blockProps(Material.field_151576_e, MaterialColor.field_151665_m).func_200947_a(SoundType.field_185851_d).func_200948_a(2.8f, 3.0f).harvestLevel(2).harvestTool(ToolType.PICKAXE));
    public static RegistryObject<Block> LEAD_BLOCK = Registry.addBlock("lead_block", Registry.blockProps(Material.field_151576_e, MaterialColor.field_193571_W).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 3.0f).harvestLevel(2).harvestTool(ToolType.PICKAXE));
    public static RegistryObject<Block> PEWTER_BLOCK = Registry.addBlock("pewter_block", Registry.blockProps(Material.field_151576_e, MaterialColor.field_197656_x).func_200947_a(SoundType.field_185852_e).func_200948_a(4.0f, 4.0f).harvestLevel(2).harvestTool(ToolType.PICKAXE));
    public static RegistryObject<Block> ARCANE_GOLD_BLOCK = Registry.addBlock("arcane_gold_block", Registry.blockProps(Material.field_151576_e, MaterialColor.field_151647_F).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 4.0f).harvestLevel(2).harvestTool(ToolType.PICKAXE));
    public static RegistryObject<Block> WOODEN_ALTAR = Registry.addBlock("wooden_altar", new TableBlockBase(Registry.blockProps(Material.field_151575_d, MaterialColor.field_151663_o).func_200947_a(SoundType.field_185848_a).func_200948_a(1.6f, 3.0f).harvestTool(ToolType.AXE)));
    public static RegistryObject<Block> STONE_ALTAR = Registry.addBlock("stone_altar", new TableBlockBase(Registry.blockProps(Material.field_151576_e, MaterialColor.field_151665_m).func_200947_a(SoundType.field_185851_d).func_200948_a(2.8f, 3.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).func_226896_b_()).setMainShape(VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.375, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.125, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375))));
    public static RegistryObject<Block> CANDLE = Registry.addBlock("candle", new CandleBlock(Registry.blockProps(Material.field_151594_q, MaterialColor.field_193561_M).func_200947_a(SoundType.field_185851_d).func_235838_a_(state -> 15).func_200948_a(0.6f, 0.8f).func_226896_b_()));
    public static RegistryObject<Block> CANDLESTICK = Registry.addBlock("candlestick", new CandlestickBlock(Registry.blockProps(Material.field_151573_f, MaterialColor.field_151647_F).func_200947_a(SoundType.field_185851_d).func_235838_a_(state -> 15).func_200948_a(1.2f, 2.0f).func_226896_b_()));
    public static RegistryObject<Block> STRAW_EFFIGY = Registry.addBlock("straw_effigy", new HorizontalWaterloggableBlock(Registry.blockProps(Material.field_151585_k, MaterialColor.field_151673_t).func_200947_a(SoundType.field_185848_a).func_200948_a(1.4f, 2.0f).func_226896_b_()).setShape(VoxelShapes.func_197873_a((double)0.28125, (double)0.0, (double)0.28125, (double)0.71875, (double)1.0, (double)0.71875)));
    public static RegistryObject<Block> GOBLET = Registry.addBlock("goblet", new BlockBase(Registry.blockProps(Material.field_151573_f, MaterialColor.field_151647_F).func_200947_a(SoundType.field_185852_e).func_200948_a(1.4f, 2.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).func_226896_b_()).setShape(VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.5, (double)0.6875)));
    public static RegistryObject<Block> UNHOLY_EFFIGY = Registry.addBlock("unholy_effigy", new HorizontalWaterloggableBlock(Registry.blockProps(Material.field_151576_e, MaterialColor.field_151665_m).func_200947_a(SoundType.field_185851_d).func_200948_a(2.8f, 3.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).func_226896_b_()).setShape(VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75)));
    public static RegistryObject<Block> WORKTABLE = Registry.addBlock("worktable", new WorktableBlock(Registry.blockProps(Material.field_151575_d, MaterialColor.field_151663_o).func_200947_a(SoundType.field_185848_a).func_200948_a(1.6f, 3.0f).harvestTool(ToolType.AXE).func_226896_b_()).setShape(VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0), (VoxelShape[])new VoxelShape[]{VoxelShapes.func_197873_a((double)0.125, (double)0.25, (double)0.125, (double)0.875, (double)0.625, (double)0.875), VoxelShapes.func_197873_a((double)0.0, (double)0.625, (double)0.0, (double)1.0, (double)1.0, (double)1.0)})));
    public static RegistryObject<Block> PLINTH = Registry.addBlock("plinth", new PlinthBlockBase(Registry.blockProps(Material.field_151576_e, MaterialColor.field_151665_m).func_200947_a(SoundType.field_185851_d).func_200948_a(2.0f, 3.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).func_226896_b_()).setShape(VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75)));
    public static RegistryObject<Block> BRAZIER = Registry.addBlock("brazier", new BlockBase(Registry.blockProps(Material.field_151575_d, MaterialColor.field_151668_h).func_200947_a(SoundType.field_185852_e).func_200948_a(2.5f, 3.0f).func_226896_b_()).setShape(VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.75, (double)0.8125)));
    public static RegistryObject<Block> CRUCIBLE = Registry.addBlock("crucible", new BlockBase(Registry.blockProps(Material.field_151573_f, MaterialColor.field_151668_h).func_200947_a(SoundType.field_185852_e).func_200948_a(4.0f, 3.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).func_226896_b_()).setShape(VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.875, (double)0.0625, (double)0.1875, (double)1.0, (double)0.9375), (VoxelShape[])new VoxelShape[]{VoxelShapes.func_197873_a((double)0.8125, (double)0.875, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375), VoxelShapes.func_197873_a((double)0.0625, (double)0.875, (double)0.0625, (double)0.9375, (double)1.0, (double)0.1875), VoxelShapes.func_197873_a((double)0.0625, (double)0.875, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375), VoxelShapes.func_197873_a((double)0.0, (double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0), VoxelShapes.func_197873_a((double)0.875, (double)0.125, (double)0.0, (double)1.0, (double)0.875, (double)1.0), VoxelShapes.func_197873_a((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)0.875, (double)0.125), VoxelShapes.func_197873_a((double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875, (double)1.0), VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375)})));
    public static RegistryObject<Block> STONE_HAND = Registry.addBlock("stone_hand", new HorizontalWaterloggableBlock(Registry.blockProps(Material.field_151576_e, MaterialColor.field_151665_m).func_200947_a(SoundType.field_185851_d).func_200948_a(2.0f, 3.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).func_226896_b_()).setShape(VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75)));
    public static RegistryObject<Block> ENCHANTED_ASH = Registry.addBlock("enchanted_ash", new EnchantedAshBlock(Registry.blockProps(Material.field_151594_q, MaterialColor.field_193561_M).func_200947_a(SoundType.field_185851_d).func_200948_a(0.0f, 0.75f).func_226896_b_()).setShape(VoxelShapes.func_197880_a()));
    public static RegistryObject<Block> NECROTIC_FOCUS = Registry.addBlock("necrotic_focus", new NecroticFocusBlock(Registry.blockProps(Material.field_151576_e, MaterialColor.field_151665_m).func_200947_a(SoundType.field_185851_d).func_200948_a(2.8f, 3.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).func_226896_b_()).setShape(VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75)));
    public static RegistryObject<Block> SOUL_ENCHANTER = Registry.addBlock("soul_enchanter", new SoulEnchanterBlock(Registry.blockProps(Material.field_151576_e, MaterialColor.field_151654_J).func_200947_a(SoundType.field_185851_d).func_200948_a(5.0f, 1200.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_226896_b_()).setShape(VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0)));
    public static RegistryObject<Block> WOODEN_STAND = Registry.addBlock("wooden_brewing_stand", (Block)new WoodenStandBlock(Registry.blockProps(Material.field_151573_f, MaterialColor.field_151663_o).func_200947_a(SoundType.field_185851_d).func_200948_a(2.0f, 3.0f).harvestTool(ToolType.PICKAXE).func_226896_b_()));
    public static DecoBlockPack SMOOTH_STONE_BRICK = new DecoBlockPack(BLOCKS, "smooth_stone_bricks", Registry.blockProps(Material.field_151576_e, MaterialColor.field_151665_m).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(2.0f, 3.0f)).addWall();
    public static DecoBlockPack SMOOTH_STONE_TILES = new DecoBlockPack(BLOCKS, "smooth_stone_tiles", Registry.blockProps(Material.field_151576_e, MaterialColor.field_151665_m).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(2.0f, 3.0f));
    public static DecoBlockPack POLISHED_PLANKS = new DecoBlockPack(BLOCKS, "polished_planks", Registry.blockProps(Material.field_151575_d, MaterialColor.field_151663_o).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).func_200948_a(1.6f, 3.0f)).addFence();
    public static RegistryObject<Block> POLISHED_WOOD_PILLAR = Registry.addBlock("polished_wood_pillar", (Block)new RotatedPillarBlock(Registry.blockProps(Material.field_151575_d, MaterialColor.field_151663_o).harvestTool(ToolType.AXE).func_200948_a(1.6f, 3.0f)));
    public static RegistryObject<EntityType<ZombieBruteEntity>> ZOMBIE_BRUTE = Registry.addEntity("zombie_brute", 7969893, 44975, 1.2f, 2.5f, ZombieBruteEntity::new, EntityClassification.MONSTER);
    public static RegistryObject<EntityType<WraithEntity>> WRAITH = Registry.addEntity("wraith", 7368299, 11381949, 0.6f, 1.9f, WraithEntity::new, EntityClassification.MONSTER);
    public static RegistryObject<EntityType<SoulfireProjectileEntity>> SOULFIRE_PROJECTILE = Registry.addEntity("soulfire_projectile", 0.4f, 0.4f, SoulfireProjectileEntity::new, EntityClassification.MISC);
    public static RegistryObject<EntityType<BonechillProjectileEntity>> BONECHILL_PROJECTILE = Registry.addEntity("bonechill_projectile", 0.4f, 0.4f, BonechillProjectileEntity::new, EntityClassification.MISC);
    public static RegistryObject<EntityType<NecromancerSpellEntity>> NECROMANCER_SPELL = Registry.addEntity("necromancer_spell", 0.4f, 0.4f, NecromancerSpellEntity::new, EntityClassification.MISC);
    public static RegistryObject<EntityType<ChantCasterEntity>> CHANT_CASTER = Registry.addEntity("chant_caster", 0.1f, 0.1f, ChantCasterEntity::new, EntityClassification.MISC);
    public static RegistryObject<EntityType<NecromancerEntity>> NECROMANCER = Registry.addEntity("necromancer", 6890846, 10283263, 0.6f, 1.9f, NecromancerEntity::new, EntityClassification.MONSTER);
    public static RegistryObject<ContainerType<WorktableContainer>> WORKTABLE_CONTAINER = Registry.addContainer("worktable", WorktableContainer::new);
    public static RegistryObject<ContainerType<SoulEnchanterContainer>> SOUL_ENCHANTER_CONTAINER = Registry.addContainer("soul_enchanter", SoulEnchanterContainer::new);
    public static RegistryObject<ContainerType<WoodenBrewingStandContainer>> WOODEN_STAND_CONTAINER = Registry.addContainer("wooden_brewing_stand", WoodenBrewingStandContainer::new);
    public static TileEntityType<HandTileEntity> HAND_TILE_ENTITY;
    public static TileEntityType<BrazierTileEntity> BRAZIER_TILE_ENTITY;
    public static TileEntityType<NecroticFocusTileEntity> NECROTIC_FOCUS_TILE_ENTITY;
    public static TileEntityType<CrucibleTileEntity> CRUCIBLE_TILE_ENTITY;
    public static TileEntityType<EffigyTileEntity> EFFIGY_TILE_ENTITY;
    public static TileEntityType<SoulEnchanterTileEntity> SOUL_ENCHANTER_TILE_ENTITY;
    public static TileEntityType<WoodenStandTileEntity> WOODEN_STAND_TILE_ENTITY;
    public static TileEntityType<GobletTileEntity> GOBLET_TILE_ENTITY;
    public static DamageSource RITUAL_DAMAGE;
    public static DamageSource FROST_DAMAGE;
    static DeferredRegister<ParticleType<?>> PARTICLES;
    public static RegistryObject<FlameParticleType> FLAME_PARTICLE;
    public static RegistryObject<SmokeParticleType> SMOKE_PARTICLE;
    public static RegistryObject<SparkleParticleType> SPARKLE_PARTICLE;
    public static RegistryObject<WispParticleType> WISP_PARTICLE;
    public static RegistryObject<BubbleParticleType> BUBBLE_PARTICLE;
    public static RegistryObject<LineWispParticleType> LINE_WISP_PARTICLE;
    public static RegistryObject<SteamParticleType> STEAM_PARTICLE;
    public static RegistryObject<SignParticleType> SIGN_PARTICLE;

    static Item.Properties itemProps() {
        return new Item.Properties().func_200916_a(Eidolon.TAB);
    }

    static AbstractBlock.Properties blockProps(Material mat, MaterialColor color) {
        return AbstractBlock.Properties.func_200949_a((Material)mat, (MaterialColor)color);
    }

    static RegistryObject<Item> addItem(String name) {
        Item i = new Item(Registry.itemProps());
        ITEM_MAP.put(name, i);
        return ITEMS.register(name, () -> i);
    }

    static RegistryObject<Item> addItem(String name, Item.Properties props) {
        Item i = new Item(props);
        ITEM_MAP.put(name, i);
        return ITEMS.register(name, () -> i);
    }

    static RegistryObject<Item> addItem(String name, Item item) {
        ITEM_MAP.put(name, item);
        return ITEMS.register(name, () -> item);
    }

    static RegistryObject<Block> addBlock(String name, AbstractBlock.Properties props) {
        Block b = new Block(props);
        BLOCK_MAP.put(name, b);
        ITEMS.register(name, () -> new BlockItem(b, Registry.itemProps()));
        return BLOCKS.register(name, () -> b);
    }

    static RegistryObject<Block> addBlock(String name, Block block) {
        BLOCK_MAP.put(name, block);
        ITEMS.register(name, () -> new BlockItem(block, Registry.itemProps()));
        return BLOCKS.register(name, () -> block);
    }

    static <T extends Entity> RegistryObject<EntityType<T>> addEntity(String name, float width, float height, EntityType.IFactory<T> factory, EntityClassification kind) {
        EntityType type = EntityType.Builder.func_220322_a(factory, (EntityClassification)kind).setTrackingRange(64).setUpdateInterval(1).func_220321_a(width, height).func_206830_a("eidolon:" + name);
        return ENTITIES.register(name, () -> type);
    }

    static <T extends Entity> RegistryObject<EntityType<T>> addEntity(String name, int color1, int color2, float width, float height, EntityType.IFactory<T> factory, EntityClassification kind) {
        EntityType type = EntityType.Builder.func_220322_a(factory, (EntityClassification)kind).setTrackingRange(64).setUpdateInterval(1).func_220321_a(width, height).func_206830_a("eidolon:" + name);
        ITEMS.register("spawn_" + name, () -> new SpawnEggItem(type, color1, color2, Registry.itemProps().func_200916_a(ItemGroup.field_78026_f)));
        return ENTITIES.register(name, () -> type);
    }

    static RegistryObject<SoundEvent> addSound(String name) {
        SoundEvent event = new SoundEvent(new ResourceLocation("eidolon", name));
        return SOUND_EVENTS.register(name, () -> event);
    }

    static <T extends Container> RegistryObject<ContainerType<T>> addContainer(String name, ContainerType.IFactory<T> factory) {
        return CONTAINERS.register(name, () -> new ContainerType(factory));
    }

    static <T extends TileEntity> TileEntityType<T> addTileEntity(IForgeRegistry<TileEntityType<?>> registry, String name, Supplier<T> factory, Block ... blocks) {
        TileEntityType type = TileEntityType.Builder.func_223042_a(factory, (Block[])blocks).func_206865_a(null);
        type.setRegistryName("eidolon", name);
        registry.register((IForgeRegistryEntry)type);
        for (Block block : blocks) {
            if (!(block instanceof BlockBase)) continue;
            ((BlockBase)block).setTile((TileEntityType<? extends TileEntity>)type);
        }
        return type;
    }

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        POTIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
        POTION_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
        SOUND_EVENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void addBrewingRecipes() {
        System.out.println("calling addBrewingRecipes");
        PotionBrewingMixin.callAddMix(Potions.field_185230_b, (Item)FUNGUS_SPROUTS.get(), Potions.field_185233_e);
        PotionBrewingMixin.callAddMix(Potions.field_185233_e, (Item)WRAITH_HEART.get(), (Potion)CHILLED_POTION.get());
        PotionBrewingMixin.callAddMix((Potion)CHILLED_POTION.get(), Items.field_151137_ax, (Potion)LONG_CHILLED_POTION.get());
        PotionBrewingMixin.callAddMix(Potions.field_185233_e, (Item)WARPED_SPROUTS.get(), (Potion)ANCHORED_POTION.get());
        PotionBrewingMixin.callAddMix((Potion)ANCHORED_POTION.get(), Items.field_151137_ax, (Potion)LONG_ANCHORED_POTION.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
    }

    @SubscribeEvent
    public void registerTiles(RegistryEvent.Register<TileEntityType<?>> evt) {
        HAND_TILE_ENTITY = Registry.addTileEntity(evt.getRegistry(), "hand_tile", HandTileEntity::new, (Block)STONE_HAND.get());
        BRAZIER_TILE_ENTITY = Registry.addTileEntity(evt.getRegistry(), "brazier_tile", BrazierTileEntity::new, (Block)BRAZIER.get());
        NECROTIC_FOCUS_TILE_ENTITY = Registry.addTileEntity(evt.getRegistry(), "necrotic_focus", NecroticFocusTileEntity::new, (Block)NECROTIC_FOCUS.get());
        CRUCIBLE_TILE_ENTITY = Registry.addTileEntity(evt.getRegistry(), "crucible", CrucibleTileEntity::new, (Block)CRUCIBLE.get());
        EFFIGY_TILE_ENTITY = Registry.addTileEntity(evt.getRegistry(), "effigy", EffigyTileEntity::new, (Block)STRAW_EFFIGY.get(), (Block)UNHOLY_EFFIGY.get());
        SOUL_ENCHANTER_TILE_ENTITY = Registry.addTileEntity(evt.getRegistry(), "soul_enchanter", SoulEnchanterTileEntity::new, (Block)SOUL_ENCHANTER.get());
        WOODEN_STAND_TILE_ENTITY = Registry.addTileEntity(evt.getRegistry(), "wooden_brewing_stand", WoodenStandTileEntity::new, (Block)WOODEN_STAND.get());
        GOBLET_TILE_ENTITY = Registry.addTileEntity(evt.getRegistry(), "goblet", GobletTileEntity::new, (Block)GOBLET.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void registerFactories(ParticleFactoryRegisterEvent evt) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)FLAME_PARTICLE.get(), FlameParticleType.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)SMOKE_PARTICLE.get(), SmokeParticleType.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)SPARKLE_PARTICLE.get(), SparkleParticleType.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)WISP_PARTICLE.get(), WispParticleType.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)BUBBLE_PARTICLE.get(), BubbleParticleType.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)STEAM_PARTICLE.get(), SteamParticleType.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)LINE_WISP_PARTICLE.get(), LineWispParticleType.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)SIGN_PARTICLE.get(), sprite -> new SignParticleType.Factory());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        event.addSprite(CrystalRitual.SYMBOL);
        event.addSprite(SummonRitual.SYMBOL);
        event.addSprite(DeceitRitual.SYMBOL);
        event.addSprite(AllureRitual.SYMBOL);
        event.addSprite(DaylightRitual.SYMBOL);
        event.addSprite(MoonlightRitual.SYMBOL);
        event.addSprite(PurifyRitual.SYMBOL);
        event.addSprite(RepellingRitual.SYMBOL);
        event.addSprite(SanguineRitual.SYMBOL);
        event.addSprite(SoulEnchanterTileRenderer.BOOK_TEXTURE);
        for (Sign s : Signs.getSigns()) {
            event.addSprite(s.getSprite());
        }
    }

    static {
        RITUAL_DAMAGE = new DamageSource("ritual").func_76348_h().func_151518_m();
        FROST_DAMAGE = new DamageSource("frost");
        PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"eidolon");
        FLAME_PARTICLE = PARTICLES.register("flame_particle", FlameParticleType::new);
        SMOKE_PARTICLE = PARTICLES.register("smoke_particle", SmokeParticleType::new);
        SPARKLE_PARTICLE = PARTICLES.register("sparkle_particle", SparkleParticleType::new);
        WISP_PARTICLE = PARTICLES.register("wisp_particle", WispParticleType::new);
        BUBBLE_PARTICLE = PARTICLES.register("bubble_particle", BubbleParticleType::new);
        LINE_WISP_PARTICLE = PARTICLES.register("line_wisp_particle", LineWispParticleType::new);
        STEAM_PARTICLE = PARTICLES.register("steam_particle", SteamParticleType::new);
        SIGN_PARTICLE = PARTICLES.register("sign_particle", SignParticleType::new);
    }

    public static class DecoBlockPack {
        DeferredRegister<Block> registry;
        String basename;
        AbstractBlock.Properties props;
        RegistryObject<Block> full = null;
        RegistryObject<Block> slab = null;
        RegistryObject<Block> stair = null;
        RegistryObject<Block> wall = null;
        RegistryObject<Block> fence = null;
        RegistryObject<Block> fence_gate = null;

        public DecoBlockPack(DeferredRegister<Block> blocks, String basename, AbstractBlock.Properties props) {
            this.registry = blocks;
            this.basename = basename;
            this.props = props;
            this.full = Registry.addBlock(basename, new Block(props));
            this.slab = Registry.addBlock(basename + "_slab", (Block)new SlabBlock(props));
            this.stair = Registry.addBlock(basename + "_stairs", (Block)new StairsBlock(() -> ((Block)this.full.get()).func_176223_P(), props));
        }

        public DecoBlockPack addWall() {
            this.wall = Registry.addBlock(this.basename + "_wall", (Block)new WallBlock(this.props));
            return this;
        }

        public DecoBlockPack addFence() {
            this.fence = Registry.addBlock(this.basename + "_fence", (Block)new FenceBlock(this.props));
            this.fence = Registry.addBlock(this.basename + "_fence_gate", (Block)new FenceGateBlock(this.props));
            return this;
        }

        public Block getBlock() {
            return (Block)this.full.get();
        }

        public Block getSlab() {
            return (Block)this.slab.get();
        }

        public Block getStairs() {
            return (Block)this.stair.get();
        }

        public Block getWall() {
            return (Block)this.wall.get();
        }

        public Block getFence() {
            return (Block)this.fence.get();
        }
    }
}

