/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.mixin.forge;

import java.lang.ref.WeakReference;
import me.shedaniel.architectury.event.forge.EventHandlerImplCommon;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public class MixinChunkSerializer {
    @Unique
    private static ThreadLocal<WeakReference<ServerWorld>> level = new ThreadLocal();

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private static void read(ServerWorld worldIn, TemplateManager templateManagerIn, PointOfInterestManager poiManager, ChunkPos pos, CompoundNBT compound, CallbackInfoReturnable<ChunkPrimer> cir) {
        level.set(new WeakReference<ServerWorld>(worldIn));
    }

    @ModifyArg(method={"read"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z"), index=0)
    private static Event modifyProtoChunkLevel(Event event) {
        WeakReference<ServerWorld> levelRef = level.get();
        if (levelRef != null && event instanceof ChunkDataEvent.Load) {
            ChunkDataEvent.Load load = (ChunkDataEvent.Load)event;
            ((EventHandlerImplCommon.WorldEventAttachment)load).architectury$attachLevel((IWorld)levelRef.get());
        }
        level.remove();
        return event;
    }
}

