/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.mixin;

import me.shedaniel.architectury.mixin.AbstractVillagerMixin;
import me.shedaniel.architectury.registry.trade.WanderingTraderOfferContext;
import me.shedaniel.architectury.registry.trade.impl.TradeRegistryData;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.item.MerchantOffer;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={WanderingTraderEntity.class})
public abstract class WanderingTraderMixin
extends AbstractVillagerMixin {
    @Unique
    private final ThreadLocal<VillagerTrades.ITrade> vanillaSelectedItemListing = new ThreadLocal();

    public WanderingTraderMixin(EntityType<?> entityType, World level) {
        super(entityType, level);
    }

    @ModifyVariable(method={"updateTrades()V"}, at=@At(value="INVOKE_ASSIGN"), ordinal=0)
    public VillagerTrades.ITrade storeItemListing(VillagerTrades.ITrade itemListing) {
        this.vanillaSelectedItemListing.set(itemListing);
        return itemListing;
    }

    @ModifyVariable(method={"updateTrades()V"}, at=@At(value="INVOKE_ASSIGN"), ordinal=0)
    public MerchantOffer handleSecondListingOffer(MerchantOffer offer) {
        if (offer == null) {
            return null;
        }
        return this.invokeWanderingTraderEvents(offer, true);
    }

    @Override
    public MerchantOffer architectury$handleOffer(MerchantOffer offer) {
        return this.invokeWanderingTraderEvents(offer, false);
    }

    @Nullable
    private MerchantOffer invokeWanderingTraderEvents(MerchantOffer offer, boolean rare) {
        WanderingTraderOfferContext context = new WanderingTraderOfferContext(offer, rare, this, this.field_70146_Z);
        boolean removeResult = TradeRegistryData.invokeWanderingTraderOfferRemoving(context);
        if (removeResult) {
            return null;
        }
        TradeRegistryData.invokeWanderingTraderOfferModify(context);
        return offer;
    }

    @Override
    @Nullable
    public Integer architectury$getMaxOfferOverride() {
        return TradeRegistryData.getWanderingTraderMaxOffers();
    }
}

