/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.google.common.collect.Sets;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public abstract class SpiderDungeonPiece
extends StructurePiece {
    protected static final Set<Block> BLOCK_BLACKLIST = Sets.newHashSet((Object[])new Block[]{Blocks.field_150484_ah, Blocks.field_196556_aL, Blocks.field_150474_ac, Blocks.field_150486_ae, Blocks.field_196572_aa, Blocks.field_196647_Y, Blocks.field_196642_W, Blocks.field_196574_ab, Blocks.field_196648_Z, Blocks.field_196645_X, Blocks.field_150349_c, Blocks.field_196804_gh});

    protected SpiderDungeonPiece(IStructurePieceType structurePieceTypeIn, int componentTypeIn) {
        super(structurePieceTypeIn, componentTypeIn);
    }

    public SpiderDungeonPiece(IStructurePieceType structurePierceTypeIn, CompoundNBT nbt) {
        super(structurePierceTypeIn, nbt);
    }

    protected void decorateCave(ISeedReader world, Random decoRand, ChunkPos chunkPos, MutableBoundingBox box, BitSet carvingMask) {
        carvingMask.stream().forEach(mask -> {
            int z;
            int globalZ;
            int y;
            int x;
            int globalX;
            if (decoRand.nextFloat() < 0.15f && (this.func_175807_a((IBlockReader)world, (globalX = (x = mask & 0xF) + chunkPos.field_77276_a * 16) - 1, y = mask >> 8 & 0xFF, globalZ = (z = mask >> 4 & 0xF) + chunkPos.field_77275_b * 16, box).func_200132_m() || this.func_175807_a((IBlockReader)world, globalX + 1, y, globalZ, box).func_200132_m() || this.func_175807_a((IBlockReader)world, globalX, y, globalZ - 1, box).func_200132_m() || this.func_175807_a((IBlockReader)world, globalX, y, globalZ + 1, box).func_200132_m() || this.func_175807_a((IBlockReader)world, globalX, y - 1, globalZ, box).func_200132_m() || this.func_175807_a((IBlockReader)world, globalX, y + 1, globalZ, box).func_200132_m()) && !BLOCK_BLACKLIST.contains(this.func_175807_a((IBlockReader)world, globalX, y, globalZ, box).func_177230_c())) {
                this.func_175811_a(world, Blocks.field_196553_aF.func_176223_P(), globalX, y, globalZ, box);
            }
        });
    }

    protected void placeSphereRandomized(ISeedReader world, MutableBoundingBox box, BlockPos center, float radius, Random rand, float chance, BlockSetSelector blockSelector, boolean replaceOnlyAir) {
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                for (float y = -radius; y <= radius; y += 1.0f) {
                    if (!(x * x + y * y + z * z < radius * radius) || replaceOnlyAir && !this.func_175807_a((IBlockReader)world, (int)x + center.func_177958_n(), (int)y + center.func_177956_o(), (int)z + center.func_177952_p(), box).func_196958_f() || !(rand.nextFloat() < chance)) continue;
                    this.func_175811_a(world, blockSelector.get(rand), (int)x + center.func_177958_n(), (int)y + center.func_177956_o(), (int)z + center.func_177952_p(), box);
                }
            }
        }
    }

    protected void placeSphereRandomized(ISeedReader world, MutableBoundingBox box, int centerX, int centerY, int centerZ, float radius, Random rand, float chance, BlockSetSelector blockSelector, boolean replaceOnlyAir) {
        this.placeSphereRandomized(world, box, new BlockPos(centerX, centerY, centerZ), radius, rand, chance, blockSelector, replaceOnlyAir);
    }

    protected void setBlockState(ISeedReader worldIn, Random random, BlockSetSelector selector, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        BlockState blockState = selector.get(random);
        this.func_175811_a(worldIn, blockState, x, y, z, boundingboxIn);
    }
}

