/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import quek.undergarden.entity.MinionEntity;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;

public class CarvedGloomgourdBlock
extends CarvedPumpkinBlock {
    @Nullable
    private BlockPattern minionBasePattern;
    @Nullable
    private BlockPattern minionPattern;

    public CarvedGloomgourdBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    private BlockPattern getMinionBasePattern() {
        if (this.minionBasePattern == null) {
            this.minionBasePattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{" ", "#"}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)UGBlocks.FORGOTTEN_BLOCK.get())))).func_177661_b();
        }
        return this.minionBasePattern;
    }

    private BlockPattern getMinionPattern() {
        if (this.minionPattern == null) {
            this.minionPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"^", "#"}).func_177662_a('^', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)UGBlocks.CARVED_GLOOMGOURD.get())))).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)UGBlocks.FORGOTTEN_BLOCK.get())))).func_177661_b();
        }
        return this.minionPattern;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.trySpawnMinion(worldIn, pos);
        }
    }

    public boolean func_196354_a(IWorldReader reader, BlockPos pos) {
        return this.getMinionBasePattern().func_177681_a(reader, pos) != null;
    }

    private void trySpawnMinion(World world, BlockPos pos) {
        BlockPattern.PatternHelper minionPattern = this.getMinionPattern().func_177681_a((IWorldReader)world, pos);
        if (minionPattern != null) {
            for (int i = 0; i < this.getMinionPattern().func_177685_b(); ++i) {
                CachedBlockInfo cachedblockinfo = minionPattern.func_177670_a(0, i, 0);
                world.func_180501_a(cachedblockinfo.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                world.func_217379_c(2001, cachedblockinfo.func_177508_d(), Block.func_196246_j((BlockState)cachedblockinfo.func_177509_a()));
            }
            MinionEntity minionEntity = (MinionEntity)((EntityType)UGEntityTypes.MINION.get()).func_200721_a(world);
            BlockPos blockpos1 = minionPattern.func_177670_a(0, 2, 0).func_177508_d();
            minionEntity.func_70012_b((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 1.0, (double)blockpos1.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_217376_c((Entity)minionEntity);
            for (ServerPlayerEntity serverplayerentity : world.func_217357_a(ServerPlayerEntity.class, minionEntity.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity, (Entity)minionEntity);
            }
            for (int l = 0; l < this.getMinionPattern().func_177685_b(); ++l) {
                CachedBlockInfo cachedblockinfo3 = minionPattern.func_177670_a(0, l, 0);
                world.func_230547_a_(cachedblockinfo3.func_177508_d(), Blocks.field_150350_a);
            }
        }
    }
}

