/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.DirectionalBlockPos;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.JSONUtils;

public final class DungeonModelFeature {
    private final Type type;
    private final Position[] positions;
    private final RandomValueRange amount;
    @Nullable
    private final DungeonModelFeature followup;

    private DungeonModelFeature(Type type, Position[] positions, RandomValueRange amount, @Nullable DungeonModelFeature followup) {
        this.type = type;
        this.positions = positions;
        this.amount = amount;
        this.followup = followup;
    }

    public void setup(DungeonModel model, int x, int y, int z, Rotation rotation, List<Instance> features, Random rand) {
        this.setup(model, x, y, z, rotation, features, Lists.newArrayList((Object[])this.positions), rand);
    }

    private void setup(DungeonModel model, int x, int y, int z, Rotation rotation, List<Instance> features, List<Position> positions, Random rand) {
        if (positions.isEmpty()) {
            return;
        }
        int count = this.amount.func_186511_a(rand);
        if (count >= positions.size()) {
            features.add(new Instance(this.type, (DirectionalBlockPos[])positions.stream().map(pos -> pos.worldPos(x, y, z, rotation, model)).toArray(DirectionalBlockPos[]::new)));
        } else {
            DirectionalBlockPos[] resultingPositions = new DirectionalBlockPos[count];
            for (int i = 0; i < count; ++i) {
                Position pos2 = positions.get(rand.nextInt(positions.size()));
                DirectionalBlockPos position = pos2.worldPos(x, y, z, rotation, model);
                positions.remove(pos2);
                resultingPositions[i] = position;
            }
            features.add(new Instance(this.type, resultingPositions));
        }
        if (this.followup != null && !positions.isEmpty()) {
            this.followup.setup(model, x, y, z, rotation, features, positions, rand);
        }
    }

    private static void placeChest(IWorld world, BlockPos pos, BlockState chest, Theme theme, SecondaryTheme secondaryTheme, int lootLevel, Random rand) {
        world.func_180501_a(pos, chest, 2);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof LockableLootTileEntity) {
            Loot.setLoot(world, pos, (LockableLootTileEntity)tileEntity, Loot.getLootTable(lootLevel, rand), theme, secondaryTheme, rand);
        }
    }

    public static DungeonModelFeature fromJson(JsonObject object, ResourceLocation file) {
        return DungeonModelFeature.fromJson(object, file, null);
    }

    private static DungeonModelFeature fromJson(JsonObject object, ResourceLocation file, Position[] positions) {
        String type = object.get("type").getAsString();
        if (!Type.TYPES.containsKey((Object)type)) {
            throw new DatapackLoadException("Unknown feature type " + type + " in " + file);
        }
        if (positions == null) {
            JsonArray positionsArray = object.getAsJsonArray("positions");
            positions = new Position[positionsArray.size()];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = Position.fromJson(positionsArray.get(i).getAsJsonObject());
            }
        }
        JsonObject jsonAmount = object.getAsJsonObject("amount");
        RandomValueRange amount = new RandomValueRange((float)jsonAmount.get("min").getAsInt(), (float)jsonAmount.get("max").getAsInt());
        DungeonModelFeature followUp = null;
        if (object.has("follow_up")) {
            followUp = DungeonModelFeature.fromJson(object.getAsJsonObject("follow_up"), file, positions);
        }
        return new DungeonModelFeature((Type)Type.TYPES.get((Object)type), positions, amount, followUp);
    }

    private static class Position {
        public final Vector3i position;
        public final Direction facing;

        private Position(Vector3i position, Direction facing) {
            this.position = position;
            this.facing = facing;
        }

        public static Position fromJson(JsonObject object) {
            Vector3i position = JSONUtils.getOffset(object);
            Direction facing = object.has("facing") ? Direction.valueOf((String)object.get("facing").getAsString().toUpperCase(Locale.ROOT)) : Direction.NORTH;
            return new Position(position, facing);
        }

        public DirectionalBlockPos worldPos(int x, int y, int z, Rotation rotation, DungeonModel model) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    return new DirectionalBlockPos(x + model.length - this.position.func_177952_p() - 1, y + this.position.func_177956_o(), z + this.position.func_177958_n(), this.facing.func_176740_k() != Direction.Axis.Y ? this.facing.func_176746_e() : this.facing);
                }
                case CLOCKWISE_180: {
                    return new DirectionalBlockPos(x + model.width - this.position.func_177958_n() - 1, y + this.position.func_177956_o(), z + model.length - this.position.func_177952_p() - 1, this.facing.func_176740_k() != Direction.Axis.Y ? this.facing.func_176734_d() : this.facing);
                }
                case COUNTERCLOCKWISE_90: {
                    return new DirectionalBlockPos(x + this.position.func_177952_p(), y + this.position.func_177956_o(), z + model.width - this.position.func_177958_n() - 1, this.facing.func_176740_k() != Direction.Axis.Y ? this.facing.func_176735_f() : this.facing);
                }
            }
            return new DirectionalBlockPos(x + this.position.func_177958_n(), y + this.position.func_177956_o(), z + this.position.func_177952_p(), this.facing);
        }
    }

    private static interface Type {
        public static final Type CHEST = new Type(){

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.func_175898_b((Vector3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.func_180495_p(pos.func_177977_b()).func_200132_m()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction), theme, secondaryTheme, stage, rand);
                }
            }

            @Override
            public String getName() {
                return "chest";
            }
        };
        public static final Type TNT_CHEST = new Type(){

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.func_175898_b((Vector3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.func_180495_p(pos.func_177977_b()).func_200132_m()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction), theme, secondaryTheme, stage, rand);
                    BlockPos down = pos.func_177979_c(2);
                    if (!DungeonBuilder.isBlockProtected(world, down) && !world.func_175623_d(down)) {
                        world.func_180501_a(pos.func_177979_c(2), Blocks.field_150335_W.func_176223_P(), 2);
                    }
                }
            }

            @Override
            public String getName() {
                return "tnt_chest";
            }
        };
        public static final Type SPAWNER = new Type(){

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.func_175898_b((Vector3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.func_180495_p(pos.func_177977_b()).func_200132_m()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, pos, rand, theme, secondaryTheme, stage, worldGen);
                }
            }

            @Override
            public String getName() {
                return "spawner";
            }
        };
        public static final Type CEILING_SPAWNER = new Type(){

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.func_175898_b((Vector3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.func_180495_p(pos.func_177984_a()).func_200132_m()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, pos, rand, theme, secondaryTheme, stage, worldGen);
                }
            }

            @Override
            public String getName() {
                return "ceiling_spawner";
            }
        };
        public static final Type SPAWNER_GRAVE = new Type(){

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                BlockPos p;
                BlockPos spawner;
                if (bounds.func_175898_b((Vector3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.func_180495_p(pos.func_177977_b()).func_200132_m()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction), theme, secondaryTheme, stage, rand);
                }
                if (bounds.func_175898_b((Vector3i)(spawner = pos.func_177972_a(direction))) && !DungeonBuilder.isBlockProtected(world, spawner) && world.func_180495_p(spawner.func_177977_b()).func_200132_m()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, spawner, rand, theme, secondaryTheme, stage, worldGen);
                }
                if (bounds.func_175898_b((Vector3i)(p = pos.func_177967_a(direction, 2))) && world.func_180495_p(p.func_177977_b()).func_200132_m()) {
                    world.func_180501_a(p, Blocks.field_150371_ca.func_176223_P(), 2);
                }
            }

            @Override
            public String getName() {
                return "spawner_grave";
            }
        };
        public static final Type EMPTY_GRAVE = new Type(){

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                BlockPos position = pos.func_177967_a(direction, 2);
                if (bounds.func_175898_b((Vector3i)position) && world.func_180495_p(position.func_177977_b()).func_200132_m()) {
                    world.func_180501_a(position, Blocks.field_150371_ca.func_176223_P(), 2);
                }
            }

            @Override
            public String getName() {
                return "empty_grave";
            }
        };
        public static final Type STAIRS = new Type(){

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (direction.func_176740_k() == Direction.Axis.Y) {
                    return;
                }
                Heightmap.Type heightMap = worldGen ? Heightmap.Type.WORLD_SURFACE_WG : Heightmap.Type.WORLD_SURFACE;
                for (int length = 0; length < 10; ++length) {
                    if (!bounds.func_175898_b((Vector3i)pos)) continue;
                    int height = world.func_205770_a(heightMap, pos).func_177956_o();
                    if (height >= pos.func_177956_o()) break;
                    while (height < pos.func_177956_o()) {
                        BlockPos p = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
                        world.func_180501_a(p, theme.solid.get(world, p), 2);
                        ++height;
                    }
                    world.func_180501_a(pos, (BlockState)theme.solidStairs.get(world, pos).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction.func_176734_d()), 2);
                    pos = pos.func_177972_a(direction).func_177972_a(Direction.DOWN);
                }
            }

            @Override
            public String getName() {
                return "stairs";
            }
        };
        public static final Type SEWER_HOLE = new Type(){
            private final BlockStateProvider AIR_WATER = new BlockStateProvider(){

                @Override
                public BlockState get(IWorld world, BlockPos pos, Rotation rotation) {
                    if (pos.func_177956_o() > 8) {
                        return Blocks.field_201941_jj.func_176223_P();
                    }
                    return Blocks.field_150355_j.func_176223_P();
                }

                @Override
                public JsonObject serialize() {
                    return null;
                }
            };
            private final BlockStateProvider AIR_LAVA = new BlockStateProvider(){

                @Override
                public BlockState get(IWorld world, BlockPos pos, Rotation rotation) {
                    if (pos.func_177956_o() > 8) {
                        return Blocks.field_201941_jj.func_176223_P();
                    }
                    return Blocks.field_150353_l.func_176223_P();
                }

                @Override
                public JsonObject serialize() {
                    return null;
                }
            };

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                BlockStateProvider inner = stage < 4 ? this.AIR_WATER : this.AIR_LAVA;
                this.buildDown(world, pos, bounds, inner);
                BlockPos east = pos.func_177974_f();
                this.buildDown(world, east, bounds, inner);
                BlockPos west = pos.func_177976_e();
                this.buildDown(world, west, bounds, inner);
                BlockPos north = pos.func_177978_c();
                this.buildDown(world, north, bounds, inner);
                BlockPos south = pos.func_177968_d();
                this.buildDown(world, pos.func_177968_d(), bounds, inner);
                this.buildDown(world, east.func_177978_c(), bounds, inner);
                this.buildDown(world, east.func_177968_d(), bounds, inner);
                this.buildDown(world, west.func_177978_c(), bounds, inner);
                this.buildDown(world, west.func_177968_d(), bounds, inner);
                this.buildDown(world, east.func_177982_a(1, -1, 0), bounds, theme.generic);
                this.buildDown(world, east.func_177982_a(1, -1, -1), bounds, theme.generic);
                this.buildDown(world, east.func_177982_a(1, -1, 1), bounds, theme.generic);
                this.buildDown(world, south.func_177982_a(0, -1, 1), bounds, theme.generic);
                this.buildDown(world, south.func_177982_a(1, -1, 1), bounds, theme.generic);
                this.buildDown(world, south.func_177982_a(-1, -1, 1), bounds, theme.generic);
                this.buildDown(world, west.func_177982_a(-1, -1, 0), bounds, theme.generic);
                this.buildDown(world, west.func_177982_a(-1, -1, -1), bounds, theme.generic);
                this.buildDown(world, west.func_177982_a(-1, -1, 1), bounds, theme.generic);
                this.buildDown(world, north.func_177982_a(0, -1, -1), bounds, theme.generic);
                this.buildDown(world, north.func_177982_a(1, -1, -1), bounds, theme.generic);
                this.buildDown(world, north.func_177982_a(-1, -1, -1), bounds, theme.generic);
            }

            @Override
            public String getName() {
                return "sewer_hole";
            }

            private void buildDown(IWorld world, BlockPos pos, MutableBoundingBox bounds, BlockStateProvider blockStateProvider) {
                if (!bounds.func_175898_b((Vector3i)pos)) {
                    return;
                }
                while (pos.func_177956_o() > 0) {
                    if (!DungeonBuilder.isBlockProtected(world, pos) && !world.func_175623_d(pos)) {
                        world.func_180501_a(pos, blockStateProvider.get(world, pos), 2);
                        FluidState state = world.func_204610_c(pos);
                        if (!state.func_206888_e()) {
                            world.func_205219_F_().func_205360_a(pos, (Object)state.func_206886_c(), 0);
                        }
                    }
                    pos = pos.func_177977_b();
                }
            }
        };
        public static final Type CROPS = new Type(){

            @Override
            public void place(IWorld world, Random rand, BlockPos pos, Direction direction, MutableBoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
                if (bounds.func_175898_b((Vector3i)pos) && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof FarmlandBlock) {
                    BlockState crop = ((Block)BlockTags.field_226152_ab_.func_205596_a(rand)).func_176223_P();
                    if (crop.func_235901_b_((Property)BlockStateProperties.field_208170_W)) {
                        crop = (BlockState)crop.func_206870_a((Property)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(4 + rand.nextInt(4)));
                    }
                    world.func_180501_a(pos, crop, 2);
                }
            }

            @Override
            public String getName() {
                return "crops";
            }
        };
        public static final ImmutableMap<String, Type> TYPES = new ImmutableMap.Builder().put((Object)CHEST.getName(), (Object)CHEST).put((Object)TNT_CHEST.getName(), (Object)TNT_CHEST).put((Object)SPAWNER_GRAVE.getName(), (Object)SPAWNER_GRAVE).put((Object)EMPTY_GRAVE.getName(), (Object)EMPTY_GRAVE).put((Object)SPAWNER.getName(), (Object)SPAWNER).put((Object)CEILING_SPAWNER.getName(), (Object)CEILING_SPAWNER).put((Object)STAIRS.getName(), (Object)STAIRS).put((Object)SEWER_HOLE.getName(), (Object)SEWER_HOLE).put((Object)CROPS.getName(), (Object)CROPS).build();

        public void place(IWorld var1, Random var2, BlockPos var3, Direction var4, MutableBoundingBox var5, Theme var6, SecondaryTheme var7, int var8, boolean var9);

        public String getName();
    }

    public static class Instance {
        private final Type type;
        private final DirectionalBlockPos[] positions;

        private Instance(Type type, DirectionalBlockPos[] positions) {
            this.type = type;
            this.positions = positions;
        }

        public void place(IWorld world, MutableBoundingBox worldGenBounds, Random rand, Theme theme, SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
            for (DirectionalBlockPos pos : this.positions) {
                this.type.place(world, rand, pos.position, pos.direction, worldGenBounds, theme, secondaryTheme, stage, worldGen);
            }
        }

        public static Instance read(CompoundNBT nbt) {
            Type type = (Type)Type.TYPES.get((Object)nbt.func_74779_i("type"));
            ListNBT nbtPositions = nbt.func_150295_c("positions", 10);
            DirectionalBlockPos[] positions = new DirectionalBlockPos[nbtPositions.size()];
            for (int i = 0; i < nbtPositions.size(); ++i) {
                positions[i] = DirectionalBlockPos.fromNBT(nbtPositions.func_150305_b(i));
            }
            return new Instance(type, positions);
        }

        public void write(CompoundNBT nbt) {
            nbt.func_74778_a("type", this.type.getName());
            ListNBT positions = new ListNBT();
            for (DirectionalBlockPos position : this.positions) {
                CompoundNBT pos = new CompoundNBT();
                position.writeToNBT(pos);
                positions.add((Object)pos);
            }
            nbt.func_218657_a("positions", (INBT)positions);
        }
    }
}

