/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.GuardItems;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.GuardEntity;

public class RangedCrossbowAttackPassiveGoal<T extends CreatureEntity & ICrossbowUser>
extends Goal {
    private final T entity;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speed;
    private final float distanceMoveToEntity;
    private int seeTicks;
    private int timeUntilStrike;

    public RangedCrossbowAttackPassiveGoal(T entity, double p_i50322_2_, float p_i50322_4_) {
        this.entity = entity;
        this.speed = p_i50322_2_;
        this.distanceMoveToEntity = p_i50322_4_ * p_i50322_4_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        return this.hasAttackTarget() && this.isHoldingCrossbow() && !((GuardEntity)((Object)this.entity)).isEating();
    }

    private boolean isHoldingCrossbow() {
        return this.entity.func_184614_ca().func_77973_b() instanceof CrossbowItem;
    }

    public boolean func_75253_b() {
        return this.hasAttackTarget() && (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.isHoldingCrossbow();
    }

    private boolean hasAttackTarget() {
        return this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.func_213395_q(false);
        this.entity.func_70624_b((LivingEntity)null);
        ((GuardEntity)((Object)this.entity)).setKicking(false);
        this.seeTicks = 0;
        if (this.entity.func_213283_Z() == Pose.CROUCHING) {
            this.entity.func_213301_b(Pose.STANDING);
        }
        if (this.entity.func_184587_cr()) {
            this.entity.func_184602_cy();
            ((ICrossbowUser)this.entity).func_213671_a(false);
        }
    }

    public boolean checkFriendlyFire() {
        List list = ((CreatureEntity)this.entity).field_70170_p.func_217357_a(LivingEntity.class, this.entity.func_174813_aQ().func_72314_b(4.0, 1.0, 4.0));
        for (LivingEntity guard : list) {
            boolean isVillager;
            if (this.entity == guard && guard == this.entity || guard == this.entity.func_70638_az() || !(isVillager = guard.func_200600_R() == EntityType.field_200756_av || guard.func_200600_R() == GuardEntityType.GUARD.get() || guard.func_200600_R() == EntityType.field_200757_aw)) continue;
            Vector3d vector3d = this.entity.func_70040_Z();
            Vector3d vector3d1 = guard.func_213303_ch().func_72444_a(this.entity.func_213303_ch()).func_72432_b();
            vector3d1 = new Vector3d(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c);
            if (!(vector3d1.func_72430_b(vector3d) < 0.0) || !this.entity.func_70685_l((Entity)guard)) continue;
            return GuardConfig.FriendlyFire;
        }
        return false;
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.entity.func_70638_az();
        if (livingentity != null) {
            double d0;
            boolean flag2;
            double d1;
            boolean flag1;
            this.entity.func_213395_q(true);
            boolean flag = this.entity.func_70635_at().func_75522_a((Entity)livingentity);
            boolean bl = flag1 = this.seeTicks > 0;
            if (flag != flag1) {
                this.seeTicks = 0;
            }
            this.seeTicks = flag ? ++this.seeTicks : --this.seeTicks;
            if (this.entity.func_213283_Z() == Pose.STANDING && ((CreatureEntity)this.entity).field_70170_p.field_73012_v.nextInt(4) == 0 && ((CreatureEntity)this.entity).field_70173_aa % 50 == 0) {
                this.entity.func_213301_b(Pose.CROUCHING);
            }
            if (this.entity.func_213283_Z() == Pose.CROUCHING && ((CreatureEntity)this.entity).field_70170_p.field_73012_v.nextInt(4) == 0 && ((CreatureEntity)this.entity).field_70173_aa % 100 == 0) {
                this.entity.func_213301_b(Pose.STANDING);
            }
            if ((d1 = (double)livingentity.func_70032_d(this.entity)) <= 2.0) {
                this.entity.func_70605_aq().func_188488_a(this.entity.func_184587_cr() ? -0.5f : -3.0f, 0.0f);
                this.entity.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
            }
            boolean bl2 = flag2 = ((d0 = this.entity.func_70068_e((Entity)livingentity)) > (double)this.distanceMoveToEntity || this.seeTicks < 5) && this.timeUntilStrike == 0;
            if (flag2) {
                this.entity.func_70661_as().func_75497_a((Entity)livingentity, this.isCrossbowUncharged() ? this.speed : this.speed * 0.5);
            } else {
                this.entity.func_70661_as().func_75499_g();
            }
            this.entity.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
            this.entity.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED && !CrossbowItem.func_220012_d((ItemStack)this.entity.func_184607_cu()) && !this.entity.func_184585_cz()) {
                if (flag) {
                    this.entity.func_184598_c(GuardItems.getHandWith(this.entity, (Predicate<Item>)((Predicate)item -> item instanceof CrossbowItem)));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((ICrossbowUser)this.entity).func_213671_a(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.entity.func_184587_cr()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.entity.func_184612_cw()) >= CrossbowItem.func_220026_e((ItemStack)(itemstack = this.entity.func_184607_cu())) || CrossbowItem.func_220012_d((ItemStack)this.entity.func_184607_cu())) {
                    this.entity.func_184597_cx();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.timeUntilStrike = 20 + this.entity.func_70681_au().nextInt(20);
                    ((ICrossbowUser)this.entity).func_213671_a(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.timeUntilStrike;
                if (this.timeUntilStrike == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag && !this.checkFriendlyFire() && !this.entity.func_184585_cz()) {
                ((IRangedAttackMob)this.entity).func_82196_d(livingentity, 1.0f);
                ItemStack itemstack1 = this.entity.func_184586_b(GuardItems.getHandWith(this.entity, (Predicate<Item>)((Predicate)item -> item instanceof CrossbowItem)));
                CrossbowItem.func_220011_a((ItemStack)itemstack1, (boolean)false);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean isCrossbowUncharged() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

