/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.containers.MinecartUnLoaderContainer;
import com.alc.moreminecarts.entities.ChunkLoaderCartEntity;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import java.util.List;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MinecartUnloaderTile
extends AbstractCommonLoader
implements ITickableTileEntity {
    public MinecartUnloaderTile() {
        super(MMReferences.minecart_unloader_te);
        this.last_redstone_output = !this.redstone_output;
    }

    @Override
    public boolean getIsUnloader() {
        return true;
    }

    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        this.changed_flag = true;
        return new MinecartUnLoaderContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isOnCooldown()) {
                int new_comparator_output_value;
                List<AbstractMinecartEntity> minecarts = this.getLoadableMinecartsInRange();
                float criteria_total = 0.0f;
                for (AbstractMinecartEntity minecart : minecarts) {
                    LazyOptional tankCapability = minecart.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                    LazyOptional energyCapability = minecart.getCapability(CapabilityEnergy.ENERGY);
                    if (tankCapability.isPresent()) {
                        IFluidHandler fluid_handler = (IFluidHandler)tankCapability.orElse(null);
                        criteria_total += this.doFluidUnloads(fluid_handler);
                        continue;
                    }
                    if (energyCapability.isPresent()) {
                        IEnergyStorage energy_storage = (IEnergyStorage)energyCapability.orElse(null);
                        criteria_total += this.doElectricUnloads(energy_storage);
                        continue;
                    }
                    if (!(minecart instanceof ContainerMinecartEntity) || minecart instanceof ChunkLoaderCartEntity) continue;
                    criteria_total += this.doMinecartUnloads((ContainerMinecartEntity)minecart);
                }
                criteria_total = minecarts.size() == 0 ? 0.0f : (criteria_total /= (float)minecarts.size());
                if (this.comparator_output != AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
                    criteria_total = (float)Math.floor(criteria_total);
                }
                if ((new_comparator_output_value = (int)(criteria_total * 15.0f)) != this.comparator_output_value || this.last_redstone_output != this.redstone_output) {
                    this.comparator_output_value = new_comparator_output_value;
                    this.last_redstone_output = this.redstone_output;
                    this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
                    this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
                }
                if (this.changed_flag) {
                    this.func_70296_d();
                    this.changed_flag = false;
                }
            } else {
                this.decCooldown();
            }
        }
    }

    public float doFluidUnloads(IFluidHandler minecart_handler) {
        boolean changed = false;
        boolean all_empty = true;
        IFluidHandler our_fluid_handler = (IFluidHandler)this.fluid_handler.orElse(null);
        FluidStack our_fluid_stack = our_fluid_handler.getFluidInTank(0);
        float fluid_content_proportion = 0.0f;
        for (int i = 0; i < minecart_handler.getTanks(); ++i) {
            if (minecart_handler.getTankCapacity(i) > 0) {
                fluid_content_proportion += (float)minecart_handler.getFluidInTank(i).getAmount() / (float)minecart_handler.getTankCapacity(i);
            }
            boolean did_load = false;
            FluidStack take_stack = minecart_handler.getFluidInTank(i);
            if (take_stack.isEmpty() || this.leave_one_in_stack && take_stack.getAmount() == 1) continue;
            all_empty = false;
            if (our_fluid_stack.getAmount() == FLUID_CAPACITY) continue;
            if (our_fluid_handler.isFluidValid(i, take_stack)) {
                if (our_fluid_stack.isEmpty()) {
                    FluidStack new_stack = take_stack.copy();
                    int transfer_amount = Math.min(1000, new_stack.getAmount());
                    new_stack.setAmount(transfer_amount);
                    our_fluid_handler.fill(new_stack, IFluidHandler.FluidAction.EXECUTE);
                    take_stack.shrink(transfer_amount);
                    did_load = true;
                } else if (our_fluid_stack.isFluidEqual(take_stack)) {
                    int true_count = take_stack.getAmount() - (this.leave_one_in_stack ? 1 : 0);
                    int to_fill = our_fluid_handler.getTankCapacity(i) - our_fluid_stack.getAmount();
                    int transfer = Math.min(1000, Math.min(true_count, to_fill));
                    our_fluid_stack.grow(transfer);
                    minecart_handler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
                    boolean bl = did_load = transfer > 0;
                }
            }
            if (!did_load) continue;
            changed = true;
            break;
        }
        if (minecart_handler.getTanks() > 0) {
            fluid_content_proportion /= (float)minecart_handler.getTanks();
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            return all_empty ? 1.0f : 0.0f;
        }
        return fluid_content_proportion;
    }

    public float doElectricUnloads(IEnergyStorage minecart_handler) {
        boolean changed = false;
        IEnergyStorage our_handler = (IEnergyStorage)this.energy_handler.orElse(null);
        if (minecart_handler.canReceive()) {
            int true_count = minecart_handler.getEnergyStored() - (this.leave_one_in_stack ? 1 : 0);
            int to_fill = our_handler.getMaxEnergyStored() - our_handler.getEnergyStored();
            int transfer = Math.min(1000, Math.min(true_count, to_fill));
            our_handler.receiveEnergy(transfer, false);
            minecart_handler.extractEnergy(transfer, false);
            boolean bl = changed = transfer > 0;
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            return minecart_handler.getEnergyStored() <= (this.leave_one_in_stack ? 1 : 0) ? 1.0f : 0.0f;
        }
        return (float)minecart_handler.getEnergyStored() / (float)minecart_handler.getMaxEnergyStored();
    }

    public float doMinecartUnloads(ContainerMinecartEntity minecart) {
        boolean changed = false;
        boolean all_empty = true;
        block0: for (int i = 0; i < minecart.func_70302_i_(); ++i) {
            ItemStack stack = minecart.func_70301_a(i);
            if (stack.func_190926_b() || this.leave_one_in_stack && stack.func_190916_E() == 1) continue;
            all_empty = false;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                int true_count;
                ItemStack add_to_stack = this.func_70301_a(j);
                boolean did_load = false;
                if (add_to_stack.func_190926_b()) {
                    true_count = stack.func_190916_E() - (this.leave_one_in_stack ? 1 : 0);
                    ItemStack new_stack = stack.func_77946_l();
                    int transfer_amount = Math.min(8, true_count);
                    new_stack.func_190920_e(transfer_amount);
                    this.func_70299_a(j, new_stack);
                    stack.func_190918_g(transfer_amount);
                    did_load = true;
                } else if (MinecartUnloaderTile.canMergeItems(add_to_stack, stack)) {
                    true_count = stack.func_190916_E() - (this.leave_one_in_stack ? 1 : 0);
                    int to_fill = add_to_stack.func_77976_d() - add_to_stack.func_190916_E();
                    int transfer = Math.min(8, Math.min(true_count, to_fill));
                    stack.func_190918_g(transfer);
                    add_to_stack.func_190917_f(transfer);
                    boolean bl = did_load = transfer > 0;
                }
                if (!did_load) continue;
                changed = true;
                continue block0;
            }
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            return all_empty ? 1.0f : 0.0f;
        }
        if (minecart instanceof ChunkLoaderCartEntity && this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
            return (float)((ChunkLoaderCartEntity)minecart).getComparatorSignal() / 15.0f;
        }
        return (float)Container.func_94526_b((IInventory)minecart) / 15.0f;
    }

    protected ITextComponent func_213907_g() {
        return new StringTextComponent("Minecart Unloader");
    }
}

