/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.items;

import com.alc.moreminecarts.MMReferences;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;

public class HoloRemoteItem
extends Item {
    public Block regular_block = MMReferences.holo_scaffold;
    public Block chaotic_block = MMReferences.chaotic_holo_scaffold;
    public HoloRemoteType remote_type;

    public HoloRemoteItem(HoloRemoteType remote_type, Item.Properties properties) {
        super(properties);
        this.remote_type = remote_type;
    }

    @Nullable
    public BlockItemUseContext updatePlacementContext(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (!blockstate.func_203425_a(this.regular_block) && !blockstate.func_203425_a(this.chaotic_block) || this.remote_type == HoloRemoteType.simple || this.remote_type == HoloRemoteType.broken) {
            return context;
        }
        Direction direction = context.func_225518_g_() ? (context.func_221533_k() ? context.func_196000_l().func_176734_d() : context.func_196000_l()) : (context.func_196000_l().func_176740_k() == Direction.Axis.Y ? context.func_195992_f() : (this.remote_type == HoloRemoteType.regular ? Direction.UP : Direction.DOWN));
        int i = 0;
        BlockPos.Mutable blockpos$mutable = blockpos.func_239590_i_().func_189536_c(direction);
        while (i < 30) {
            if (!world.field_72995_K && !World.func_175701_a((BlockPos)blockpos$mutable)) {
                PlayerEntity playerentity = context.func_195999_j();
                int j = world.func_217301_I();
                if (!(playerentity instanceof ServerPlayerEntity) || blockpos$mutable.func_177956_o() < j) break;
                SChatPacket schatpacket = new SChatPacket((ITextComponent)new TranslationTextComponent("build.tooHigh", new Object[]{j}).func_240699_a_(TextFormatting.RED), ChatType.GAME_INFO, Util.field_240973_b_);
                ((ServerPlayerEntity)playerentity).field_71135_a.func_147359_a((IPacket)schatpacket);
                break;
            }
            blockstate = world.func_180495_p((BlockPos)blockpos$mutable);
            if (!blockstate.func_203425_a(this.getBlock())) {
                if (!blockstate.func_196953_a(context)) break;
                return BlockItemUseContext.func_221536_a((BlockItemUseContext)context, (BlockPos)blockpos$mutable, (Direction)direction);
            }
            blockpos$mutable.func_189536_c(direction);
            if (!direction.func_176740_k().func_176722_c()) continue;
            ++i;
        }
        return null;
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)this.getBlockRaw().delegate.get();
    }

    private Block getBlockRaw() {
        return this.remote_type == HoloRemoteType.broken ? this.chaotic_block : this.regular_block;
    }

    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        ActionResultType actionresulttype = this.place(new BlockItemUseContext(p_195939_1_));
        return !actionresulttype.func_226246_a_() && this.func_219971_r() ? this.func_77659_a(p_195939_1_.func_195991_k(), p_195939_1_.func_195999_j(), p_195939_1_.func_221531_n()).func_188397_a() : actionresulttype;
    }

    @Nullable
    protected BlockState getPlacementState(BlockItemUseContext p_195945_1_) {
        BlockState blockstate = this.getBlock().func_196258_a(p_195945_1_);
        return blockstate != null && this.canPlace(p_195945_1_, blockstate) ? blockstate : null;
    }

    protected boolean canPlace(BlockItemUseContext p_195944_1_, BlockState p_195944_2_) {
        PlayerEntity playerentity = p_195944_1_.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerentity);
        return (!this.mustSurvive() || p_195944_2_.func_196955_c((IWorldReader)p_195944_1_.func_195991_k(), p_195944_1_.func_195995_a())) && p_195944_1_.func_195991_k().func_226663_a_(p_195944_2_, p_195944_1_.func_195995_a(), iselectioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockItemUseContext p_195941_1_, BlockState p_195941_2_) {
        boolean ret = p_195941_1_.func_195991_k().func_180501_a(p_195941_1_.func_195995_a(), p_195941_2_, 11);
        if (this.remote_type == HoloRemoteType.broken) {
            p_195941_1_.func_195991_k().func_205220_G_().func_205362_a(p_195941_1_.func_195995_a(), (Object)p_195941_2_.func_177230_c(), 2, TickPriority.VERY_LOW);
        }
        return ret;
    }

    public ActionResultType place(BlockItemUseContext context) {
        if (!context.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        BlockItemUseContext blockitemusecontext = this.updatePlacementContext(context);
        if (blockitemusecontext == null) {
            return ActionResultType.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockitemusecontext);
        if (blockstate == null) {
            return ActionResultType.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.func_195995_a();
        World world = blockitemusecontext.func_195991_k();
        PlayerEntity playerentity = blockitemusecontext.func_195999_j();
        ItemStack itemstack = blockitemusecontext.func_195996_i();
        BlockState blockstate1 = world.func_180495_p(blockpos);
        Block block = blockstate1.func_177230_c();
        if (block == blockstate.func_177230_c()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, world, itemstack, blockstate1);
            this.updateCustomBlockEntityTag(blockpos, world, playerentity, itemstack, blockstate1);
            block.func_180633_a(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((IWorldReader)world, blockpos, (Entity)context.func_195999_j());
        world.func_184133_a(playerentity, blockpos, this.getPlaceSound(blockstate1, world, blockpos, context.func_195999_j()), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (playerentity == null || !playerentity.field_71075_bZ.field_75098_d) {
            // empty if block
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos p_195943_1_, World p_195943_2_, @Nullable PlayerEntity p_195943_3_, ItemStack p_195943_4_, BlockState p_195943_5_) {
        return HoloRemoteItem.updateCustomBlockEntityTag(p_195943_2_, p_195943_3_, p_195943_1_, p_195943_4_);
    }

    public static boolean updateCustomBlockEntityTag(World p_179224_0_, @Nullable PlayerEntity p_179224_1_, BlockPos p_179224_2_, ItemStack p_179224_3_) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = p_179224_0_.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        CompoundNBT compoundnbt = p_179224_3_.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && (tileentity = p_179224_0_.func_175625_s(p_179224_2_)) != null) {
            if (!(p_179224_0_.field_72995_K || !tileentity.func_183000_F() || p_179224_1_ != null && p_179224_1_.func_195070_dx())) {
                return false;
            }
            CompoundNBT compoundnbt1 = tileentity.func_189515_b(new CompoundNBT());
            CompoundNBT compoundnbt2 = compoundnbt1.func_74737_b();
            compoundnbt1.func_197643_a(compoundnbt);
            compoundnbt1.func_74768_a("x", p_179224_2_.func_177958_n());
            compoundnbt1.func_74768_a("y", p_179224_2_.func_177956_o());
            compoundnbt1.func_74768_a("z", p_179224_2_.func_177952_p());
            if (!compoundnbt1.equals((Object)compoundnbt2)) {
                tileentity.func_230337_a_(p_179224_0_.func_180495_p(p_179224_2_), compoundnbt1);
                tileentity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private BlockState updateBlockStateFromTag(BlockPos p_219985_1_, World p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundNBT compoundnbt = p_219985_3_.func_77978_p();
        if (compoundnbt != null) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("BlockStateTag");
            StateContainer statecontainer = p_219985_4_.func_177230_c().func_176194_O();
            for (String s : compoundnbt1.func_150296_c()) {
                Property property = statecontainer.func_185920_a(s);
                if (property == null) continue;
                String s1 = compoundnbt1.func_74781_a(s).func_150285_a_();
                blockstate = HoloRemoteItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.func_180501_a(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState p_219988_0_, Property<T> p_219988_1_, String p_219988_2_) {
        return p_219988_1_.func_185929_b(p_219988_2_).map(p_219986_2_ -> (BlockState)p_219988_0_.func_206870_a(p_219988_1_, p_219986_2_)).orElse(p_219988_0_);
    }

    protected SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        return state.getSoundType((IWorldReader)world, pos, (Entity)entity).func_185841_e();
    }

    public static enum HoloRemoteType {
        regular,
        backwards,
        simple,
        broken;

    }
}

