/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import java.util.Random;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CampfireCartEntity
extends AbstractMinecartEntity {
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(FurnaceMinecartEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String PUSH_X_NAME = "PushX";
    private static final String PUSH_Z_NAME = "PushZ";
    private static final String POWERED_NAME = "powered";
    public double pushX = 0.0;
    public double pushZ = 0.0;

    public CampfireCartEntity(EntityType<?> furnaceCart, World world) {
        super(furnaceCart, world);
    }

    public CampfireCartEntity(EntityType<?> furnaceCart, World worldIn, double x, double y, double z) {
        super(furnaceCart, worldIn, x, y, z);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.FURNACE;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (Math.abs(this.func_213322_ci().field_72450_a * 5.0) > this.pushX) {
            this.pushX = this.func_213322_ci().field_72450_a;
        }
        if (Math.abs(this.func_213322_ci().field_72449_c * 5.0) > this.pushZ) {
            this.pushZ = this.func_213322_ci().field_72449_c;
        }
        if (this.isMinecartPowered() && this.field_70170_p.func_201670_d()) {
            Vector3d pos = this.func_213303_ch();
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.field_70170_p.func_184134_a(pos.field_72450_a, pos.field_72448_b + 0.4, pos.field_72449_c, SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.2f + this.field_70146_Z.nextFloat() / 3.0f, this.field_70146_Z.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                CampfireCartEntity.spawnSmokeParticles(this.field_70170_p, pos, false, false);
            }
        }
    }

    private static void spawnSmokeParticles(World worldIn, Vector3d pos, boolean isSignalFire, boolean spawnExtraSmoke) {
        if (!worldIn.func_201670_d()) {
            return;
        }
        Random random = worldIn.func_201674_k();
        BasicParticleType basicparticletype = isSignalFire ? ParticleTypes.field_218418_af : ParticleTypes.field_218417_ae;
        worldIn.func_195590_a((IParticleData)basicparticletype, true, pos.field_72450_a + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), pos.field_72448_b + 0.4 + random.nextDouble(), pos.field_72449_c + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, pos.field_72450_a, pos.field_72448_b + 0.8, pos.field_72449_c, 0.0, 0.005, 0.0);
        }
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199703_a((IItemProvider)MMItemReferences.campfire_cart);
        }
    }

    protected void func_180460_a(BlockPos pos, BlockState state) {
        double d0 = 1.0E-4;
        double d1 = 0.001;
        super.func_180460_a(pos, state);
        Vector3d vector3d = this.func_213322_ci();
        double d2 = CampfireCartEntity.func_213296_b((Vector3d)vector3d);
        double d3 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (this.isMinecartPowered() && d3 > 1.0E-4 && d2 > 0.001) {
            double d4 = MathHelper.func_76133_a((double)d2);
            double d5 = MathHelper.func_76133_a((double)d3);
            this.pushX = vector3d.field_72450_a / d4 * d5;
            this.pushZ = vector3d.field_72449_c / d4 * d5;
        }
    }

    protected void func_94101_h() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (this.isMinecartPowered() && d0 > 1.0E-7 && this.isMinecartPowered() && !this.isGoingUphill()) {
            d0 = MathHelper.func_76133_a((double)d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            Vector3d min_motion = this.func_213322_ci().func_216372_d(0.8, 0.0, 0.8);
            double speed_coeff = this.getSpeedDiv();
            double new_x = Math.abs(this.pushX / speed_coeff) > Math.abs(min_motion.field_72450_a) ? this.pushX / speed_coeff : min_motion.field_72450_a;
            double new_z = Math.abs(this.pushZ / speed_coeff) > Math.abs(min_motion.field_72449_c) ? this.pushZ / speed_coeff : min_motion.field_72449_c;
            this.func_213293_j(new_x, min_motion.field_72448_b, new_z);
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.95, 0.0, 0.95));
        }
        super.func_94101_h();
    }

    public double getSpeedDiv() {
        return 11.0;
    }

    public boolean isGoingUphill() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.func_213303_ch().field_72450_a);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_213303_ch().field_72448_b), k = MathHelper.func_76128_c((double)this.func_213303_ch().field_72449_c));
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (AbstractRailBlock.func_208487_j((BlockState)state)) {
            RailShape railshape = ((AbstractRailBlock)state.func_177230_c()).getRailDirection(state, (IBlockReader)this.field_70170_p, pos, (AbstractMinecartEntity)this);
            boolean is_uphill = railshape == RailShape.ASCENDING_EAST || railshape == RailShape.ASCENDING_WEST || railshape == RailShape.ASCENDING_NORTH || railshape == RailShape.ASCENDING_SOUTH;
            return is_uphill;
        }
        return true;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ActionResultType ret = super.func_184230_a(player, hand);
        if (ret.func_226246_a_()) {
            return ret;
        }
        if (this.pushX == 0.0 && this.pushZ == 0.0) {
            this.pushX = this.func_213303_ch().field_72450_a - player.func_213303_ch().field_72450_a;
            this.pushZ = this.func_213303_ch().field_72449_c - player.func_213303_ch().field_72449_c;
        }
        Vector3d pos = this.func_213303_ch();
        if (this.field_70170_p.func_201670_d()) {
            if (this.isMinecartPowered()) {
                this.field_70170_p.func_184134_a(pos.field_72450_a, pos.field_72448_b + 0.4, pos.field_72449_c, SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 0.3f, 1.0f, false);
                CampfireCartEntity.spawnSmokeParticles(this.field_70170_p, this.func_213303_ch(), false, true);
            } else {
                this.field_70170_p.func_184134_a(pos.field_72450_a, pos.field_72448_b + 0.4, pos.field_72449_c, SoundEvents.field_187649_bu, SoundCategory.NEUTRAL, 0.3f, this.field_70170_p.func_201674_k().nextFloat() * 0.4f + 0.8f, false);
            }
        }
        this.setMinecartPowered(!this.isMinecartPowered());
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    public boolean isMinecartPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setMinecartPowered(boolean powered) {
        this.field_70180_af.func_187227_b(POWERED, (Object)powered);
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74780_a(PUSH_X_NAME, this.pushX);
        compound.func_74780_a(PUSH_Z_NAME, this.pushZ);
        compound.func_74757_a(POWERED_NAME, this.isMinecartPowered());
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.pushX = compound.func_74769_h(PUSH_X_NAME);
        this.pushZ = compound.func_74769_h(PUSH_Z_NAME);
        this.setMinecartPowered(compound.func_74767_n(POWERED_NAME));
    }

    public BlockState func_180457_u() {
        return (BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(this.isMinecartPowered()));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)MMItemReferences.campfire_cart);
    }
}

