/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.settings.ModOptions;
import xaero.map.world.MapWorld;

public class ModSettings {
    public String[] arrowColourNames = new String[]{"gui.xaero_wm_red", "gui.xaero_wm_green", "gui.xaero_wm_blue", "gui.xaero_wm_yellow", "gui.xaero_wm_purple", "gui.xaero_wm_white", "gui.xaero_wm_black", "gui.xaero_wm_legacy_color"};
    public static float[][] arrowColours = new float[][]{{0.8f, 0.1f, 0.1f, 1.0f}, {0.09f, 0.57f, 0.0f, 1.0f}, {0.0f, 0.55f, 1.0f, 1.0f}, {1.0f, 0.93f, 0.0f, 1.0f}, {0.73f, 0.33f, 0.83f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f}, {0.4588f, 0.0f, 0.0f, 1.0f}};
    public static int ignoreUpdate;
    public static final String format = "\u00a7";
    public static boolean updateNotification;
    private int regionCacheHashCode;
    public boolean debug = false;
    public boolean detailed_debug = false;
    public boolean lighting = true;
    public boolean loadChunks = true;
    public boolean updateChunks = true;
    public int terrainSlopes = 2;
    public String[] slopeNames = new String[]{"gui.xaero_off", "gui.xaero_wm_slopes_legacy", "gui.xaero_wm_slopes_default_3d", "gui.xaero_wm_slopes_default_2d"};
    public boolean terrainDepth = true;
    public boolean footsteps = true;
    public boolean flowers = true;
    public boolean coordinates = true;
    public int colours = 0;
    public String[] colourNames = new String[]{"gui.xaero_accurate", "gui.xaero_vanilla"};
    public boolean biomeColorsVanillaMode = false;
    public boolean differentiateByServerAddress = true;
    public boolean waypoints = true;
    public boolean renderArrow = true;
    public boolean displayZoom = true;
    public boolean openMapAnimation = true;
    public float worldmapWaypointsScale = 1.0f;
    public int reloadVersion = 0;
    public boolean reloadEverything = false;
    public boolean zoomButtons = true;
    public boolean waypointBackgrounds = true;
    public boolean netherlikeCaveMapAllowed = true;
    public boolean pauseRequests = false;
    public boolean extraDebug = false;
    public boolean ignoreHeightmaps;
    public static String mapItemId;
    public static Item mapItem;
    public boolean detectAmbiguousY = true;
    public boolean showDisabledWaypoints;
    public boolean closeWaypointsWhenHopping = true;
    public boolean adjustHeightForCarpetLikeBlocks = true;
    public boolean onlyCurrentMapWaypoints = false;
    public double minZoomForLocalWaypoints = 0.0;
    public int arrowColour = -2;

    public void saveSettings() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(WorldMap.optionsFile));
        writer.println("ignoreUpdate:" + ignoreUpdate);
        writer.println("updateNotification:" + updateNotification);
        writer.println("differentiateByServerAddress:" + this.differentiateByServerAddress);
        writer.println("netherlikeCaveMapAllowed:" + this.netherlikeCaveMapAllowed);
        writer.println("debug:" + this.debug);
        writer.println("lighting:" + this.lighting);
        writer.println("colours:" + this.colours);
        writer.println("loadChunks:" + this.loadChunks);
        writer.println("updateChunks:" + this.updateChunks);
        writer.println("terrainSlopes:" + this.terrainSlopes);
        writer.println("terrainDepth:" + this.terrainDepth);
        writer.println("footsteps:" + this.footsteps);
        writer.println("flowers:" + this.flowers);
        writer.println("coordinates:" + this.coordinates);
        writer.println("biomeColorsVanillaMode:" + this.biomeColorsVanillaMode);
        writer.println("waypoints:" + this.waypoints);
        writer.println("renderArrow:" + this.renderArrow);
        writer.println("displayZoom:" + this.displayZoom);
        writer.println("worldmapWaypointsScale:" + this.worldmapWaypointsScale);
        writer.println("openMapAnimation:" + this.openMapAnimation);
        writer.println("reloadVersion:" + this.reloadVersion);
        writer.println("reloadEverything:" + this.reloadEverything);
        writer.println("zoomButtons:" + this.zoomButtons);
        writer.println("waypointBackgrounds:" + this.waypointBackgrounds);
        if (mapItemId != null) {
            writer.println("mapItemId:" + mapItemId);
        }
        writer.println("detectAmbiguousY:" + this.detectAmbiguousY);
        writer.println("showDisabledWaypoints:" + this.showDisabledWaypoints);
        writer.println("closeWaypointsWhenHopping:" + this.closeWaypointsWhenHopping);
        writer.println("adjustHeightForCarpetLikeBlocks:" + this.adjustHeightForCarpetLikeBlocks);
        writer.println("onlyCurrentMapWaypoints:" + this.onlyCurrentMapWaypoints);
        writer.println("minZoomForLocalWaypoints:" + this.minZoomForLocalWaypoints);
        writer.println("arrowColour:" + this.arrowColour);
        writer.println("globalVersion:" + WorldMap.globalVersion);
        writer.close();
    }

    private void loadDefaultSettings() throws IOException {
        File mainConfigFile = WorldMap.optionsFile;
        File defaultConfigFile = mainConfigFile.toPath().getParent().resolveSibling("defaultconfigs").resolve(mainConfigFile.getName()).toFile();
        if (defaultConfigFile.exists()) {
            this.loadSettingsFile(defaultConfigFile);
        }
    }

    public void loadSettings() throws IOException {
        this.loadDefaultSettings();
        File mainConfigFile = WorldMap.optionsFile;
        Path configFolderPath = mainConfigFile.toPath().getParent();
        if (!Files.exists(configFolderPath, new LinkOption[0])) {
            Files.createDirectories(configFolderPath, new FileAttribute[0]);
        }
        if (!mainConfigFile.exists()) {
            this.saveSettings();
            return;
        }
        this.loadSettingsFile(WorldMap.optionsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettingsFile(File file) throws IOException {
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(file));
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                try {
                    if (args[0].equalsIgnoreCase("ignoreUpdate")) {
                        ignoreUpdate = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("updateNotification")) {
                        updateNotification = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("differentiateByServerAddress")) {
                        this.differentiateByServerAddress = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("netherlikeCaveMapAllowed")) {
                        this.netherlikeCaveMapAllowed = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("debug")) {
                        this.debug = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("lighting")) {
                        this.lighting = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("colours")) {
                        this.colours = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("loadChunks")) {
                        this.loadChunks = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("updateChunks")) {
                        this.updateChunks = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("terrainSlopes")) {
                        this.terrainSlopes = args[1].equals("true") ? 2 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("terrainDepth")) {
                        this.terrainDepth = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("footsteps")) {
                        this.footsteps = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("flowers")) {
                        this.flowers = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("coordinates")) {
                        this.coordinates = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("biomeColorsVanillaMode")) {
                        this.biomeColorsVanillaMode = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("waypoints")) {
                        this.waypoints = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("renderArrow")) {
                        this.renderArrow = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("displayZoom")) {
                        this.displayZoom = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("worldmapWaypointsScale")) {
                        this.worldmapWaypointsScale = Float.parseFloat(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("openMapAnimation")) {
                        this.openMapAnimation = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("reloadVersion")) {
                        this.reloadVersion = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("reloadEverything")) {
                        this.reloadEverything = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("zoomButtons")) {
                        this.zoomButtons = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("waypointBackgrounds")) {
                        this.waypointBackgrounds = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("mapItemId")) {
                        mapItemId = args[1] + ":" + args[2];
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("detectAmbiguousY")) {
                        this.detectAmbiguousY = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("showDisabledWaypoints")) {
                        this.showDisabledWaypoints = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("closeWaypointsWhenHopping")) {
                        this.closeWaypointsWhenHopping = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("adjustHeightForCarpetLikeBlocks")) {
                        this.adjustHeightForCarpetLikeBlocks = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("onlyCurrentMapWaypoints")) {
                        this.onlyCurrentMapWaypoints = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("minZoomForLocalWaypoints")) {
                        this.minZoomForLocalWaypoints = Double.parseDouble(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("arrowColour")) {
                        this.arrowColour = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (!args[0].equalsIgnoreCase("globalVersion")) continue;
                    WorldMap.globalVersion = Integer.parseInt(args[1]);
                }
                catch (Exception e) {
                    WorldMap.LOGGER.info("Skipping setting:" + args[0]);
                }
            }
        }
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        if (par1EnumOptions.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return par1EnumOptions.getEnumString();
        }
        String s = par1EnumOptions.getEnumString() + ": ";
        if (par1EnumOptions.getEnumDouble()) {
            String f1 = String.format("%.2f", this.getOptionDoubleValue(par1EnumOptions));
            return s + f1;
        }
        if (par1EnumOptions == ModOptions.COLOURS) {
            s = s + I18n.func_135052_a((String)this.colourNames[this.colours], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.SLOPES) {
            s = s + I18n.func_135052_a((String)this.slopeNames[this.terrainSlopes], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
            String colourName = "gui.xaero_wm_team_color";
            if (this.arrowColour >= 0) {
                colourName = this.arrowColourNames[this.arrowColour];
            } else if (this.arrowColour == -2) {
                colourName = "gui.xaero_wm_color_minimap";
            }
            s = s + I18n.func_135052_a((String)colourName, (Object[])new Object[0]);
        } else {
            boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
            s = s + ModSettings.getTranslation(clientSetting);
        }
        return s;
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return false;
        }
        if (o == ModOptions.IGNORE_HEIGHTMAPS) {
            return WorldMapSession.getCurrentSession().getMapProcessor().getMapWorld().isIgnoreHeightmaps();
        }
        if (o == ModOptions.DEBUG) {
            return this.debug;
        }
        if (o == ModOptions.LIGHTING) {
            return this.lighting;
        }
        if (o == ModOptions.LOAD) {
            return this.loadChunks;
        }
        if (o == ModOptions.UPDATE) {
            return this.updateChunks;
        }
        if (o == ModOptions.DEPTH) {
            return this.terrainDepth;
        }
        if (o == ModOptions.STEPS) {
            return this.footsteps;
        }
        if (o == ModOptions.FLOWERS) {
            return this.flowers;
        }
        if (o == ModOptions.COORDINATES) {
            return this.coordinates;
        }
        if (o == ModOptions.BIOMES) {
            return this.biomeColorsVanillaMode;
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.waypoints;
        }
        if (o == ModOptions.ARROW) {
            return this.renderArrow;
        }
        if (o == ModOptions.DISPLAY_ZOOM) {
            return this.displayZoom;
        }
        if (o == ModOptions.OPEN_ANIMATION) {
            return this.openMapAnimation;
        }
        if (o == ModOptions.RELOAD) {
            return this.reloadEverything;
        }
        if (o == ModOptions.ZOOM_BUTTONS) {
            return this.zoomButtons;
        }
        if (o == ModOptions.WAYPOINT_BACKGROUNDS) {
            return this.waypointBackgrounds;
        }
        if (o == ModOptions.DETECT_AMBIGUOUS_Y) {
            return this.detectAmbiguousY;
        }
        if (o == ModOptions.PAUSE_REQUESTS) {
            return this.pauseRequests;
        }
        if (o == ModOptions.EXTRA_DEBUG) {
            return this.extraDebug;
        }
        if (o == ModOptions.UPDATE_NOTIFICATION) {
            return updateNotification;
        }
        if (o == ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS) {
            return this.adjustHeightForCarpetLikeBlocks;
        }
        return false;
    }

    private static String getTranslation(boolean o) {
        return I18n.func_135052_a((String)("gui.xaero_" + (o ? "on" : "off")), (Object[])new Object[0]);
    }

    public void setOptionValue(ModOptions par1EnumOptions) {
        if (par1EnumOptions.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return;
        }
        if (par1EnumOptions == ModOptions.DEBUG) {
            boolean bl = this.debug = !this.debug;
        }
        if (par1EnumOptions == ModOptions.COLOURS) {
            this.colours = (this.colours + 1) % 2;
        }
        if (par1EnumOptions == ModOptions.LIGHTING) {
            boolean bl = this.lighting = !this.lighting;
        }
        if (par1EnumOptions == ModOptions.LOAD) {
            boolean bl = this.loadChunks = !this.loadChunks;
        }
        if (par1EnumOptions == ModOptions.UPDATE) {
            boolean bl = this.updateChunks = !this.updateChunks;
        }
        if (par1EnumOptions == ModOptions.DEPTH) {
            boolean bl = this.terrainDepth = !this.terrainDepth;
        }
        if (par1EnumOptions == ModOptions.SLOPES) {
            this.terrainSlopes = (this.terrainSlopes + 1) % 4;
        }
        if (par1EnumOptions == ModOptions.STEPS) {
            boolean bl = this.footsteps = !this.footsteps;
        }
        if (par1EnumOptions == ModOptions.FLOWERS) {
            boolean bl = this.flowers = !this.flowers;
        }
        if (par1EnumOptions == ModOptions.COORDINATES) {
            boolean bl = this.coordinates = !this.coordinates;
        }
        if (par1EnumOptions == ModOptions.BIOMES) {
            boolean bl = this.biomeColorsVanillaMode = !this.biomeColorsVanillaMode;
        }
        if (par1EnumOptions == ModOptions.WAYPOINTS) {
            boolean bl = this.waypoints = !this.waypoints;
        }
        if (par1EnumOptions == ModOptions.ARROW) {
            boolean bl = this.renderArrow = !this.renderArrow;
        }
        if (par1EnumOptions == ModOptions.DISPLAY_ZOOM) {
            boolean bl = this.displayZoom = !this.displayZoom;
        }
        if (par1EnumOptions == ModOptions.IGNORE_HEIGHTMAPS) {
            MapWorld mapWorld;
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            mapWorld.setIgnoreHeightmaps(!(mapWorld = worldmapSession.getMapProcessor().getMapWorld()).isIgnoreHeightmaps());
            mapWorld.saveConfig();
        }
        if (par1EnumOptions == ModOptions.OPEN_ANIMATION) {
            boolean bl = this.openMapAnimation = !this.openMapAnimation;
        }
        if (par1EnumOptions == ModOptions.RELOAD) {
            boolean bl = this.reloadEverything = !this.reloadEverything;
            if (this.reloadEverything) {
                ++this.reloadVersion;
            }
        }
        if (par1EnumOptions == ModOptions.ZOOM_BUTTONS) {
            boolean bl = this.zoomButtons = !this.zoomButtons;
        }
        if (par1EnumOptions == ModOptions.WAYPOINT_BACKGROUNDS) {
            boolean bl = this.waypointBackgrounds = !this.waypointBackgrounds;
        }
        if (par1EnumOptions == ModOptions.DETECT_AMBIGUOUS_Y) {
            boolean bl = this.detectAmbiguousY = !this.detectAmbiguousY;
        }
        if (par1EnumOptions == ModOptions.PAUSE_REQUESTS) {
            boolean bl = this.pauseRequests = !this.pauseRequests;
        }
        if (par1EnumOptions == ModOptions.EXTRA_DEBUG) {
            boolean bl = this.extraDebug = !this.extraDebug;
        }
        if (par1EnumOptions == ModOptions.UPDATE_NOTIFICATION) {
            boolean bl = updateNotification = !updateNotification;
        }
        if (par1EnumOptions == ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS) {
            this.adjustHeightForCarpetLikeBlocks = !this.adjustHeightForCarpetLikeBlocks;
        } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
            ++this.arrowColour;
            if (this.arrowColour == arrowColours.length) {
                this.arrowColour = -2;
            }
        }
        this.updateRegionCacheHashCode();
        try {
            this.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().func_147108_a(Minecraft.func_71410_x().field_71462_r);
        }
    }

    public void setOptionDoubleValue(ModOptions options, double f) {
        if (options.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return;
        }
        if (options == ModOptions.WAYPOINT_SCALE) {
            this.worldmapWaypointsScale = (float)f;
        }
        if (options == ModOptions.MIN_ZOOM_LOCAL_WAYPOINTS) {
            this.minZoomForLocalWaypoints = f;
        }
        try {
            this.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public double getOptionDoubleValue(ModOptions options) {
        if (options.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return 0.0;
        }
        if (options == ModOptions.WAYPOINT_SCALE) {
            return this.worldmapWaypointsScale;
        }
        if (options == ModOptions.MIN_ZOOM_LOCAL_WAYPOINTS) {
            return this.minZoomForLocalWaypoints;
        }
        return 1.0;
    }

    public int getRegionCacheHashCode() {
        return this.regionCacheHashCode;
    }

    public void updateRegionCacheHashCode() {
        int currentRegionCacheHashCode = this.regionCacheHashCode;
        if (!Minecraft.func_71410_x().func_213162_bc()) {
            throw new RuntimeException("Wrong thread!");
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.colours).append(this.terrainDepth).append(this.terrainSlopes).append(false).append(this.colours == 1 && this.biomeColorsVanillaMode).append(this.getClientBooleanValue(ModOptions.IGNORE_HEIGHTMAPS)).append(this.adjustHeightForCarpetLikeBlocks);
        Collection enabledResourcePacks = Minecraft.func_71410_x().func_195548_H().func_198980_d();
        for (ResourcePackInfo resourcePack : enabledResourcePacks) {
            hcb.append((Object)resourcePack.func_195790_f());
        }
        this.regionCacheHashCode = hcb.toHashCode();
        if (currentRegionCacheHashCode != this.regionCacheHashCode) {
            WorldMap.LOGGER.info("New world map region cache hash code: " + this.regionCacheHashCode);
        }
    }

    public static boolean canEditIngameSettings() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        return worldmapSession != null && worldmapSession.getMapProcessor().getMapWorld() != null;
    }

    public void findMapItem() {
        mapItem = mapItemId != null ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mapItemId)) : null;
    }

    static {
        updateNotification = true;
        mapItemId = null;
        mapItem = null;
    }
}

