/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.icon.XaeroIconAtlasManager;
import xaero.map.misc.Misc;

public class WaypointSymbolCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    private static final int ICON_WIDTH = 64;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private Minecraft mc = Minecraft.func_71410_x();
    private XaeroIcon deathSymbolTexture;
    private final Map<String, XaeroIcon> charSymbols = new HashMap<String, XaeroIcon>();
    private XaeroIconAtlasManager iconManager;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private XaeroIconAtlas lastAtlas;
    private MatrixStack matrixStack = new MatrixStack();

    public XaeroIcon getDeathSymbolTexture() {
        if (this.deathSymbolTexture == null) {
            this.createDeathSymbolTexture();
        }
        return this.deathSymbolTexture;
    }

    private void createDeathSymbolTexture() {
        this.deathSymbolTexture = this.createCharSymbol(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XaeroIcon getSymbolTexture(String c) {
        XaeroIcon icon;
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            icon = this.charSymbols.get(c);
        }
        if (icon == null) {
            icon = this.createCharSymbol(false, c);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XaeroIcon createCharSymbol(boolean death, String c) {
        if (this.iconManager == null) {
            OpenGLException.checkGLError();
            int maxTextureSize = GlStateManager.func_227612_D_((int)3379);
            OpenGLException.checkGLError();
            int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
            this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
            OpenGLException.checkGLError();
            GlStateManager.func_227758_s_((int)this.atlasRenderFramebuffer.getFramebufferTexture());
            OpenGLException.checkGLError();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
            this.iconManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        }
        XaeroIconAtlas atlas = this.iconManager.getCurrentAtlas();
        XaeroIcon icon = atlas.createIcon();
        this.atlasRenderFramebuffer.func_147610_a(false);
        GlStateManager.func_227714_e_((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
        this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
        this.atlasRenderFramebuffer.func_147611_b();
        if (this.lastAtlas != atlas) {
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)Minecraft.field_142025_a);
            this.lastAtlas = atlas;
        }
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)64.0, (double)64.0, (double)0.0, (double)-1.0, (double)1000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)2.0f, (float)2.0f, (float)0.0f);
        if (!death) {
            RenderSystem.scalef((float)3.0f, (float)3.0f, (float)1.0f);
            this.mc.field_71466_p.func_238405_a_(this.matrixStack, c, 0.0f, 0.0f, -1);
        } else {
            RenderSystem.scalef((float)3.0f, (float)3.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(minimapTextures);
            RenderSystem.color4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            AbstractGui.func_238464_a_((MatrixStack)this.matrixStack, (int)1, (int)1, (int)0, (float)0.0f, (float)78.0f, (int)9, (int)9, (int)256, (int)256);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            AbstractGui.func_238464_a_((MatrixStack)this.matrixStack, (int)0, (int)0, (int)0, (float)0.0f, (float)78.0f, (int)9, (int)9, (int)256, (int)256);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.matrixMode((int)5889);
        Misc.minecraftOrtho(this.mc);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
        this.atlasRenderFramebuffer.func_147609_e();
        ImprovedFramebuffer.bindDefaultFramebuffer(this.atlasRenderFramebuffer.getType(), 36160, this.mc);
        GlStateManager.func_227714_e_((int)0, (int)0, (int)this.mc.func_228018_at_().func_198109_k(), (int)this.mc.func_228018_at_().func_198091_l());
        if (death) {
            this.deathSymbolTexture = icon;
        } else {
            Map<String, XaeroIcon> map = this.charSymbols;
            synchronized (map) {
                this.charSymbols.put(c, icon);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChars() {
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            this.charSymbols.clear();
        }
        if (this.iconManager != null) {
            this.iconManager.clearAtlases();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
        }
    }
}

