/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import xaero.map.element.MapElement;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.gui.GuiMap;

public abstract class MapElementRenderer<E extends MapElement<R>, R extends MapElementRenderer<E, R>> {
    protected final R self = this;

    public abstract double getRendererScale();

    public abstract Iterator<E> getElementsToRender();

    protected MapElementRenderer() {
    }

    public E getHovered(GuiMap mapScreen, double mouseX, double mouseZ, double scale, double guiBasedScale) {
        Iterator<E> elements = this.getElementsToRender();
        double rendererScale = this.getRendererScale();
        MapElement result = null;
        while (elements.hasNext()) {
            MapElement e = (MapElement)elements.next();
            if (e.isHidden(this.self, mapScreen) || !e.isHoveredOnMap(mouseX, mouseZ, scale, rendererScale, guiBasedScale)) continue;
            result = e;
        }
        return (E)result;
    }

    public void renderPre(MapElement<?> hovered, GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, IVertexBuilder regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, TextureManager textureManager, FontRenderer font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, MapElement<?> oldHovered, Minecraft mc, IVertexBuilder textBGConsumer) {
    }

    public void renderHoveredPre(MapElement<?> hovered, GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, IVertexBuilder regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, TextureManager textureManager, FontRenderer font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, Minecraft mc, IVertexBuilder textBGConsumer) {
    }

    private void renderElement(E e, MapElement<?> hovered, GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, IVertexBuilder regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, TextureManager textureManager, FontRenderer font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double globalElementScale, double mouseX, double mouseZ, float brightness, Minecraft mc, IVertexBuilder textBGConsumer) {
        float elementScale = (float)(globalElementScale * ((MapElement)e).getScale());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)(((MapElement)e).getRenderX() - cameraX)), (double)((float)(((MapElement)e).getRenderZ() - cameraZ)), 0.0);
        matrixStack.func_227862_a_(elementScale, elementScale, 1.0f);
        this.renderOnMap(e, e == hovered, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, scale, guiBasedScale, uniqueTextureUIObjectRenderer, textureManager, font, textBGConsumer, renderTypeBuffers, this.self);
        matrixStack.func_227865_b_();
    }

    public void render(MapElement<?> hovered, GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, IVertexBuilder regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, TextureManager textureManager, FontRenderer font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, MapElement<?> oldHovered, Minecraft mc, IVertexBuilder textBGConsumer) {
        double globalElementScale = baseScale * this.getRendererScale();
        Iterator<E> elements = this.getElementsToRender();
        while (elements.hasNext()) {
            MapElement e = (MapElement)elements.next();
            if (e.isHidden(this.self, mapScreen) || e == hovered || !e.isOnScreen(cameraX, cameraZ, width, height, scale)) continue;
            this.renderElement(e, hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, font, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, globalElementScale, mouseX, mouseZ, brightness, mc, textBGConsumer);
        }
    }

    public void renderHovered(MapElement<?> hovered, GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, IVertexBuilder regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, TextureManager textureManager, FontRenderer font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, Minecraft mc, IVertexBuilder textBGConsumer) {
        double globalElementScale = baseScale * this.getRendererScale();
        MapElement<?> hoveredCast = hovered;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 10.0);
        this.renderElement(hoveredCast, hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, font, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, globalElementScale, mouseX, mouseZ, brightness, mc, textBGConsumer);
        matrixStack.func_227865_b_();
    }

    public abstract void renderOnMap(E var1, boolean var2, Minecraft var3, MatrixStack var4, double var5, double var7, double var9, double var11, double var13, double var15, MultiTextureRenderTypeRenderer var17, TextureManager var18, FontRenderer var19, IVertexBuilder var20, IRenderTypeBuffer.Impl var21, R var22);
}

