/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.element.MapElement;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointRenderer;

public class MapElementRenderHandler {
    private final List<MapElementRenderer<?, ?>> renderers;

    private MapElementRenderHandler(List<MapElementRenderer<?, ?>> renderers) {
        this.renderers = renderers;
    }

    public MapElement<?> render(GuiMap mapScreen, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double scale, double mouseX, double mouseZ, float brightness, MapElement<?> oldHovered, Minecraft mc) {
        IVertexBuilder regularUIObjectConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_BILINEAR);
        MapElement<?> hovered = null;
        MapElementRenderer<?, ?> hoveredRenderer = null;
        TextureManager textureManager = mc.func_110434_K();
        FontRenderer fontRenderer = mc.field_71466_p;
        textureManager.func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double baseScale = guiBasedScale / scale;
        for (int i = this.renderers.size() - 1; i >= 0; --i) {
            MapElementRenderer<?, ?> renderer = this.renderers.get(i);
            Object rendererHovered = renderer.getHovered(mapScreen, mouseX, mouseZ, scale, guiBasedScale);
            if (rendererHovered == null) continue;
            hovered = rendererHovered;
            hoveredRenderer = renderer;
            break;
        }
        MapElement<?> hoveredToReturn = hovered;
        if (hovered == null && (hovered = oldHovered) != null) {
            hoveredRenderer = (MapElementRenderer<?, ?>)hovered.getRenderer();
        }
        IVertexBuilder textBGConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
        MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
        for (MapElementRenderer<?, ?> renderer : this.renderers) {
            renderer.renderPre(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, oldHovered, mc, textBGConsumer);
        }
        rendererProvider.draw(uniqueTextureUIObjectRenderer);
        renderTypeBuffers.func_228461_a_();
        if (hovered != null) {
            regularUIObjectConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_BILINEAR);
            textBGConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
            uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
            hoveredRenderer.renderHoveredPre(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, mc, textBGConsumer);
            rendererProvider.draw(uniqueTextureUIObjectRenderer);
            renderTypeBuffers.func_228461_a_();
        }
        regularUIObjectConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_BILINEAR);
        textBGConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
        uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
        for (MapElementRenderer<?, ?> renderer : this.renderers) {
            renderer.render(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, oldHovered, mc, textBGConsumer);
        }
        rendererProvider.draw(uniqueTextureUIObjectRenderer);
        renderTypeBuffers.func_228461_a_();
        if (hovered != null) {
            regularUIObjectConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_BILINEAR);
            textBGConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
            uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
            hoveredRenderer.renderHovered(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, mc, textBGConsumer);
            rendererProvider.draw(uniqueTextureUIObjectRenderer);
            renderTypeBuffers.func_228461_a_();
        }
        textureManager.func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return hoveredToReturn;
    }

    public static final class Builder {
        private Builder() {
        }

        public MapElementRenderHandler build() {
            ArrayList<WaypointRenderer> renderers = new ArrayList<WaypointRenderer>();
            if (SupportMods.minimap()) {
                renderers.add(SupportMods.xaeroMinimap.getWaypointRenderer());
            }
            return new MapElementRenderHandler(renderers);
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

