/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.element.MapElement;
import xaero.map.element.MapElementMenuHitbox;
import xaero.map.element.MapElementMenuScroll;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.misc.Misc;

public abstract class MapElementMenuRenderer {
    private static final int MENU_RIGHT_PADDING = 27;
    public static final int MAX_MENU_SIZE = 10;
    public static final int MIN_MENU_SIZE = 2;
    protected final MapElementMenuScroll scrollUp = new MapElementMenuScroll("gui.xaero_wm_up", "\u25b3", 1);
    protected final MapElementMenuScroll scrollDown = new MapElementMenuScroll("gui.xaero_wm_down", "\u25bd", -1);
    protected final MapElementMenuHitbox extraHitbox = new MapElementMenuHitbox(-150, 0, 177, 0);
    protected ArrayList<MapElement<?>> filteredElements;
    private TextFieldWidget filterField;
    public int menuOffset = 0;
    protected Pattern searchPattern = null;
    protected Pattern searchStartPattern = null;
    protected final Minecraft mc = Minecraft.func_71410_x();

    public void onMapInit(GuiMap screen, List<GuiDropDown> dropdowns, Minecraft mc, int width, int height) {
        String searchText = this.filterField == null ? "" : this.filterField.func_146179_b();
        this.filterField = new TextFieldWidget(mc.field_71466_p, screen.field_230708_k_ - 172, this.menuStartPos(height) + 3 + this.menuSearchPadding(), 150, 20, (ITextComponent)new TranslationTextComponent(this.getFilterPlaceholder()));
        this.filterField.func_146180_a(searchText);
        screen.func_230481_d_(this.filterField);
    }

    public MapElement<?> renderMenu(MatrixStack matrixStack, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, Minecraft mc) {
        int menuStartPos;
        ArrayList<MapElement<?>> elements = this.filteredElements;
        int menuElementCount = MapElementMenuRenderer.getMenuElementCount(this.menuStartPos(height));
        if (this.menuOffset + menuElementCount > elements.size()) {
            this.menuOffset = elements.size() - menuElementCount;
        }
        if (this.menuOffset < 0) {
            this.menuOffset = 0;
        }
        int offset = this.menuOffset;
        MapElement<?> viewed = null;
        int yPos = menuStartPos = this.menuStartPos(height);
        int elementCount = MapElementMenuRenderer.getMenuElementCount(yPos);
        viewed = this.renderMenuElement(matrixStack, this.scrollDown, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, offset > 0, mc);
        yPos -= 8;
        for (int i = offset; i < elements.size(); ++i) {
            viewed = this.renderMenuElement(matrixStack, elements.get(i), width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, true, mc);
            yPos -= 8;
            if (i - offset == elementCount - 1) break;
        }
        viewed = this.renderMenuElement(matrixStack, this.scrollUp, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, offset < elements.size() - elementCount, mc);
        yPos -= 8;
        if (viewed != null && leftMouseClicked) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
        if (leftMousePressed && viewed instanceof MapElementMenuScroll) {
            int direction = ((MapElementMenuScroll)viewed).scroll();
            this.menuOffset += direction;
        }
        if (viewed == null) {
            this.extraHitbox.setH(menuStartPos - yPos);
            this.extraHitbox.setY(yPos - menuStartPos);
            viewed = this.renderMenuElement(matrixStack, this.extraHitbox, width, menuStartPos, mouseX, mouseY, viewed, leftMousePressed, gui, true, mc);
        }
        return viewed;
    }

    public void postMapRender(MatrixStack matrixStack, GuiMap gui, int scaledMouseX, int scaledMouseY, int width, int height, float partialTicks) {
        String searchText = this.filterField.func_146179_b();
        boolean searchFieldPlaceHolder = searchText.isEmpty() && !this.filterField.func_230999_j_();
        boolean invalidRegex = false;
        if (searchFieldPlaceHolder) {
            Misc.setFieldText(this.filterField, I18n.func_135052_a((String)this.getFilterPlaceholder(), (Object[])new Object[0]), -11184811);
        } else if (!searchText.isEmpty() && this.searchPattern == null) {
            invalidRegex = true;
        }
        this.filterField.func_230430_a_(matrixStack, scaledMouseX, scaledMouseY, partialTicks);
        if (searchFieldPlaceHolder) {
            Misc.setFieldText(this.filterField, "");
        } else if (invalidRegex) {
            String errorMessage = I18n.func_135052_a((String)"gui.xaero_wm_search_invalid_regex", (Object[])new Object[0]);
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.mc.field_71466_p, (String)errorMessage, (int)(width - 176 - this.mc.field_71466_p.func_78256_a(errorMessage)), (int)(height - 36), (int)-43691);
        }
    }

    public static int getMenuElementCount(int menuStartPos) {
        return Math.min(10, Math.max(2, (menuStartPos - 34) / 16 - 2));
    }

    private MapElement<?> renderMenuElement(MatrixStack matrixStack, MapElement<?> element, int width, int yPos, int mouseX, int mouseY, MapElement<?> viewed, boolean leftMousePressed, Screen gui, boolean enabled, Minecraft mc) {
        boolean hovered;
        int xPos = width - 27;
        boolean bl = hovered = viewed == null && element.isMouseOverMenuElement(xPos, yPos, mouseX, mouseY, mc);
        if (hovered) {
            viewed = element;
        }
        if (element != this.extraHitbox) {
            this.renderMenuElement(element, matrixStack, gui, xPos, yPos, mouseX, mouseY, 1.0, enabled, hovered, mc, leftMousePressed);
        }
        return viewed;
    }

    public void renderMenuElement(MapElement<?> element, MatrixStack matrixStack, Screen gui, int x, int y, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        matrixStack.func_227860_a_();
        if (hovered) {
            matrixStack.func_227861_a_(pressed ? 1.0 : 2.0, 0.0, 0.0);
        }
        matrixStack.func_227861_a_((double)x, (double)y, 0.0);
        matrixStack.func_227862_a_((float)scale, (float)scale, 1.0f);
        matrixStack.func_227861_a_(-4.0, -4.0, 0.0);
        String name = element.getMenuName();
        int len = mc.field_71466_p.func_78256_a(name);
        int textX = -3 - len;
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(textX - 2 - element.getMenuTextFillLeftPadding()), (int)-2, (int)(textX + len + 2), (int)11, (int)0x77000000);
        mc.field_71466_p.func_238405_a_(matrixStack, name, (float)textX, 0.0f, enabled ? -1 : -11184811);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        matrixStack.func_227861_a_(4.0, 4.0, 0.0);
        if (element == this.scrollUp || element == this.scrollDown) {
            this.renderScroll((MapElementMenuScroll)element, matrixStack, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed);
        } else {
            this.renderInMenu(element, matrixStack, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed, textX);
        }
        matrixStack.func_227865_b_();
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.releaseScroll();
    }

    private void releaseScroll() {
        this.scrollUp.onMouseRelease();
        this.scrollDown.onMouseRelease();
    }

    private void renderScroll(MapElementMenuScroll scroll, MatrixStack matrixStack, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        if (enabled && hovered) {
            matrixStack.func_227861_a_(pressed ? 1.0 : 2.0, 0.0, 0.0);
        }
        matrixStack.func_227861_a_(-4.0, -4.0, 0.0);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = enabled ? -1 : -11184811;
        mc.field_71466_p.func_238405_a_(matrixStack, scroll.getIcon(), (float)(5 - mc.field_71466_p.func_78256_a(scroll.getIcon()) / 2), 1.0f, color);
        RenderSystem.enableBlend();
    }

    private void updateSearch() {
        String search = this.filterField.func_146179_b();
        try {
            this.searchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.searchStartPattern = search.charAt(0) == '^' ? this.searchPattern : Pattern.compile('^' + search.toString().toLowerCase());
            } else {
                this.searchStartPattern = null;
                this.searchPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            this.searchStartPattern = null;
            this.searchPattern = null;
        }
        this.updateFilteredList();
    }

    public boolean charTyped() {
        if (this.filterField.func_230999_j_()) {
            this.updateSearch();
            return true;
        }
        return false;
    }

    public boolean keyPressed(GuiMap screen, int keyCode) {
        if (screen.func_241217_q_() == this.filterField) {
            if (keyCode == 257) {
                this.filterField.func_146180_a("");
            }
            this.updateSearch();
            return true;
        }
        return false;
    }

    public void mouseScrolled(int direction) {
        this.scroll(direction);
    }

    public void tick() {
        this.filterField.func_146178_a();
    }

    public void unfocusAll() {
        if (this.filterField != null) {
            this.filterField.func_146195_b(false);
        }
    }

    public void onMenuClosed() {
        this.menuOffset = 0;
        this.searchPattern = null;
        this.searchStartPattern = null;
        this.updateFilteredList();
        this.filterField = null;
    }

    private void scroll(int direction) {
        this.menuOffset += direction;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Pattern getSearchStartPattern() {
        return this.searchStartPattern;
    }

    public void updateFilteredList() {
        Iterator<MapElement<?>> unfiltered = this.getUnfilteredElements();
        if (unfiltered == null) {
            this.filteredElements = null;
            return;
        }
        if (this.filteredElements == null) {
            this.filteredElements = new ArrayList();
        } else {
            this.filteredElements.clear();
        }
        Pattern regex = this.searchPattern;
        Pattern regexStartsWith = this.searchStartPattern;
        while (unfiltered.hasNext()) {
            MapElement<?> e = unfiltered.next();
            if (regex == null) {
                this.filteredElements.add(e);
                continue;
            }
            String filterName = e.getFilterName().toLowerCase();
            if (regexStartsWith.matcher(filterName).find()) {
                this.filteredElements.add(0, e);
                continue;
            }
            if (!regex.matcher(filterName).find()) continue;
            this.filteredElements.add(e);
        }
    }

    public abstract int menuStartPos(int var1);

    public abstract int menuSearchPadding();

    public abstract void renderInMenu(MapElement<?> var1, MatrixStack var2, Screen var3, int var4, int var5, double var6, boolean var8, boolean var9, Minecraft var10, boolean var11, int var12);

    protected abstract String getFilterPlaceholder();

    public abstract Iterator<MapElement<?>> getUnfilteredElements();
}

