/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.datagen.data.recipes.builder;

import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StoneCuttingRecipeBuilder {
    private final Ingredient input;
    private final IItemProvider output;
    private final int count;

    private StoneCuttingRecipeBuilder(Ingredient input, IItemProvider output, int count) {
        this.input = input;
        this.output = output;
        this.count = count;
    }

    public static StoneCuttingRecipeBuilder stoneCuttingRecipe(Ingredient input, IItemProvider output) {
        return StoneCuttingRecipeBuilder.stoneCuttingRecipe(input, output, 1);
    }

    public static StoneCuttingRecipeBuilder stoneCuttingRecipe(Ingredient input, IItemProvider output, int count) {
        return new StoneCuttingRecipeBuilder(input, output, count);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output.func_199767_j()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        id = NameUtil.prefixPath(id, "stonecutting/");
        consumerIn.accept(new Result(id, this.input, this.output.func_199767_j(), this.count));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item result;
        private final int count;

        public Result(ResourceLocation id, Ingredient input, Item output, int count) {
            this.id = id;
            this.ingredient = input;
            this.result = output;
            this.count = count;
        }

        public void func_218610_a(JsonObject jsonObject) {
            jsonObject.add("ingredient", this.ingredient.func_200304_c());
            jsonObject.addProperty("result", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            jsonObject.addProperty("count", (Number)this.count);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222175_s;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation("");
        }
    }
}

