/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicates;
import hellfirepvp.observerlib.api.util.BlockArray;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class TreeDiscoverer {
    @Nonnull
    public static BlockArray findTreeAt(World world, BlockPos at, boolean checkCorners) {
        return TreeDiscoverer.findTreeAt(world, at, checkCorners, -1);
    }

    @Nonnull
    public static BlockArray findTreeAt(World world, BlockPos at, boolean checkCorners, int xzLimit) {
        int xzLimitSq = xzLimit == -1 ? -1 : xzLimit * xzLimit;
        BlockArray out = new BlockArray();
        TreeDiscoverer.findTree(world, at, xzLimitSq, checkCorners, out);
        return out;
    }

    private static void findTree(World world, BlockPos at, int xzLimitSq, boolean checkCorners, BlockArray out) {
        TreeMatch foundTreeType = new TreeMatch();
        Stack<BlockPos> discoverPositions = new Stack<BlockPos>();
        discoverPositions.push(at);
        while (!discoverPositions.isEmpty()) {
            BlockPos offset = (BlockPos)discoverPositions.pop();
            if (world.func_175623_d(offset)) continue;
            BlockState foundState = world.func_180495_p(offset);
            Block foundBlock = foundState.func_177230_c();
            if (foundTreeType.matchLog == null) {
                if (!BlockTags.field_200031_h.func_230235_a_((Object)foundBlock)) {
                    return;
                }
                foundTreeType.matchLog = BlockPredicates.isBlock(foundBlock);
            } else if (foundTreeType.matchLeaf == null && BlockTags.field_206952_E.func_230235_a_((Object)foundBlock)) {
                foundTreeType.matchLeaf = BlockPredicates.isBlock(foundBlock);
            }
            boolean successful = false;
            if (foundTreeType.matchLog.test(world, offset, foundState)) {
                successful = true;
            } else if (foundTreeType.matchLeaf != null && foundTreeType.matchLeaf.test(world, offset, foundState)) {
                successful = true;
            }
            if (!successful) continue;
            out.addBlock(foundState, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
            if (checkCorners) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int yy = -1; yy <= 1; ++yy) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            BlockPos newPos = offset.func_177982_a(xx, yy, zz);
                            if (xzLimitSq != -1 && !(TreeDiscoverer.flatDistanceSq((Vector3i)newPos, (Vector3i)at) <= (double)xzLimitSq) || out.hasBlockAt(newPos)) continue;
                            discoverPositions.push(newPos);
                        }
                    }
                }
                continue;
            }
            for (Direction dir : Direction.values()) {
                BlockPos newPos = offset.func_177972_a(dir);
                if (xzLimitSq != -1 && !(TreeDiscoverer.flatDistanceSq((Vector3i)newPos, (Vector3i)at) <= (double)xzLimitSq) || out.hasBlockAt(newPos)) continue;
                discoverPositions.push(newPos);
            }
        }
    }

    private static double flatDistanceSq(Vector3i from, Vector3i to) {
        double xDiff = (double)from.func_177958_n() - (double)to.func_177958_n();
        double zDiff = (double)from.func_177952_p() - (double)to.func_177952_p();
        return xDiff * xDiff + zDiff * zDiff;
    }

    private static class TreeMatch {
        private BlockPredicate matchLog;
        private BlockPredicate matchLeaf;

        private TreeMatch() {
        }
    }
}

