/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import com.google.common.collect.ImmutableSet;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingAtlasParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.sound.FadeLoopSound;
import hellfirepvp.astralsorcery.client.util.sound.PositionedLoopSound;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusion;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusionContext;
import hellfirepvp.astralsorcery.common.crafting.recipe.infusion.ActiveLiquidInfusionRecipe;
import hellfirepvp.astralsorcery.common.entity.EntityFlare;
import hellfirepvp.astralsorcery.common.item.wand.WandInteractable;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.sound.CategorizedSoundEvent;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.astralsorcery.common.util.tile.TileInventory;
import java.awt.Color;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;

public class TileInfuser
extends TileEntityTick
implements WandInteractable {
    private static final Set<BlockPos> LIQUID_OFFSETS = ImmutableSet.of((Object)new BlockPos(1, -1, 2), (Object)new BlockPos(0, -1, 2), (Object)new BlockPos(-1, -1, 2), (Object)new BlockPos(1, -1, -2), (Object)new BlockPos(0, -1, -2), (Object)new BlockPos(-1, -1, -2), (Object[])new BlockPos[]{new BlockPos(2, -1, 1), new BlockPos(2, -1, 0), new BlockPos(2, -1, -1), new BlockPos(-2, -1, 1), new BlockPos(-2, -1, 0), new BlockPos(-2, -1, -1)});
    private TileInventory inventory;
    private ActiveLiquidInfusionRecipe activeRecipe = null;
    private Set<ResourceLocation> knownRecipes = new HashSet<ResourceLocation>();
    private Object clientCraftSound = null;

    public TileInfuser() {
        super(TileEntityTypesAS.INFUSER);
        this.inventory = new TileInventory((TileEntitySynchronized)this, () -> 1, new Direction[0]);
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        return StructureTypesAS.PTYPE_INFUSER;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            this.doCraftingCycle();
        } else if (this.getActiveRecipe() != null) {
            this.getActiveRecipe().tickClient(this);
            this.doCraftSound();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doCraftSound() {
        if (SoundHelper.getSoundVolume(SoundCategory.BLOCKS) > 0.0f) {
            if (this.clientCraftSound == null || ((PositionedLoopSound)((Object)this.clientCraftSound)).hasStoppedPlaying()) {
                CategorizedSoundEvent sound = SoundsAS.INFUSER_CRAFT_LOOP;
                this.clientCraftSound = ((FadeLoopSound)((Object)SoundHelper.playSoundLoopFadeInClient(sound, new Vector3(this).add(0.5, 0.5, 0.5), 1.0f, 1.0f, false, s -> this.func_145837_r() || SoundHelper.getSoundVolume(SoundCategory.BLOCKS) <= 0.0f || this.getActiveRecipe() == null).setFadeInTicks(30.0f))).setFadeOutTicks(20.0f);
            }
        } else {
            this.clientCraftSound = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void finishCraftingEffects(PktPlayEffect pkt) {
        IRecipe recipe;
        ResourceLocation recipeName = ByteBufUtils.readResourceLocation(pkt.getExtraData());
        BlockPos at = ByteBufUtils.readPos(pkt.getExtraData());
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        TileInfuser thisInfuser = MiscUtils.getTileAt((IBlockReader)world, at, TileInfuser.class, false);
        if (thisInfuser != null && (recipe = (IRecipe)world.func_199532_z().func_215366_a(RecipeTypesAS.TYPE_INFUSION.getType()).get(recipeName)) instanceof LiquidInfusion) {
            FluidStack stack = new FluidStack(((LiquidInfusion)recipe).getLiquidInput(), 1000);
            Vector3 pos = new Vector3((Vector3i)at).add(0.5, 1.0, 0.5);
            for (int i = 0; i < 30; ++i) {
                TileInfuser.playLiquidFinish(pos, stack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playLiquidFinish(Vector3 at, FluidStack stack) {
        Vector3 motion = new Vector3();
        MiscUtils.applyRandomOffset(motion, rand, 0.05f);
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingAtlasParticle)((FXFacingAtlasParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_ATLAS_PARTICLE).spawn(at)).setSprite(RenderingUtils.getParticleTexture(stack))).selectFraction(0.2f)).setScaleMultiplier(0.02f + rand.nextFloat() * 0.05f)).setMotion(motion)).color((fx, pTicks) -> new Color(ColorUtils.getOverlayColor(stack)))).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(40);
    }

    private void doCraftingCycle() {
        if (this.activeRecipe == null) {
            return;
        }
        if (!this.hasMultiblock() || !this.activeRecipe.matches(this)) {
            this.abortCrafting();
            return;
        }
        if (this.activeRecipe.isFinished()) {
            this.finishRecipe();
            return;
        }
        this.activeRecipe.tick();
        this.markForUpdate();
    }

    private void finishRecipe() {
        ResourceLocation recipeName = this.activeRecipe.getRecipeToCraft().func_199560_c();
        ForgeHooks.setCraftingPlayer((PlayerEntity)this.activeRecipe.tryGetCraftingPlayerServer());
        this.activeRecipe.createItemOutputs(this, this::dropItemOnTop);
        this.activeRecipe.consumeInputs(this);
        this.activeRecipe.consumeFluidsInput(this);
        ForgeHooks.setCraftingPlayer(null);
        this.abortCrafting();
        SoundHelper.playSoundAround((SoundEvent)SoundsAS.INFUSER_CRAFT_FINISH, this.func_145831_w(), (Vector3i)this.func_174877_v(), 1.0f, 1.0f);
        PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.INFUSER_RECIPE_FINISH).addData(buf -> {
            ByteBufUtils.writeResourceLocation(buf, recipeName);
            ByteBufUtils.writePos(buf, this.func_174877_v());
        });
        PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos(this.func_145831_w(), (Vector3i)this.func_174877_v(), 32.0));
        EntityFlare.spawnAmbientFlare(this.func_145831_w(), this.func_174877_v().func_177982_a(-3 + rand.nextInt(7), 1 + rand.nextInt(3), -3 + rand.nextInt(7)));
        this.knownRecipes.add(recipeName);
    }

    private void abortCrafting() {
        this.activeRecipe.clearEffects();
        this.activeRecipe = null;
        this.markForUpdate();
    }

    protected LiquidInfusion findRecipe(PlayerEntity crafter) {
        return RecipeTypesAS.TYPE_INFUSION.findRecipe(new LiquidInfusionContext(this, crafter, LogicalSide.SERVER));
    }

    protected boolean startCrafting(LiquidInfusion recipe, PlayerEntity crafter) {
        if (this.getActiveRecipe() != null) {
            return false;
        }
        this.activeRecipe = new ActiveLiquidInfusionRecipe(this.func_145831_w(), this.func_174877_v(), recipe, crafter.func_110124_au());
        this.markForUpdate();
        SoundHelper.playSoundAround((SoundEvent)SoundsAS.INFUSER_CRAFT_START, SoundCategory.BLOCKS, this.field_145850_b, new Vector3(this).add(0.5, 0.5, 0.5), 1.0f, 1.0f);
        return true;
    }

    @Override
    public boolean onInteract(World world, BlockPos pos, PlayerEntity player, Direction side, boolean sneak) {
        if (!world.func_201670_d() && this.hasMultiblock() && !this.getItemInput().func_190926_b()) {
            LiquidInfusion recipe;
            if (this.getActiveRecipe() != null) {
                if (this.getActiveRecipe().matches(this)) {
                    return true;
                }
                this.abortCrafting();
            }
            if ((recipe = this.findRecipe(player)) != null) {
                this.startCrafting(recipe, player);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack getItemInput() {
        return this.inventory.getStackInSlot(0);
    }

    @Nonnull
    public ItemStack setItemInput(@Nonnull ItemStack stack) {
        ItemStack prev = this.getItemInput();
        this.inventory.setStackInSlot(0, stack);
        return prev;
    }

    @Nullable
    public ActiveLiquidInfusionRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    @Nonnull
    public static Set<BlockPos> getLiquidOffsets() {
        return LIQUID_OFFSETS;
    }

    @Nonnull
    public Map<BlockPos, Fluid> getLiquids() {
        return MapStream.ofKeys(TileInfuser.getLiquidOffsets(), pos -> this.func_145831_w().func_204610_c(this.func_174877_v().func_177971_a((Vector3i)pos)).func_206886_c()).toMap();
    }

    @Nonnull
    public Vector3 getRandomInfuserOffset() {
        Vector3 vec = new Vector3(this).add(0.0, 0.8, 0.0);
        switch (rand.nextInt(4)) {
            case 3: {
                vec.add(0.5, 0.0, 0.875);
                break;
            }
            case 2: {
                vec.add(0.5, 0.0, 0.125);
                break;
            }
            case 1: {
                vec.add(0.125, 0.0, 0.5);
                break;
            }
            case 0: {
                vec.add(0.875, 0.0, 0.5);
            }
        }
        return vec;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.inventory = this.inventory.deserialize(compound.func_74775_l("inventory"));
        this.knownRecipes = NBTHelper.readSet(compound, "knownRecipes", 8, nbt -> new ResourceLocation(nbt.func_150285_a_()));
        if (compound.func_150297_b("activeRecipe", 10)) {
            this.activeRecipe = ActiveLiquidInfusionRecipe.deserialize(compound.func_74775_l("activeRecipe"), this.activeRecipe);
        } else {
            if (this.activeRecipe != null) {
                this.activeRecipe.clearEffects();
            }
            this.activeRecipe = null;
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serialize());
        NBTHelper.writeList(compound, "knownRecipes", this.knownRecipes, key -> StringNBT.func_229705_a_((String)key.toString()));
        if (this.activeRecipe != null) {
            compound.func_218657_a("activeRecipe", (INBT)this.activeRecipe.serialize());
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.inventory.hasCapability(cap, side)) {
            return this.inventory.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

