/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.block.tile.BlockFlareLight;
import hellfirepvp.astralsorcery.common.entity.EntityFlare;
import hellfirepvp.astralsorcery.common.item.wand.ItemIlluminationWand;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileIlluminator
extends TileEntityTick {
    public static final LightCheck ILLUMINATOR_CHECK = new LightCheck();
    public static final int SEARCH_RADIUS = 64;
    public static final int STEP_WIDTH = 2;
    private List<List<BlockPos>> layerPositions = null;
    private boolean doRecalculation = false;
    private int ticksUntilNextPlacement = 180;
    private boolean playerPlaced = false;
    private int boostedTicks = 0;
    private DyeColor color = DyeColor.YELLOW;

    public TileIlluminator() {
        super(TileEntityTypesAS.ILLUMINATOR);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.isPlayerPlaced()) {
            return;
        }
        if (!this.field_145850_b.func_201670_d()) {
            if (this.layerPositions == null) {
                this.recalculate();
            }
            this.placeFlare();
            this.placeFlare();
            this.placeFlare();
            if (rand.nextInt(3) == 0 && this.placeFlare()) {
                this.doRecalculation = true;
            }
            if (this.boostedTicks > 0) {
                --this.boostedTicks;
            }
            --this.ticksUntilNextPlacement;
            if (this.ticksUntilNextPlacement <= 0) {
                int n = this.ticksUntilNextPlacement = this.boostedTicks > 0 ? 30 : 180;
                if (this.doRecalculation) {
                    this.doRecalculation = false;
                    this.recalculate();
                }
            }
        }
        if (this.field_145850_b.func_201670_d()) {
            this.tickEffects();
        }
    }

    private void recalculate() {
        int height = Math.max(0, this.func_174877_v().func_177956_o() - 7);
        int parts = height / 7;
        this.layerPositions = new ArrayList<List<BlockPos>>(parts);
        for (int i = 0; i < parts; ++i) {
            int yPart = 3 + i * 7;
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            this.generatePositions(positions, new BlockPos(this.func_174877_v().func_177958_n(), yPart, this.func_174877_v().func_177952_p()));
            this.layerPositions.add(positions);
        }
    }

    private void generatePositions(List<BlockPos> positions, BlockPos center) {
        int xPos = center.func_177958_n();
        int yPos = center.func_177956_o();
        int zPos = center.func_177952_p();
        BlockPos currentPos = center;
        if (!positions.contains(currentPos)) {
            positions.add(currentPos);
        }
        Direction dir = Direction.NORTH;
        while (Math.abs(currentPos.func_177958_n() - xPos) <= 64 && Math.abs(currentPos.func_177956_o() - yPos) <= 64 && Math.abs(currentPos.func_177952_p() - zPos) <= 64) {
            Direction tryDirNext;
            if (!positions.contains(currentPos = currentPos.func_177967_a(dir, 2))) {
                positions.add(currentPos);
            }
            if (positions.contains(currentPos.func_177967_a(tryDirNext = dir.func_176746_e(), 2))) continue;
            dir = tryDirNext;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEffects() {
        if (!this.doesSeeSky() && this.boostedTicks <= 0) {
            return;
        }
        FXFacingParticle p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(this).add(0.5, 0.5, 0.5))).setScaleMultiplier(0.25f)).setMotion(new Vector3(rand.nextFloat() * 0.025f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.025f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.025f * (float)(rand.nextBoolean() ? 1 : -1)));
        Color c = ColorUtils.flareColorFromDye(this.getColor());
        p.color(VFXColorFunction.constant(MiscUtils.eitherOf(rand, Color.WHITE, c.brighter().brighter(), c)));
        if (this.boostedTicks > 0 && this.ticksExisted % 4 == 0) {
            List<Vector3> positions = MiscUtils.getCirclePositions(new Vector3(this).add(0.5, 0.5, 0.5), Vector3.RotAxis.Y_AXIS, 0.8f + rand.nextFloat() * 0.1f, 20 + rand.nextInt(10));
            for (Vector3 v : positions) {
                p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(v)).setScaleMultiplier(0.15f)).setMotion(new Vector3(0.0, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.01, 0.0));
                p.color(VFXColorFunction.constant(MiscUtils.eitherOf(rand, Color.WHITE, c.brighter().brighter(), c)));
            }
        }
    }

    private boolean placeFlare() {
        boolean recalc = false;
        for (List<BlockPos> list : this.layerPositions) {
            if (list.isEmpty()) {
                recalc = true;
                continue;
            }
            int index = rand.nextInt(list.size());
            BlockPos at = list.remove(index);
            if (!recalc && list.isEmpty()) {
                recalc = true;
            }
            at = at.func_177982_a(rand.nextInt(5) - 2, rand.nextInt(13) - 6, rand.nextInt(5) - 2);
            MiscUtils.executeWithChunk((IWorldReader)this.field_145850_b, at, at, pos -> {
                if (this.doesSeeSky() && ILLUMINATOR_CHECK.test(this.field_145850_b, (BlockPos)pos, this.field_145850_b.func_180495_p(pos))) {
                    DyeColor color = this.getColor();
                    BlockState toPlace = (BlockState)BlocksAS.FLARE_LIGHT.func_176223_P().func_206870_a(BlockFlareLight.COLOR, (Comparable)color);
                    if (this.field_145850_b.func_175656_a(pos, toPlace)) {
                        EntityFlare.spawnAmbientFlare(this.field_145850_b, this.func_174877_v());
                    }
                }
            });
        }
        return recalc;
    }

    public void setColor(DyeColor color) {
        this.color = color;
        this.markForUpdate();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setPlayerPlaced(boolean playerPlaced) {
        this.playerPlaced = playerPlaced;
        this.markForUpdate();
    }

    public boolean isPlayerPlaced() {
        return this.playerPlaced;
    }

    public void onWandUsed(ItemStack stack) {
        this.boostedTicks = 12000;
        this.setColor(ItemIlluminationWand.getConfiguredColor(stack));
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("playerPlaced", this.playerPlaced);
        compound.func_74768_a("color", this.color.func_196059_a());
        compound.func_74768_a("boostedTicks", this.boostedTicks);
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.playerPlaced = compound.func_74767_n("playerPlaced");
        this.color = DyeColor.func_196056_a((int)compound.func_74762_e("color"));
        this.boostedTicks = compound.func_74762_e("boostedTicks");
    }

    public static class LightCheck
    implements BlockPredicate {
        @Override
        public boolean test(World world, BlockPos pos, BlockState state) {
            return world.func_175623_d(pos) && !MiscUtils.canSeeSky(world, pos, false, false) && world.func_201696_r(pos) < 8 && world.func_226658_a_(LightType.SKY, pos) < 4;
        }
    }
}

