/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.storage;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class StorageNetwork {
    private CoreArea master = null;
    private final Map<BlockPos, AxisAlignedBB> cores = Maps.newHashMap();

    public boolean setMaster(@Nullable BlockPos pos) {
        if (pos == null) {
            this.master = null;
            return true;
        }
        if (this.cores.containsKey(pos)) {
            this.master = new CoreArea(pos, this.cores.get(pos));
            return true;
        }
        return false;
    }

    @Nullable
    public CoreArea getMaster() {
        return this.master;
    }

    public boolean addCore(BlockPos pos, AxisAlignedBB box) {
        return this.cores.put(pos, box) == null;
    }

    public boolean removeCore(BlockPos pos) {
        return this.cores.remove(pos) != null;
    }

    public List<CoreArea> getCores() {
        return MapStream.of(this.cores).toList((x$0, x$1) -> new CoreArea((BlockPos)x$0, (AxisAlignedBB)x$1));
    }

    public void writeToNBT(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        for (CoreArea coreData : this.getCores()) {
            CompoundNBT coreTag = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(coreData.getPos(), coreTag);
            NBTHelper.writeBoundingBox(coreData.getOffsetBox(), coreTag);
            list.add((Object)coreTag);
        }
        tag.func_218657_a("cores", (INBT)list);
        CoreArea master = this.getMaster();
        if (master != null) {
            NBTHelper.setAsSubTag(tag, "master", nbt -> NBTHelper.writeBlockPosToNBT(master.getPos(), nbt));
        }
    }

    public void readFromNBT(CompoundNBT tag) {
        this.cores.clear();
        ListNBT list = tag.func_150295_c("cores", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT coreTag = list.func_150305_b(i);
            BlockPos pos = NBTHelper.readBlockPosFromNBT(coreTag);
            AxisAlignedBB box = NBTHelper.readBoundingBox(coreTag);
            this.addCore(pos, box);
        }
        this.setMaster(NBTHelper.readFromSubTag(tag, "master", NBTHelper::readBlockPosFromNBT));
    }

    public static class CoreArea {
        private final BlockPos pos;
        private final AxisAlignedBB offsetBox;

        private CoreArea(BlockPos pos, AxisAlignedBB offsetBox) {
            this.pos = pos;
            this.offsetBox = offsetBox;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public AxisAlignedBB getOffsetBox() {
            return this.offsetBox;
        }

        public AxisAlignedBB getRealBox() {
            return this.offsetBox.func_186670_a(this.getPos());
        }
    }
}

