/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.interaction;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.InteractionResult;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.ResultDropItem;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.ResultSpawnEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class InteractionResultRegistry {
    public static final ResourceLocation ID_DROP_ITEM = AstralSorcery.key("drop_item");
    public static final ResourceLocation ID_SPAWN_ENTITY = AstralSorcery.key("spawn_entity");
    private static final Map<ResourceLocation, Supplier<InteractionResult>> interactionRegistry = new HashMap<ResourceLocation, Supplier<InteractionResult>>();

    private InteractionResultRegistry() {
    }

    public static void register(ResourceLocation key, Supplier<InteractionResult> supplier) {
        interactionRegistry.put(key, supplier);
    }

    public static Collection<ResourceLocation> getKeys() {
        return interactionRegistry.keySet();
    }

    public static Collection<String> getKeysAsStrings() {
        return interactionRegistry.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    @Nullable
    public static InteractionResult create(ResourceLocation key) {
        if (!interactionRegistry.containsKey(key)) {
            return null;
        }
        return interactionRegistry.get(key).get();
    }

    static {
        InteractionResultRegistry.register(ID_DROP_ITEM, ResultDropItem::new);
        InteractionResultRegistry.register(ID_SPAWN_ENTITY, ResultSpawnEntity::new);
    }
}

