/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.builder;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeBuilder;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.BlockTransmutation;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import hellfirepvp.astralsorcery.common.util.block.BlockMatchInformation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlockTransmutationBuilder
extends CustomRecipeBuilder<BlockTransmutation> {
    private final ResourceLocation id;
    private BlockState outputState = Blocks.field_150350_a.func_176223_P();
    private double starlight = 200.0;
    private IWeakConstellation constellation = null;
    private ItemStack outputDisplay = ItemStack.field_190927_a;
    private final List<BlockMatchInformation> stateCheck = new ArrayList<BlockMatchInformation>();

    private BlockTransmutationBuilder(ResourceLocation id) {
        this.id = id;
    }

    public static BlockTransmutationBuilder builder(ForgeRegistryEntry<?> nameProvider) {
        return new BlockTransmutationBuilder(AstralSorcery.key(nameProvider.getRegistryName().func_110623_a()));
    }

    public static BlockTransmutationBuilder builder(ResourceLocation id) {
        return new BlockTransmutationBuilder(id);
    }

    public BlockTransmutationBuilder multiplyStarlightCost(float multiply) {
        this.starlight *= (double)multiply;
        return this;
    }

    public BlockTransmutationBuilder setStarlightCost(double starlight) {
        this.starlight = starlight;
        return this;
    }

    public BlockTransmutationBuilder setConstellation(IWeakConstellation constellation) {
        this.constellation = constellation;
        return this;
    }

    public BlockTransmutationBuilder addInputCheck(Block matchBlock) {
        return this.addInputCheck(matchBlock.func_176223_P());
    }

    public BlockTransmutationBuilder addInputCheck(BlockState matchState) {
        return this.addInputCheck(matchState, false);
    }

    public BlockTransmutationBuilder addInputCheck(BlockState matchState, boolean matchExact) {
        return this.addInputCheck(matchState, new ItemStack((IItemProvider)matchState.func_177230_c()), matchExact);
    }

    public BlockTransmutationBuilder addInputCheck(BlockState matchState, IItemProvider display, boolean matchExact) {
        return this.addInputCheck(matchState, new ItemStack(display), matchExact);
    }

    public BlockTransmutationBuilder addInputCheck(BlockState matchState, ItemStack display, boolean matchExact) {
        this.stateCheck.add(new BlockMatchInformation(matchState, display, matchExact));
        return this;
    }

    public BlockTransmutationBuilder setOutput(Block output) {
        return this.setOutput(output.func_176223_P());
    }

    public BlockTransmutationBuilder setOutput(BlockState outputState) {
        this.outputState = outputState;
        this.outputDisplay = new ItemStack((IItemProvider)outputState.func_177230_c());
        return this;
    }

    public BlockTransmutationBuilder setOutputDisplay(IItemProvider item) {
        return this.setOutputDisplay(new ItemStack(item));
    }

    public BlockTransmutationBuilder setOutputDisplay(ItemStack stack) {
        this.outputDisplay = stack.func_77946_l();
        return this;
    }

    @Override
    @Nonnull
    protected BlockTransmutation validateAndGet() {
        if (this.stateCheck.isEmpty()) {
            throw new IllegalArgumentException("No block input checks!");
        }
        for (BlockMatchInformation inputMatch : this.stateCheck) {
            if (!(inputMatch.getMatchState().func_177230_c() instanceof AirBlock)) continue;
            throw new IllegalArgumentException("A block transmutation must not convert 'air' into something!");
        }
        BlockTransmutation tr = new BlockTransmutation(this.id, this.outputState, this.starlight, this.constellation);
        this.stateCheck.forEach(tr::addInputOption);
        tr.setOutputDisplay(this.outputDisplay);
        return tr;
    }

    @Override
    protected CustomRecipeSerializer<BlockTransmutation> getSerializer() {
        return RecipeSerializersAS.BLOCK_TRANSMUTATION_SERIALIZER;
    }
}

