/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectDiscidia
extends MantleEffect {
    public static DiscidiaConfig CONFIG = new DiscidiaConfig();

    public MantleEffectDiscidia() {
        super(ConstellationsAS.discidia);
    }

    @Override
    protected void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(this::onAttack);
        bus.addListener(EventPriority.HIGHEST, this::onHurt);
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        float effChance = 0.1f;
        if (this.getLastAttackDamage((LivingEntity)player) > 0.0f) {
            effChance = 0.2f;
        }
        this.playCapeSparkles(player, effChance);
    }

    private void onAttack(LivingAttackEvent event) {
        LivingEntity attacked = event.getEntityLiving();
        World world = attacked.func_130014_f_();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (world.func_201670_d()) {
            return;
        }
        if (attacker instanceof PlayerEntity) {
            if (attacked instanceof ServerPlayerEntity && MiscUtils.isPlayerFakeMP((ServerPlayerEntity)attacked)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)attacker;
            MantleEffectDiscidia eff = (MantleEffectDiscidia)((Object)ItemMantle.getEffect((LivingEntity)player, (IWeakConstellation)ConstellationsAS.discidia));
            if (eff != null) {
                EventFlags.MANTLE_DISCIDIA_ADDED.executeWithFlag(() -> {
                    float added = this.getLastAttackDamage((LivingEntity)player);
                    if (added > 0.1f && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectDiscidia.CONFIG.chargeCostPerAttack.get()).intValue())) {
                        DamageUtil.shotgunAttack(attacked, entity -> DamageUtil.attackEntityFrom((Entity)entity, CommonProxy.DAMAGE_SOURCE_STELLAR, added / 2.0f));
                        DamageUtil.shotgunAttack(attacked, entity -> DamageUtil.attackEntityFrom((Entity)entity, DamageSource.func_76365_a((PlayerEntity)player), added / 2.0f, (Entity)player));
                        AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectDiscidia.CONFIG.chargeCostPerAttack.get()).intValue(), false);
                    }
                });
            }
        }
    }

    private void onHurt(LivingHurtEvent event) {
        World world = event.getEntity().func_130014_f_();
        LivingEntity hurt = event.getEntityLiving();
        if (world.func_201670_d()) {
            return;
        }
        MantleEffectDiscidia armara = (MantleEffectDiscidia)((Object)ItemMantle.getEffect(hurt, (IWeakConstellation)ConstellationsAS.discidia));
        if (armara != null) {
            this.writeLastAttackDamage(hurt, event.getAmount());
        }
    }

    public void writeLastAttackDamage(LivingEntity entity, float dmgIn) {
        this.getData(entity).func_74776_a("lastAttack", dmgIn);
    }

    public float getLastAttackDamage(LivingEntity entity) {
        return this.getData(entity).func_74760_g("lastAttack") * ((Double)MantleEffectDiscidia.CONFIG.damageMultiplier.get()).floatValue();
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    public static class DiscidiaConfig
    extends MantleEffect.Config {
        private final double defaultDamageMultiplier = 1.5;
        private final int defaultChargeCostPerAttack = 100;
        public ForgeConfigSpec.DoubleValue damageMultiplier;
        public ForgeConfigSpec.IntValue chargeCostPerAttack;

        public DiscidiaConfig() {
            super("discidia");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.damageMultiplier = cfgBuilder.comment("Sets the multiplier for how much of the received damage is converted into additional damage.").translation(this.translationKey("damageMultiplier")).defineInRange("damageMultiplier", this.defaultDamageMultiplier, 0.0, 100.0);
            this.chargeCostPerAttack = cfgBuilder.comment("Set the amount alignment charge consumed per attack enhanced by the mantle").translation(this.translationKey("chargeCostPerAttack")).defineInRange("chargeCostPerAttack", this.defaultChargeCostPerAttack, 0, 1000);
        }
    }
}

